/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata;

import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IndexDbConsistencyChecker
extends TimerTaskBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String XML_EXTENSION = "xml";
    private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final File connectionFilesDir = new File(this.sysDirInfo.getDataDirectory() + File.separator + "connections");
    private final File oauthClientFilesDir = new File(this.sysDirInfo.getDataDirectory() + File.separator + "oauth-clients");

    @Override
    public void doTask() throws Exception {
        this.checkConnections();
        this.checkOAuthClients();
    }

    private void checkConnections() {
        int numConnectionsFromDb = MgmtFactory.getConnectionDb().getEntryCount();
        int numConnectionFilesFromDisk = FileUtils.listFiles((File)this.connectionFilesDir, (String[])new String[]{XML_EXTENSION}, (boolean)true).size();
        if (numConnectionsFromDb != numConnectionFilesFromDisk) {
            this.log.warn((Object)String.format("Number of connection files found (%d) is different from the number of connections stored in index database (%d).", numConnectionFilesFromDisk, numConnectionsFromDb));
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Completed connections index database integrity check. Found %d connection files and %d connections stored in index database.", numConnectionFilesFromDisk, numConnectionsFromDb));
        }
    }

    private void checkOAuthClients() {
        if (!this.clientManager.isBackendDatabase()) {
            int numClientsFromDb = MgmtFactory.getOAuthClientIndexDb().getEntryCount();
            int numClientFilesFromDisk = FileUtils.listFiles((File)this.oauthClientFilesDir, (String[])new String[]{XML_EXTENSION}, (boolean)true).size();
            if (numClientsFromDb != numClientFilesFromDisk) {
                this.log.warn((Object)String.format("Number of OAuth client files found (%d) is different from the number of clients stored in index database (%d).", numClientFilesFromDisk, numClientsFromDb));
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("Completed OAuth clients index database integrity check. Found %d client files and %d clients stored in index database.", numClientFilesFromDisk, numClientsFromDb));
            }
        }
    }
}

