/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.local;

import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import org.sourceid.saml20.domain.ConnectionExpirationData;
import org.sourceid.saml20.metadata.local.IDPLocalPathMappings;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;

public final class MetadataLocalHelper {
    public static final String OUTBOUND_PROV_MODULE_ID = "SaasProvisioner";

    private MetadataLocalHelper() {
    }

    public static String getSpSsoSuccessUrl(MetadataLocal metadataLocal) {
        return metadataLocal.getApplicationURL("sp.after.sso");
    }

    public static String getSpSloSuccessUrl(MetadataLocal metadataLocal) {
        return metadataLocal.getApplicationURL("sp.after.slo");
    }

    public static String getSpInitiateSsoPath(MetadataLocal metadataLocal) {
        SPLocalPathMappings spLocalPathMappings = metadataLocal.getSpLocalPathMappings();
        return spLocalPathMappings.getInitiateSSOPath();
    }

    public static String getIdpInitiateSloPath(MetadataLocal metadataLocal) {
        IDPLocalPathMappings idpLocalPathMappings = metadataLocal.getIdpLocalPathMappings();
        return idpLocalPathMappings.getInitiateSLOPath();
    }

    public static boolean isEnableIdp(MetadataLocal metadataLocal) {
        return metadataLocal.getEnableIdpWsTrustSts() || metadataLocal.getEnableWsFedIdP() || metadataLocal.getEnableSaml20IdP() || metadataLocal.getEnableSaml11Ap() || metadataLocal.getEnableSaml10Ap() || MetadataLocalHelper.isEnableOutboundProvisioning();
    }

    public static boolean isEnableSp(MetadataLocal metadataLocal) {
        return metadataLocal.getEnableSpWsTrustSts() || metadataLocal.getEnableWsFedSp() || metadataLocal.getEnableSaml20Sp() || metadataLocal.getEnableSaml11Rp() || metadataLocal.getEnableSaml10Rp() || metadataLocal.getEnableInboundProvisioning() || metadataLocal.getEnableOIDCSp();
    }

    public static ConnectionExpirationData getConnectionExpirationData(MetadataLocal metadataLocal) {
        ConnectionExpirationData metaExpirationData = new ConnectionExpirationData();
        if (metadataLocal.getCacheDuration() != null) {
            metaExpirationData.setCacheGDuration(metadataLocal.getCacheDuration());
        }
        return metaExpirationData;
    }

    public static boolean isEnableFederationHub(MetadataLocal metadataLocal) {
        return MetadataLocalHelper.isEnableBrowserSsoProfileIdP(metadataLocal) && MetadataLocalHelper.isEnableBrowserSsoProfileSP(metadataLocal);
    }

    public static ConnectionModuleGlobalConfiguration getOutboundProvisioning() {
        return ConnectionModuleSupport.getInstance().getGlobalConfigurations().stream().filter(module -> OUTBOUND_PROV_MODULE_ID.equals(module.getModuleId())).findFirst().orElse(null);
    }

    private static boolean isEnableOutboundProvisioning() {
        return ConnectionModuleSupport.getInstance().getGlobalConfigurations().stream().anyMatch(module -> OUTBOUND_PROV_MODULE_ID.equals(module.getModuleId()));
    }

    private static boolean isEnableBrowserSsoProfileIdP(MetadataLocal metadataLocal) {
        return metadataLocal.getEnableWsFedIdP() || metadataLocal.getEnableSaml20IdP() || metadataLocal.getEnableSaml11Ap() || metadataLocal.getEnableSaml10Ap();
    }

    private static boolean isEnableBrowserSsoProfileSP(MetadataLocal metadataLocal) {
        return metadataLocal.getEnableWsFedSp() || metadataLocal.getEnableSaml20Sp() || metadataLocal.getEnableSaml11Rp() || metadataLocal.getEnableSaml10Rp();
    }
}

