/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.local.impl;

import com.pingidentity.common.util.FieldObfuscator;
import java.math.BigInteger;
import org.sourceid.saml20.domain.CommonDomainClient;
import org.sourceid.saml20.domain.CommonDomainService;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.CommonDomainClientType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.CommonDomainServiceType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.ExtensionRootType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.IdpDiscoveryType;

public class MetadataLocalUtil {
    public static IdpDiscovery getIdpDiscovery(IdpDiscoveryType idpDiscoveryType) {
        IdpDiscovery idpDiscovery = new IdpDiscovery();
        if (idpDiscoveryType != null) {
            CommonDomainServiceType commonDomainServiceType;
            CommonDomainClientType commonDomainClientType;
            idpDiscovery.setCommonDomainServer(idpDiscoveryType.getCommonDomainServer());
            idpDiscovery.setIdpCommonDomainClient(idpDiscoveryType.getIdPCommonDomainClient());
            idpDiscovery.setSpCommonDomainClient(idpDiscoveryType.getSPCommonDomainClient());
            if (idpDiscoveryType.isSetWriteCookiePath()) {
                idpDiscovery.setWriteCookiePath(idpDiscoveryType.getWriteCookiePath());
            }
            if (idpDiscoveryType.isSetReadCookiePath()) {
                idpDiscovery.setReadCookiePath(idpDiscoveryType.getReadCookiePath());
            }
            if ((commonDomainClientType = idpDiscoveryType.getCommonDomainClient()) != null) {
                CommonDomainClient commonDomainClient = idpDiscovery.getCommonDomainClient();
                commonDomainClient.setCommonDomainServiceBaseUrl(commonDomainClientType.getCommonDomainServiceBaseUrl());
                commonDomainClient.setPassPhrase(FieldObfuscator.REAL.deobfuscate(commonDomainClientType.getPassphrase()));
            }
            if ((commonDomainServiceType = idpDiscoveryType.getCommonDomainService()) != null) {
                CommonDomainService commonDomainService = idpDiscovery.getCommonDomainService();
                commonDomainService.setCommonDomain(commonDomainServiceType.getCommonDomain());
                commonDomainService.setCookieLifeDays(commonDomainServiceType.getCookieLifeDays().intValue());
                commonDomainService.setPassPhrase(FieldObfuscator.REAL.deobfuscate(commonDomainServiceType.getPassphrase()));
            }
        }
        return idpDiscovery;
    }

    public static void setIdpDiscovery(ExtensionRootType extensionRootType, IdpDiscovery idpDiscovery) {
        if (idpDiscovery != null) {
            CommonDomainService service;
            if (extensionRootType.isSetIdpDiscovery()) {
                extensionRootType.unsetIdpDiscovery();
            }
            IdpDiscoveryType idpDiscoveryType = extensionRootType.addNewIdpDiscovery();
            idpDiscoveryType.setCommonDomainServer(idpDiscovery.isCommonDomainServer());
            idpDiscoveryType.setIdPCommonDomainClient(idpDiscovery.isIdpCommonDomainClient());
            idpDiscoveryType.setSPCommonDomainClient(idpDiscovery.isSpCommonDomainClient());
            idpDiscoveryType.setWriteCookiePath(idpDiscovery.getWriteCookiePath());
            idpDiscoveryType.setReadCookiePath(idpDiscovery.getReadCookiePath());
            CommonDomainClient client = idpDiscovery.getCommonDomainClient();
            if (client != null) {
                CommonDomainClientType commonDomainClientType = idpDiscoveryType.addNewCommonDomainClient();
                commonDomainClientType.setCommonDomainServiceBaseUrl(client.getCommonDomainServiceBaseUrl());
                if (client.getPassPhrase() != null) {
                    commonDomainClientType.setPassphrase(FieldObfuscator.REAL.obfuscate(client.getPassPhrase()));
                }
            }
            if ((service = idpDiscovery.getCommonDomainService()) != null) {
                CommonDomainServiceType cdsType = idpDiscoveryType.addNewCommonDomainService();
                cdsType.setCommonDomain(service.getCommonDomain());
                cdsType.setCookieLifeDays(new BigInteger(Integer.toString(service.getCookieLifeDays())));
                if (service.getPassPhrase() != null) {
                    cdsType.setPassphrase(FieldObfuscator.REAL.obfuscate(service.getPassPhrase()));
                }
            }
        }
    }
}

