/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.DataSourceParameter;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeSourceType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeSourceTypeParameterType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.BinaryAttributeEncodingType;

public class AttributeSourceConfigHelper {
    public static void fillInAttributeSource(AttributeSourceType attributeSourceType, AttributeSource attributeSource) {
        String id = attributeSource.getId();
        if (StringUtils.isNotEmpty((String)id)) {
            attributeSourceType.setId(id);
        }
        attributeSourceType.setDescription(attributeSource.getDescription());
        attributeSourceType.setType(attributeSource.getType());
        if (attributeSource.getDataSource() != null) {
            attributeSourceType.setDataSourceId(attributeSource.getDataSource().getId());
        }
        boolean isJDBC = DataSource.DSType.JDBC.getName().equalsIgnoreCase(attributeSource.getType());
        DataSourceParameter[] params = attributeSource.getParameterArray();
        if (params != null) {
            for (DataSourceParameter param : params) {
                AttributeSourceTypeParameterType paramType = attributeSourceType.addNewParameter();
                String paramName = param.getName();
                paramType.setName(paramName);
                String paramVal = param.getValue();
                if (isJDBC && "filter".equals(paramName)) {
                    paramVal = AttributeSourceConfigHelper.stripWhereKeyword(paramVal);
                }
                paramType.setValue(paramVal);
            }
        }
        for (Map.Entry entry : attributeSource.getAttributeEncodingTypeMap().entrySet()) {
            BinaryAttributeEncodingType attrType = attributeSourceType.addNewBinaryAttributeEncoding();
            attrType.setName((String)entry.getKey());
            attrType.setEncoding((String)entry.getValue());
        }
    }

    private static String stripWhereKeyword(String filter) {
        String tmpFilter = filter.trim().toLowerCase();
        String whereClaus = tmpFilter.startsWith("where ") ? filter.trim().substring(6) : filter;
        return whereClaus;
    }

    public static AttributeSource createAttributeSourceFromXML(AttributeSourceType attribSourceType) {
        BinaryAttributeEncodingType[] encodingTypes;
        String dataSourceId = attribSourceType.getDataSourceId();
        String description = attribSourceType.getDescription();
        String type = attribSourceType.getType();
        String id = attribSourceType.getId();
        if (StringUtils.isEmpty((String)description)) {
            description = type;
        }
        AttributeSource attribSource = AttributeSourceFactory.getAttributeSource(type, description, dataSourceId, id);
        AttributeSourceTypeParameterType[] params = attribSourceType.getParameterArray();
        if (params != null) {
            for (AttributeSourceTypeParameterType param : params) {
                attribSource.setParameter(param.getName(), param.getValue());
            }
        }
        if ((encodingTypes = attribSourceType.getBinaryAttributeEncodingArray()) != null) {
            for (BinaryAttributeEncodingType attrDataType : encodingTypes) {
                attribSource.setAttributeEncodingType(attrDataType.getName(), attrDataType.getEncoding());
            }
        }
        if (!StringUtils.isBlank((String)dataSourceId)) {
            attribSource.setDataSourceId(dataSourceId);
        }
        return attribSource;
    }
}

