/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner;

import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.util.Defense;
import org.sourceid.websso.wrapper.BaseMessageContext;

public class MetadataSupport {
    public static ConnectionBase getBaseConnectionMetadata(String entityId, Role role) {
        ConnectionBase connBase;
        Defense.notNull((Object)role, "BaseMessageContext.Role role cannot be null when looking up a ConnectionBase");
        MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
        if (role == Role.SP) {
            connBase = metadataDirectory.getSpConnection(entityId, false);
            if (connBase == null) {
                throw new ConfigurationException("Unable to lookup sp connection metadata for entityid='" + entityId + "'");
            }
        } else {
            connBase = metadataDirectory.getIdpConnection(entityId, false);
            if (connBase == null) {
                throw new ConfigurationException("Unable to lookup idp connection metadata for entityid='" + entityId + "'");
            }
        }
        return connBase;
    }

    private static ConnectionBase getStaticBaseConnectionMetadata(String entityId, Role role) {
        Defense.notNull((Object)role, "BaseMessageContext.Role role cannot be null when looking up a ConnectionBase");
        MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
        ConnectionBase connBase = role == Role.SP ? metadataDirectory.getSpConnection(entityId, false) : metadataDirectory.getIdpConnection(entityId, false);
        if (connBase == null) {
            throw new ConfigurationException("No " + role + " connection found for entityid='" + entityId + "'");
        }
        return connBase;
    }

    public static ConnectionBase getBaseConnectionMetadata(BaseMessageContext msgCtx) {
        ConnectionBase conn = null;
        conn = msgCtx.getBinding() == null || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(msgCtx.getBinding()) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(msgCtx.getBinding()) ? MetadataSupport.getBaseConnectionMetadata(msgCtx.getEntityId(), msgCtx.getRoleType()) : MetadataSupport.getStaticBaseConnectionMetadata(msgCtx.getEntityId(), msgCtx.getRoleType());
        return conn;
    }

    public static IdpConnection getIdpConnection(String entityId) {
        return (IdpConnection)MetadataSupport.getBaseConnectionMetadata(entityId, Role.IDP);
    }

    public static SpConnection getSpConnection(String entityId) {
        return (SpConnection)MetadataSupport.getBaseConnectionMetadata(entityId, Role.SP);
    }
}

