/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.RoleDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.PFNoopRoleDescriptorType;
import org.sourceid.websso.Protocol;

public class ProtocolUtil {
    private static final String NOOP_PROTOCOL = "pingfederate:protocol:noop";
    private static final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    static void setProtocolOnXml(RoleDescriptorType desc, ConnectionBase conn) {
        if (desc instanceof PFNoopRoleDescriptorType) {
            ArrayList<String> protocolList = new ArrayList<String>();
            protocolList.add(NOOP_PROTOCOL);
            desc.setProtocolSupportEnumeration(protocolList);
        } else {
            Protocol protocol = conn.getProtocol();
            desc.setProtocolSupportEnumeration(protocol.getProtoSupportList());
        }
    }

    static void setProtocolOnDomain(EntityDescriptorType desc, ConnectionBase conn) {
        ProtocolUtil.setProtoFromXmlArray(desc.getRoleDescriptorArray(), conn);
        ProtocolUtil.setProtoFromXmlArray((RoleDescriptorType[])desc.getAttributeAuthorityDescriptorArray(), conn);
        ProtocolUtil.setProtoFromXmlArray((RoleDescriptorType[])desc.getSPSSODescriptorArray(), conn);
        ProtocolUtil.setProtoFromXmlArray((RoleDescriptorType[])desc.getIDPSSODescriptorArray(), conn);
    }

    private static void setProtoFromXmlArray(RoleDescriptorType[] roleDescs, ConnectionBase conn) {
        if (roleDescs.length > 0) {
            for (RoleDescriptorType roleDescriptorType : roleDescs) {
                ProtocolUtil.setProtocolOnDomain(roleDescriptorType, conn);
            }
        }
    }

    static void setProtocolOnDomain(RoleDescriptorType desc, ConnectionBase conn) {
        Protocol protocol = ProtocolUtil.getProtocol(desc);
        if (protocol != null) {
            conn.setProtocol(protocol);
        }
        conn.setProtocolsSupportedByPartner(ProtocolUtil.getSupportedProtocols(desc));
    }

    public static Protocol getProtocol(RoleDescriptorType desc) {
        List protocolSupportList = desc.getProtocolSupportEnumeration();
        Object o = protocolSupportList.iterator().next();
        String protoUriString = (String)o;
        return Protocol.fromProtocolUri(protoUriString);
    }

    private static Set<Protocol> getSupportedProtocols(RoleDescriptorType desc) {
        HashSet<Protocol> protocols = null;
        List protocolSupportList = desc.getProtocolSupportEnumeration();
        if (protocolSupportList != null && !protocolSupportList.isEmpty()) {
            protocols = new HashSet<Protocol>();
            for (String protocolSupport : protocolSupportList) {
                Protocol protocol = Protocol.fromProtocolUri(protocolSupport);
                if (protocol == null) continue;
                protocols.add(protocol);
            }
        }
        if (protocols == null || protocols.isEmpty()) {
            return null;
        }
        return protocols;
    }

    public static VirtualIdentity getGlobalDefaultVirtualId(ConnectionBase connectionBase) {
        String entityId;
        byte[] srcId = null;
        switch (connectionBase.getProtocol()) {
            case SAML10: 
            case SAML11: {
                entityId = metadataLocal.getSaml1xId();
                srcId = metadataLocal.getSaml1xSourceId();
                break;
            }
            case WSFED: {
                entityId = metadataLocal.getWsFedID();
                break;
            }
            default: {
                entityId = metadataLocal.getEntityId();
                srcId = metadataLocal.getSourceId();
            }
        }
        VirtualIdentity virtualIdentity = new VirtualIdentity();
        virtualIdentity.setVirtualEntityId(entityId, DomainMode.RUNTIME);
        virtualIdentity.setVirtualSourceId(srcId);
        return virtualIdentity;
    }
}

