/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner.impl;

import com.pingidentity.common.util.JDBCHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.C2CMappingDb;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntry;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntryResult;
import org.sourceid.saml20.metadata.partner.IndexDb;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class C2CMappingDbImpl
extends IndexDb
implements C2CMappingDb {
    private static final String SYSTEM_ID = "SYSTEM_ID";
    private static final String CONTRACT_ID = "CONTRACT_ID";
    private static final String ACTIVE = "ACTIVE";
    private static final String CONN_TYPE = "CONN_TYPE";
    private static final String ENTITY_ID = "ENTITY_ID";
    private static final String ALL_COLUMNS = StringUtils.join(Arrays.asList("SYSTEM_ID", "CONTRACT_ID"), (String)",");
    private static final String ALL_RETURNED_COLUMNS = StringUtils.join(Arrays.asList("CONNECTIONS.SYSTEM_ID", "ENTITY_ID", "CONTRACT_ID", "CONN_TYPE", "ACTIVE"), (String)",");
    private static final String SQL_CREATE_C2C_MAPPINGS_TABLE = "CREATE TABLE IF NOT EXISTS C2C_MAPPINGS (SYSTEM_ID VARCHAR(64) NOT NULL, CONTRACT_ID VARCHAR(64) NOT NULL, PRIMARY KEY (SYSTEM_ID, CONTRACT_ID), CONSTRAINT FK_C2C_MAPPINGS_SYSTEM_ID FOREIGN KEY (SYSTEM_ID) REFERENCES CONNECTIONS (SYSTEM_ID) ON DELETE CASCADE)";
    private static final String SQL_CREATE_C2C_CONTRACT_ID_INDEX = "CREATE INDEX IF NOT EXISTS IDX_C2C_CONTRACT_ID ON C2C_MAPPINGS(CONTRACT_ID)";
    private static final String SQL_UPDATE_C2C = "MERGE INTO C2C_MAPPINGS(" + ALL_COLUMNS + ") VALUES(?,?)";
    private static final String SQL_SELECT_ALL_C2C = "SELECT " + ALL_RETURNED_COLUMNS + " FROM C2C_MAPPINGS, CONNECTIONS WHERE C2C_MAPPINGS.SYSTEM_ID = CONNECTIONS.SYSTEM_ID";
    private static final String SQL_SELECT_ALL_C2C_BY_CONTRACT_ID = "SELECT " + ALL_RETURNED_COLUMNS + " FROM C2C_MAPPINGS, CONNECTIONS WHERE C2C_MAPPINGS.SYSTEM_ID = CONNECTIONS.SYSTEM_ID AND CONTRACT_ID = ?";
    private static final String SQL_SELECT_C2C_SP_ACTIVE_COUNT = "SELECT COUNT(DISTINCT CONNECTIONS.SYSTEM_ID) AS CNT FROM CONNECTIONS, C2C_MAPPINGS WHERE C2C_MAPPINGS.SYSTEM_ID = CONNECTIONS.SYSTEM_ID AND CONNECTIONS.CONN_TYPE = 'SP' AND CONNECTIONS.ACTIVE = TRUE";
    private static final String SQL_SELECT_FIRST_C2C_SP_ACTIVE = "SELECT " + ALL_RETURNED_COLUMNS + " FROM CONNECTIONS, C2C_MAPPINGS WHERE C2C_MAPPINGS.SYSTEM_ID = CONNECTIONS.SYSTEM_ID AND CONNECTIONS.CONN_TYPE = 'SP' AND CONNECTIONS.ACTIVE = TRUE LIMIT 1";
    private static final String SQL_DELETE_C2C = "DELETE FROM C2C_MAPPINGS WHERE SYSTEM_ID = ?";

    public C2CMappingDbImpl() {
        this.createTables();
    }

    public String getServiceName() {
        return "connection-to-connection-mapping-index-db";
    }

    @Override
    public void deleteAndSaveEntries(String systemId, Collection<C2CMappingDbEntry> mappingsWithAUniqueSystemId) {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.setAutoCommit(false);
            PreparedStatement deleteStatement = helper.getPreparedStatement(SQL_DELETE_C2C);
            deleteStatement.setString(1, systemId);
            deleteStatement.execute();
            PreparedStatement statement = helper.getPreparedStatement(SQL_UPDATE_C2C);
            for (C2CMappingDbEntry mapping : mappingsWithAUniqueSystemId) {
                statement.setString(1, mapping.getSystemId());
                statement.setString(2, mapping.getContractId());
                statement.execute();
            }
            helper.commit();
        }
    }

    @Override
    public int getActiveSpConnectionsWithC2CMappingsCount() {
        int cnt = 0;
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_C2C_SP_ACTIVE_COUNT);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                cnt = resultSet.getInt(1);
            }
        }
        return cnt;
    }

    @Override
    public Collection<C2CMappingDbEntryResult> getEntriesByContractId(String contractId) {
        ArrayList<C2CMappingDbEntryResult> result = new ArrayList<C2CMappingDbEntryResult>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            PreparedStatement statement = helper.getPreparedStatement(SQL_SELECT_ALL_C2C_BY_CONTRACT_ID);
            statement.setString(1, contractId);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                result.add(this.entryFromResultSet(resultSet));
            }
        }
        return result;
    }

    @Override
    public String getFirstActiveSpConnectionEntityId() {
        C2CMappingDbEntryResult result = null;
        String firstEntityId = null;
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_FIRST_C2C_SP_ACTIVE);
            ResultSet resultSet = helper.getResultSet();
            if (resultSet.next()) {
                result = this.entryFromResultSet(resultSet);
                firstEntityId = result.getEntityId();
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return firstEntityId;
    }

    @Override
    public Collection<C2CMappingDbEntryResult> getAllEntries() {
        ArrayList<C2CMappingDbEntryResult> result = new ArrayList<C2CMappingDbEntryResult>();
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.getPreparedStatement(SQL_SELECT_ALL_C2C);
            ResultSet resultSet = helper.getResultSet();
            while (resultSet.next()) {
                result.add(this.entryFromResultSet(resultSet));
            }
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error getting entry", e);
        }
        return result;
    }

    private C2CMappingDbEntryResult entryFromResultSet(ResultSet resultSet) throws SQLException {
        return new C2CMappingDbEntryResult(resultSet.getString(SYSTEM_ID), resultSet.getString(ENTITY_ID), resultSet.getString(CONTRACT_ID), Role.valueOf(resultSet.getString(CONN_TYPE)), resultSet.getBoolean(ACTIVE));
    }

    private void createTables() {
        try (JDBCHelper helper = this.newJDBCHelper();){
            helper.execute(SQL_CREATE_C2C_MAPPINGS_TABLE);
            helper.execute(SQL_CREATE_C2C_CONTRACT_ID_INDEX);
        }
        catch (SQLException e) {
            throw new ProcessRuntimeException("Error creating connection tables/indexes", e);
        }
    }
}

