/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.metadata.partner.ReadOnlyMetadataDirectory;
import org.sourceid.saml20.xmlbinding.metadata.AffiliationDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.IDPSSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.SPSSODescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.SSODescriptorType;

public abstract class MetadataDirectoryBase
implements ReadOnlyMetadataDirectory {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ConnectionUtil connectionUtil = new ConnectionUtil();
    private final Map<String, IdpConnection> idpMap = new ConnectionMap<IdpConnection>();
    private final Map<String, SpConnection> spMap = new ConnectionMap<SpConnection>();
    private final Map<String, IdpConnection> idpsBySystemId = new HashMap<String, IdpConnection>();
    private final Map<String, SpConnection> spsBySystemId = new HashMap<String, SpConnection>();
    private final Map<String, Affiliation> affiliationMap = new HashMap<String, Affiliation>();
    private final Map<String, String> entityIdToAffiliationIdMap = new HashMap<String, String>();
    private boolean allConnectionsLoaded = false;

    @Override
    public synchronized IdpConnection getIdpConnectionMetadata(String entityId) {
        return this.getIdpConnection(entityId, true);
    }

    @Override
    public synchronized IdpConnection getIdpConnection(String entityId, boolean failIfNotFound) {
        IdpConnection idpConnection = null;
        if (entityId != null && (idpConnection = this.idpMap.get(entityId)) == null && !this.allConnectionsLoaded) {
            this.loadConnectionFromStoreByEntityId(Role.IDP, entityId);
            idpConnection = this.idpMap.get(entityId);
        }
        if (idpConnection == null && failIfNotFound) {
            throw new ConfigurationException("Unable to lookup idp connection metadata for entityid='" + entityId + "'");
        }
        return idpConnection;
    }

    @Override
    public synchronized SpConnection getSpConnectionMetadata(String entityId) {
        return this.getSpConnection(entityId, true);
    }

    @Override
    public synchronized SpConnection getSpConnection(String entityId, boolean failIfNotFound) {
        SpConnection spConnection = null;
        if (entityId != null && (spConnection = this.spMap.get(entityId)) == null && !this.allConnectionsLoaded) {
            this.loadConnectionFromStoreByEntityId(Role.SP, entityId);
            spConnection = this.spMap.get(entityId);
        }
        if (spConnection == null && failIfNotFound) {
            throw new ConfigurationException("Unable to lookup sp connection metadata for entityId='" + entityId + "'");
        }
        return spConnection;
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public synchronized IdpConnection getIdpConnectionBySystemId(String id, boolean failIfNotFound) {
        IdpConnection idpConnection = this.idpsBySystemId.get(id);
        if (idpConnection == null && !this.allConnectionsLoaded) {
            this.loadConnectionFromStore(id);
            idpConnection = this.idpsBySystemId.get(id);
        }
        if (idpConnection == null && failIfNotFound) {
            throw new ConfigurationException("Unable to lookup idp connection metadata for id='" + id + "'");
        }
        if (idpConnection != null) {
            this.idpMap.get(idpConnection.getEntityId());
        }
        return idpConnection;
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public synchronized SpConnection getSpConnectionBySystemId(String id, boolean failIfNotFound) {
        SpConnection spConnection = this.spsBySystemId.get(id);
        if (spConnection == null && !this.allConnectionsLoaded) {
            this.loadConnectionFromStore(id);
            spConnection = this.spsBySystemId.get(id);
        }
        if (spConnection == null && failIfNotFound) {
            throw new ConfigurationException("Unable to lookup sp connection metadata for id='" + id + "'");
        }
        if (spConnection != null) {
            this.spMap.get(spConnection.getEntityId());
        }
        return spConnection;
    }

    @Override
    public synchronized SpConnection getSpConnectionByAppliesTo(AppliesTo givenAppliesTo) {
        int minDiff = Integer.MAX_VALUE;
        SpConnection result = null;
        boolean hasInactiveConnections = false;
        Collection<ConnectionDbEntry> entries = MgmtFactory.getConnectionDb().getWstrustConnections(Role.SP);
        for (ConnectionDbEntry entry : entries) {
            WsTrustFederatedWscSettings wsTrustSettings;
            if (!entry.isActive()) {
                hasInactiveConnections = true;
                continue;
            }
            SpConnection spConn = this.getSpConnection(entry.getEntityId(), false);
            if (spConn == null || (wsTrustSettings = spConn.getWsTrustSettings()) == null) continue;
            for (AppliesTo connAppliesTo : wsTrustSettings.getAppliesTo()) {
                int diff = connAppliesTo.compareTo(givenAppliesTo);
                if (diff == 0) {
                    int queryDifference = connAppliesTo.compareQuery(givenAppliesTo);
                    if (queryDifference == 0) {
                        return spConn;
                    }
                    minDiff = 0;
                    result = spConn;
                    continue;
                }
                if (diff <= 0 || diff >= minDiff) continue;
                minDiff = diff;
                result = spConn;
            }
        }
        if (hasInactiveConnections && result == null) {
            this.log.info((Object)"Unable to determine partner SP connection by AppliesTo. The connection may be inactive.");
        }
        return result;
    }

    @Override
    public synchronized Affiliation getAffiliation(String affiliationId) {
        return this.getAffiliation(affiliationId, true);
    }

    @Override
    public synchronized String checkForAffiliations(String entityId) {
        return this.entityIdToAffiliationIdMap.containsKey(entityId) ? this.entityIdToAffiliationIdMap.get(entityId) : entityId;
    }

    @Override
    public synchronized List<String> getAffiliationIds() {
        return new ArrayList<String>(this.affiliationMap.keySet());
    }

    @Override
    public synchronized Collection<IdpConnection> getIdpConnections() {
        return this.getIdpConnections(false);
    }

    @Override
    public synchronized Collection<IdpConnection> getIdpConnections(boolean includeDynamic) {
        this.loadAllConnections();
        ArrayList<IdpConnection> collCopy = new ArrayList<IdpConnection>(this.idpMap.size());
        for (IdpConnection idpConn : this.idpMap.values()) {
            if (!includeDynamic && "pingfederate:dynamic:idp:conn:id".equals(idpConn.getEntityId())) continue;
            collCopy.add(idpConn);
        }
        return collCopy;
    }

    @Override
    public synchronized Collection<SpConnection> getSpConnections() {
        return this.getSpConnections(false);
    }

    @Override
    public synchronized Collection<SpConnection> getSpConnections(boolean includeDynamic) {
        this.loadAllConnections();
        ArrayList<SpConnection> collCopy = new ArrayList<SpConnection>(this.spMap.size());
        for (SpConnection spConn : this.spMap.values()) {
            if (!includeDynamic && "pingfederate:dynamic:sp:conn:id".equals(spConn.getEntityId())) continue;
            collCopy.add(spConn);
        }
        return collCopy;
    }

    @Override
    public synchronized List<String> getIdpEntityIds() {
        this.loadAllConnections();
        ArrayList<String> staticIdpIds = new ArrayList<String>();
        for (String id : this.idpMap.keySet()) {
            if ("pingfederate:dynamic:idp:conn:id".equals(id)) continue;
            staticIdpIds.add(id);
        }
        return staticIdpIds;
    }

    @Override
    public synchronized List<String> getSpEntityIds() {
        this.loadAllConnections();
        ArrayList<String> staticSpIds = new ArrayList<String>();
        for (String id : this.spMap.keySet()) {
            if ("pingfederate:dynamic:sp:conn:id".equals(id)) continue;
            staticSpIds.add(id);
        }
        return staticSpIds;
    }

    @Override
    public synchronized ConnectionBase getConnection(String id) {
        ConnectionBase conn = null;
        if (!StringUtils.isBlank((String)id)) {
            conn = this.idpsBySystemId.get(id);
            if (conn == null) {
                conn = this.spsBySystemId.get(id);
            }
            if (conn == null && !this.allConnectionsLoaded) {
                this.loadConnectionFromStore(id);
                conn = this.idpsBySystemId.get(id);
                if (conn == null) {
                    conn = this.spsBySystemId.get(id);
                }
            }
        }
        return conn;
    }

    @Override
    public synchronized Set<String> getVirtualServerIds() {
        this.loadAllConnections();
        HashSet<String> result = new HashSet<String>();
        ArrayList<ConnectionBase> conns = new ArrayList<ConnectionBase>();
        conns.addAll(this.idpMap.values());
        conns.addAll(this.spMap.values());
        for (ConnectionBase conn : conns) {
            for (VirtualIdentity virtualIdentity : conn.getVirtualIdentities()) {
                String virtualEntityId = virtualIdentity.getVirtualEntityId(DomainMode.CONFIGTIME);
                if (StringUtils.isBlank((String)virtualEntityId)) continue;
                result.add(virtualEntityId);
            }
        }
        return result;
    }

    protected synchronized boolean isAllConnectionsLoaded() {
        return this.allConnectionsLoaded;
    }

    protected synchronized void setAllConnectionsLoaded(boolean allConnectionsLoaded) {
        this.allConnectionsLoaded = allConnectionsLoaded;
    }

    protected synchronized void clearInMemoryMaps() {
        this.idpMap.clear();
        this.spMap.clear();
        this.idpsBySystemId.clear();
        this.spsBySystemId.clear();
        this.affiliationMap.clear();
        this.entityIdToAffiliationIdMap.clear();
        this.allConnectionsLoaded = false;
    }

    protected synchronized void loadAllConnections() {
        if (!this.allConnectionsLoaded) {
            this.allConnectionsLoaded = true;
            this.loadAllConnectionsFromStore();
        }
    }

    protected synchronized void loadAffiliationMap(EntitiesDescriptorDocument partnerMetadata) {
        this.affiliationMap.clear();
        EntitiesDescriptorType edt = partnerMetadata.getEntitiesDescriptor();
        for (EntityDescriptorType entityDescType : edt.getEntityDescriptorArray()) {
            AffiliationDescriptorType affiliationDescType = entityDescType.getAffiliationDescriptor();
            if (affiliationDescType == null) continue;
            Affiliation affiliation = this.connectionUtil.toAffiliation(entityDescType);
            String affiliationId = entityDescType.getEntityID();
            affiliation.setAffiliationId(affiliationId);
            this.affiliationMap.put(affiliationId, affiliation);
        }
        this.loadEntityToAffiliationMap();
    }

    protected synchronized void addConnectionFromMetadata(EntityDescriptorType entityDescriptorType) {
        if (entityDescriptorType.isSetValidUntil()) {
            this.validateValidUntil(entityDescriptorType.getValidUntil());
        }
        boolean hasSPSSODescriptor = false;
        for (SPSSODescriptorType ssoDescType : entityDescriptorType.getSPSSODescriptorArray()) {
            this.validateSSODescriptor((SSODescriptorType)ssoDescType);
            hasSPSSODescriptor = true;
        }
        boolean hasIDPSSODescriptor = false;
        for (IDPSSODescriptorType ssoDescType : entityDescriptorType.getIDPSSODescriptorArray()) {
            this.validateSSODescriptor((SSODescriptorType)ssoDescType);
            hasIDPSSODescriptor = true;
        }
        if (hasIDPSSODescriptor && hasSPSSODescriptor) {
            SpConnection spConn;
            IdpConnection idpConn = this.connectionUtil.toIdpConn(entityDescriptorType);
            if (idpConn != null) {
                this.addConnectionToMaps(idpConn);
            }
            if ((spConn = this.connectionUtil.toSpConn(entityDescriptorType)) != null) {
                this.addConnectionToMaps(spConn);
            }
        } else {
            ConnectionBase connectionBase = this.connectionUtil.toConn(entityDescriptorType);
            if (connectionBase != null) {
                this.addConnectionToMaps(connectionBase);
            }
        }
    }

    protected synchronized void removeConnectionFromMaps(ConnectionBase conn) {
        String connectionIdToUnload = conn.getEntityIdOnDisk();
        if (connectionIdToUnload != null) {
            if (conn instanceof IdpConnection) {
                this.idpMap.remove(connectionIdToUnload);
                IdpConnection removedConnection = this.idpsBySystemId.remove(conn.getId());
                if (removedConnection != null && removedConnection.getEntityIdOnDisk() != null) {
                    this.idpMap.remove(removedConnection.getEntityIdOnDisk());
                }
            } else if (conn instanceof SpConnection) {
                this.spMap.remove(connectionIdToUnload);
                SpConnection removedConnection = this.spsBySystemId.remove(conn.getId());
                if (removedConnection != null && removedConnection.getEntityIdOnDisk() != null) {
                    this.spMap.remove(removedConnection.getEntityIdOnDisk());
                }
            }
        }
    }

    protected synchronized void removeConnectionFromMaps(String entityId, String systemId, Role role) {
        if (Role.IDP == role) {
            this.idpMap.remove(entityId);
            this.idpsBySystemId.remove(systemId);
        } else if (Role.SP == role) {
            this.spMap.remove(entityId);
            this.spsBySystemId.remove(systemId);
        }
    }

    protected synchronized void addConnectionToMaps(ConnectionBase connectionBase) {
        if (connectionBase instanceof IdpConnection) {
            this.idpMap.put(connectionBase.getEntityId(), (IdpConnection)connectionBase);
            this.idpsBySystemId.put(connectionBase.getId(), (IdpConnection)connectionBase);
            if (!this.allConnectionsLoaded) {
                this.log.debug((Object)("Loaded IdP connection " + connectionBase.getEntityId() + " into cache, size = " + this.idpMap.size()));
            }
        } else {
            this.spMap.put(connectionBase.getEntityId(), (SpConnection)connectionBase);
            this.spsBySystemId.put(connectionBase.getId(), (SpConnection)connectionBase);
            if (!this.allConnectionsLoaded) {
                this.log.debug((Object)("Loaded SP connection " + connectionBase.getEntityId() + " into cache, size = " + this.spMap.size()));
            }
        }
    }

    protected synchronized void validateValidUntil(Calendar validUtil) {
        Calendar now = Calendar.getInstance();
        if (!now.before(validUtil)) {
            throw new RuntimeException("The metadata has expired.");
        }
    }

    protected abstract void loadAllConnectionsFromStore();

    protected abstract boolean loadConnectionFromStore(String var1);

    protected abstract boolean loadConnectionFromStoreByEntityId(Role var1, String var2);

    protected synchronized int getMaxSizeIdpConnMap() {
        return Integer.MAX_VALUE;
    }

    protected synchronized int getMaxSizeSpConnMap() {
        return Integer.MAX_VALUE;
    }

    protected synchronized void checkPurgeConnection(ConnectionBase conn) {
        if (!this.allConnectionsLoaded) {
            if (conn instanceof IdpConnection && this.idpMap.size() > this.getMaxSizeIdpConnMap()) {
                this.log.debug((Object)("Reached max IdP connection cache size (" + this.getMaxSizeIdpConnMap() + "), purging least-recently-accessed connection " + conn.getEntityId()));
                this.removeConnectionFromMaps(conn);
            } else if (this.spMap.size() > this.getMaxSizeSpConnMap()) {
                this.log.debug((Object)("Reached max SP connection cache size (" + this.getMaxSizeSpConnMap() + "), purging least-recently-accessed connection " + conn.getEntityId()));
                this.removeConnectionFromMaps(conn);
            }
        }
    }

    protected synchronized int getSizeIdpConnMap() {
        return this.idpMap.size();
    }

    protected synchronized int getSizeSpConnMap() {
        return this.spMap.size();
    }

    protected synchronized int getSizeIdpBySystemIdMap() {
        return this.idpsBySystemId.size();
    }

    protected synchronized int getSizeSpBySystemIdMap() {
        return this.spsBySystemId.size();
    }

    protected synchronized IdpConnection getCachedIdpConnection(String entityId) {
        return this.idpMap.get(entityId);
    }

    protected synchronized SpConnection getCachedSpConnection(String entityId) {
        return this.spMap.get(entityId);
    }

    protected synchronized IdpConnection getCachedIdpConnectionBySystemId(String id) {
        return this.idpsBySystemId.get(id);
    }

    protected synchronized SpConnection getCachedSpConnectionBySystemId(String id) {
        return this.spsBySystemId.get(id);
    }

    private void loadEntityToAffiliationMap() {
        this.entityIdToAffiliationIdMap.clear();
        for (Affiliation affiliation : this.affiliationMap.values()) {
            if (!affiliation.isActive()) continue;
            for (String member : affiliation.getMembers()) {
                if (this.entityIdToAffiliationIdMap.containsKey(member)) continue;
                this.entityIdToAffiliationIdMap.put(member, affiliation.getAffiliationId());
            }
        }
    }

    private Affiliation getAffiliation(String affiliationId, boolean failIfNotFound) {
        Affiliation affiliation = this.affiliationMap.get(affiliationId);
        if (affiliation == null && failIfNotFound) {
            throw new ConfigurationException("Unable to lookup affiliation metadata for affiliationId = '" + affiliationId + "'");
        }
        return affiliation;
    }

    private void validateSSODescriptor(SSODescriptorType ssoDesc) {
        if (ssoDesc.isSetValidUntil()) {
            this.validateValidUntil(ssoDesc.getValidUntil());
        }
    }

    private class ConnectionMap<T extends ConnectionBase>
    extends LinkedHashMap<String, T> {
        public ConnectionMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> entry) {
            MetadataDirectoryBase.this.checkPurgeConnection((ConnectionBase)entry.getValue());
            return false;
        }
    }
}

