/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.metadata.partner.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.ByteArrayHashKey;
import com.pingidentity.common.util.DomainNameUtil;
import com.pingidentity.common.util.ErrorHandler;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NoInitialContextException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PartnerCertMigrator;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.C2CMappingDb;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntry;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.NewConnFile;
import org.sourceid.saml20.metadata.partner.TargetAttributeMappingDb;
import org.sourceid.saml20.metadata.partner.TargetAttributeMappingDbEntry;
import org.sourceid.saml20.metadata.partner.impl.MetadataDirectoryBase;
import org.sourceid.saml20.state.SizeLimitProps;
import org.sourceid.saml20.xmlbinding.metadata.AffiliationDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ExtensionsType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.RoleExtensionDocument;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.RoleExtensionType;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class MetadataDirectoryHybridDbImpl
extends MetadataDirectoryBase
implements MetadataDirectory,
AutoReloadable {
    public static final String AFFILIATIONS_XML_FILE_NAME = "sourceid-saml2-metadata.xml";
    public static final String CONNECTIONS_DIR = "connections";
    private static final String UNMIGRATED_CONNECTIONS_FILE_NAME = "unmigrated-connections.xml";
    private static final String DELTA_REPLICATION_STATE_FILE_NAME = "conns-delta-repl-state.json";
    private static final String METADATA_EXT_NS = "urn:sourceid.org:saml2:metadata-extension:v2";
    private static final String IS_ACTIVE = "isActive";
    private static final String EXTENSION = ".xml";
    private static final String CFG_CONNS_PER_DIRECTORY = "ConnsPerDirectory";
    private static final String CFG_MIGRATION_COMPLETE_8_4 = "MigrationComplete8.4";
    private static final String PARTIAL_SUFFIX = "-(partial)";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.metadata.partner.impl.MetadataDirectoryHybridDbImpl");
    private final XmlLoader xmlLoader = MgmtFactory.getXmlLoader();
    private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
    private final ConnectionDb connDb = MgmtFactory.getConnectionDb();
    private final C2CMappingDb c2cMappingDb = MgmtFactory.getC2CMappingDb();
    private final TargetAttributeMappingDb targetAttributeMappingDb = MgmtFactory.getTargetAttributeMappingDb();
    private EntitiesDescriptorDocument affiliationMetadata;
    private final int maxSizeIdpConnMap;
    private final int maxSizeSpConnMap;
    private int connectionCountCacheForLicensing = -1;
    private final ObjectMapper objectMapper = this.makeObjectMapper();
    private DeltaReplicationState deltaReplState;
    private static volatile boolean isStartup = true;

    public MetadataDirectoryHybridDbImpl() {
        SizeLimitProps config = new SizeLimitProps();
        this.maxSizeIdpConnMap = config.getMetadataDirectoryMaxSizeIdpConnMap();
        this.maxSizeSpConnMap = config.getMetadataDirectoryMaxSizeSpConnMap();
        MgmtFactory.getDataSourceManager().initializeJndiLookup();
        this.loadConfig();
    }

    @Override
    public synchronized int getConnectionCount() {
        if (this.connectionCountCacheForLicensing == -1) {
            this.connectionCountCacheForLicensing = MgmtFactory.getConnectionDb().getConnectionCountForLicensing();
        }
        return this.connectionCountCacheForLicensing;
    }

    private void resetConnectionCountCacheForLicensing() {
        this.connectionCountCacheForLicensing = -1;
    }

    protected synchronized void loadConfig() {
        this.log.debug((Object)"Reloading metadata directory");
        this.ensureConnsDirExists();
        this.loadDeltaReplicationState();
        this.clearInMemoryMaps();
        this.loadAffiliationMetadata();
        this.migrateConnections();
        this.indexConnections();
        this.resetConnectionCountCacheForLicensing();
        new PartnerCertMigrator(this).migrateCertsIfNeeded();
        this.clearInMemoryMaps();
        this.loadAffiliationMetadata();
        this.log.debug((Object)"Finished reloading metadata directory");
    }

    @Override
    public synchronized void saveAffiliation(Affiliation affiliation) {
        this.log.debug((Object)("Saving affiliation " + affiliation.getAffiliationId()));
        EntitiesDescriptorType entitiesDescriptor = this.affiliationMetadata.getEntitiesDescriptor();
        this.prepare4SaveAffiliation(affiliation);
        String affiliationId = affiliation.getAffiliationId();
        EntityDescriptorType entityDescType = entitiesDescriptor.addNewEntityDescriptor();
        XmlBeansUtil.setAttributeValue((XmlObject)entityDescType, Boolean.toString(affiliation.isActive()), METADATA_EXT_NS, IS_ACTIVE);
        entityDescType.setEntityID(affiliationId);
        entityDescType.setID(XmlIDUtil.createID());
        RoleExtensionDocument roleExtdoc = RoleExtensionDocument.Factory.newInstance();
        RoleExtensionType roleExtensionType = roleExtdoc.addNewRoleExtension();
        if (affiliation.getLastModified() != null) {
            roleExtensionType.setLastModified(affiliation.getLastModified());
            ExtensionsType extensionsType = entityDescType.addNewExtensions();
            XmlBeansUtil.setChildren((XmlObject)extensionsType, new XmlObject[]{roleExtensionType});
        }
        AffiliationDescriptorType affiliationDescriptorType = entityDescType.addNewAffiliationDescriptor();
        for (String member : affiliation.getMembers()) {
            affiliationDescriptorType.addAffiliateMember(member);
        }
        affiliationDescriptorType.setAffiliationOwnerID(affiliation.getAffiliationOwnerId());
        this.saveAffiliations();
    }

    @Override
    public synchronized void deleteAffiliation(Affiliation affiliation) {
        this.log.debug((Object)("Deleting affiliation " + affiliation.getAffiliationId()));
        this.prepare4SaveAffiliation(affiliation);
        this.saveAffiliations();
    }

    @Override
    public synchronized void saveIdpConnection(IdpConnection idpConnection) {
        this.saveConnections(Collections.singletonList(idpConnection));
    }

    @Override
    public synchronized void saveIdpConnections(List<IdpConnection> idpConnections) {
        this.saveConnections(idpConnections);
    }

    @Override
    public synchronized void saveSpConnection(SpConnection spConnection) {
        this.saveConnections(Collections.singletonList(spConnection));
    }

    @Override
    public synchronized void saveSpConnections(List<SpConnection> spConnections) {
        this.saveConnections(spConnections);
    }

    @Override
    public synchronized void deleteConnection(ConnectionBase connection) {
        this.deleteConnections(Collections.singletonList(connection));
    }

    @Override
    public synchronized void deleteConnections(List<? extends ConnectionBase> connections) {
        for (ConnectionBase connectionBase : connections) {
            this.log.debug((Object)("Deleting " + connectionBase.getRoleType() + " connection " + connectionBase.getEntityId()));
            this.removeConnectionFromMaps(connectionBase);
            this.deleteConnectionFromStore(connectionBase.getId(), true);
        }
    }

    @Override
    public synchronized String getManagedDirectoryName() {
        return CONNECTIONS_DIR;
    }

    @Override
    public synchronized void beginFullReplication() {
        this.log.debug((Object)"Cleaning connections directory and database");
        File connsDir = this.getConnsDirectory();
        if (connsDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)connsDir);
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to clean directory " + connsDir);
            }
        }
        this.connDb.deleteAllEntries();
        this.connDb.deleteNewConnFiles();
    }

    @Override
    public synchronized void clearReplicationState() {
        File replStateFile = this.getDeltaReplicationStateFile();
        if (replStateFile.exists() && !replStateFile.delete()) {
            throw new ConfigurationException("Failed to delete file " + replStateFile);
        }
        this.loadDeltaReplicationState();
    }

    @Override
    public boolean isValidPartialEntry(String entryId) {
        return entryId.startsWith(this.getManagedDirectoryName() + "/") && entryId.endsWith(PARTIAL_SUFFIX);
    }

    @Override
    public String extractIdFromEntryId(String entryId) {
        int beginIndex = this.getManagedDirectoryName().length() + 1;
        int endIndex = entryId.length() - PARTIAL_SUFFIX.length();
        return entryId.substring(beginIndex, endIndex);
    }

    @Override
    public byte[] mergePartialEntry(byte[] partialEntry, byte[] entry) {
        ConnectionBase partialConnection = this.deserializeConnection(partialEntry);
        ConnectionBase connection = this.deserializeConnection(entry);
        connection.setDsigVerificationCerts(partialConnection.getDsigVerificationCerts());
        connection.setEncryptionSettings(partialConnection.getEncryptionSettings());
        return this.serializeConnection(connection);
    }

    @Override
    public synchronized Iterator<ReplicationRecord> getReplicationRecords(Date startTime) {
        Collection<ConnectionTombstone> tombstones;
        Collection<ConnectionDbEntry> entries;
        this.log.trace((Object)("Getting replication records starting from " + startTime));
        if (startTime == null) {
            entries = this.connDb.getAllEntries();
            tombstones = new ArrayList<ConnectionTombstone>(this.deltaReplState.getTombstones());
        } else {
            entries = this.connDb.getEntriesModifiedSince(startTime);
            tombstones = this.deltaReplState.getTombstones().stream().filter(t -> t.getTimestamp().after(startTime)).collect(Collectors.toList());
        }
        return new RecordIterator(tombstones, entries);
    }

    @Override
    public synchronized void importReplicationRecords(Collection<ReplicationRecord> records, boolean createTombstones) {
        int entryCount = this.connDb.getEntryCount() + this.connDb.getNewConnFileCount();
        int recordCount = 0;
        for (ReplicationRecord record : records) {
            boolean isPartialId = this.isPartialId(record.getId());
            String id = isPartialId ? this.extractIdFromPartialRecord(record.getId()) : record.getId();
            byte[] data = record.getData();
            this.logRecordDeployment(data, id);
            if (record.isTombstone()) {
                if (isPartialId) continue;
                this.deleteConnectionFromStore(id, createTombstones);
                ++recordCount;
                continue;
            }
            ConnectionDbEntry entry = this.connDb.getEntry(id);
            String relativePath = entry == null ? this.newFileSystemPath(entryCount++, id) : entry.getFileSystemPath();
            File file = new File(this.getAbsolutePath(relativePath));
            try {
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new ConfigurationException("Failed to create directory " + file.getParentFile());
                }
                if (isPartialId) {
                    ConnectionBase connection = this.getConnection(id);
                    if (connection != null) {
                        ConnectionBase partialConnection = this.deserializeConnection(record.getData());
                        connection.setDsigVerificationCerts(partialConnection.getDsigVerificationCerts());
                        connection.setEncryptionSettings(partialConnection.getEncryptionSettings());
                        data = this.serializeConnection(connection);
                        this.saveReplicationRecord(id, data, relativePath, file);
                        ++recordCount;
                        continue;
                    }
                    String msg = "connection with id " + id + " not found, the connection may not be replicated yet";
                    this.log.debug((Object)msg);
                    continue;
                }
                this.saveReplicationRecord(id, data, relativePath, file);
                ++recordCount;
            }
            catch (IOException e) {
                throw new ConfigurationException("Error importing connection file", e);
            }
        }
        this.log.debug((Object)("Importing replication records: saved " + recordCount + " connections to disk"));
    }

    private void logRecordDeployment(byte[] data, String id) {
        if (ReplicationRecord.isTombstone(data)) {
            ConnectionBase existingConnection = this.getConnection(id);
            if (existingConnection != null) {
                this.log.debug((Object)("Deleting connection " + existingConnection.getEntityId()));
            }
        } else {
            ConnectionBase updatedConnection = this.deserializeConnection(data);
            if (updatedConnection != null) {
                this.log.debug((Object)("Deploying replicated connection data for connection " + updatedConnection.getEntityId()));
            }
        }
    }

    @Override
    public synchronized void reloadUpdatedEntries() {
        this.indexConnections();
        this.setAllConnectionsLoaded(false);
    }

    @Override
    public boolean selectiveReplicationEnabled() {
        return MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForConnections();
    }

    private void saveReplicationRecord(String id, byte[] data, String relativePath, File file) throws IOException {
        Files.write(file.toPath(), data, new OpenOption[0]);
        this.connDb.addNewConnFiles(List.of(new NewConnFile(id, relativePath)));
    }

    @Override
    public synchronized void deleteTombstones(Date endTime) {
        this.log.debug((Object)("Deleting tombstones earlier than " + endTime));
        this.deltaReplState.removeTombstones(endTime);
        this.saveDeltaReplicationState();
    }

    @Override
    public synchronized Date getTombstoneTrackingStartTime() {
        return this.deltaReplState.getTombstoneTrackingStartTime();
    }

    @Override
    public synchronized Date getLatestUpdateTimestamp() {
        Date latestUpdate = this.connDb.getLatestUpdateTimestamp();
        Date latestDelete = this.deltaReplState.getLatestDeleteTimestamp();
        if (latestDelete.after(latestUpdate)) {
            latestUpdate = latestDelete;
        }
        return latestUpdate;
    }

    public synchronized void indexConnections() {
        File connsDir;
        File[] fileList;
        this.log.debug((Object)"Indexing connections ...");
        int connsIndexed = 0;
        Collection<NewConnFile> newConnFiles = this.connDb.getNewConnFiles();
        if (newConnFiles.size() > 0) {
            for (NewConnFile connFile : newConnFiles) {
                File file = new File(this.getAbsolutePath(connFile.getFilePath()));
                if (!file.exists()) continue;
                try {
                    this.indexConnectionFile(file);
                    if (++connsIndexed % 1000 != 0) continue;
                    this.log.debug((Object)("Indexed " + connsIndexed + " connections"));
                }
                catch (Exception e) {
                    this.log.error((Object)("Unexpected error while indexing connection file " + file), (Throwable)e);
                }
            }
            this.connDb.deleteNewConnFiles();
        } else if (this.connDb.getEntryCount() == 0 && (fileList = (connsDir = this.getConnsDirectory()).listFiles()) != null) {
            for (File file : fileList) {
                if (!file.isDirectory()) continue;
                connsIndexed = this.indexDirectory(file, connsIndexed);
            }
        }
        this.log.debug((Object)("Finished indexing, total conns indexed = " + connsIndexed));
    }

    @Override
    public synchronized Collection<IdpConnection> getIdpConnectionsWithConnBasedPluginOverrides() {
        ArrayList<IdpConnection> connections;
        block3: {
            connections = new ArrayList<IdpConnection>();
            try {
                Collection<ConnectionDbEntry> entries = MgmtFactory.getConnectionDb().getEntriesWithConnBasedPluginOverrides(Role.IDP);
                for (ConnectionDbEntry entry : entries) {
                    IdpConnection idpConn = this.getIdpConnection(entry.getEntityId(), false);
                    if (idpConn == null) continue;
                    connections.add(idpConn);
                }
            }
            catch (ProcessRuntimeException ex) {
                if (ex.getCause() instanceof NoInitialContextException) break block3;
                throw ex;
            }
        }
        return connections;
    }

    @Override
    public synchronized Collection<SpConnection> getSpConnectionsWithConnBasedPluginOverrides() {
        ArrayList<SpConnection> connections = new ArrayList<SpConnection>();
        Collection<ConnectionDbEntry> entries = MgmtFactory.getConnectionDb().getEntriesWithConnBasedPluginOverrides(Role.SP);
        for (ConnectionDbEntry entry : entries) {
            SpConnection spConn = this.getSpConnection(entry.getEntityId(), false);
            if (spConn == null) continue;
            connections.add(spConn);
        }
        return connections;
    }

    protected synchronized void deleteConnectionFromStore(String id, boolean createTombstone) {
        NewConnFile newConnFile;
        boolean connectionDeleted = false;
        ConnectionDbEntry entry = this.connDb.getEntry(id);
        if (entry != null) {
            String fileName;
            String directory;
            File file = new File(this.getAbsolutePath(entry));
            if (file.exists() && !this.xmlLoader.delete(directory = file.getParent(), fileName = file.getName())) {
                throw new ConfigurationException("Failed to delete file " + file);
            }
            this.removeConnectionFromMaps(entry.getEntityId(), id, entry.getRole());
            this.connDb.deleteEntry(entry.getId());
            connectionDeleted = true;
        }
        if ((newConnFile = this.connDb.getNewConnFile(id)) != null) {
            File file = new File(this.getAbsolutePath(newConnFile.getFilePath()));
            if (file.exists() && !file.delete()) {
                throw new ConfigurationException("Failed to delete file " + file);
            }
            this.connDb.deleteNewConnFile(id);
            connectionDeleted = true;
        }
        if (createTombstone && connectionDeleted) {
            this.deltaReplState.addTombstone(new ConnectionTombstone(id, new Date()));
            this.saveDeltaReplicationState();
        }
        this.resetConnectionCountCacheForLicensing();
    }

    protected synchronized File getConnsDirectory() {
        return new File(this.sysDirInfo.getDataDirectory() + File.separator + CONNECTIONS_DIR);
    }

    @Override
    protected synchronized void loadAllConnectionsFromStore() {
        this.log.debug((Object)"Loading all connections ...");
        Collection<ConnectionDbEntry> entries = this.connDb.getAllEntries();
        int connsLoaded = 0;
        for (ConnectionDbEntry entry : entries) {
            this.loadConnection(entry);
            if (++connsLoaded % 1000 != 0) continue;
            this.log.debug((Object)("Loaded " + connsLoaded + " connections"));
        }
        this.log.debug((Object)("Finished loading connections, total conns loaded = " + connsLoaded));
    }

    @Override
    protected synchronized boolean loadConnectionFromStore(String id) {
        ConnectionDbEntry entry = this.connDb.getEntry(id);
        if (entry == null) {
            this.log.debug((Object)("No connection database entry found for id " + id));
            return false;
        }
        return this.loadConnection(entry);
    }

    @Override
    protected synchronized boolean loadConnectionFromStoreByEntityId(Role role, String entityId) {
        ConnectionDbEntry entry = this.connDb.getEntryByEntityId(role, entityId);
        if (entry == null) {
            this.log.debug((Object)("No connection database entry found for role " + role + " and entity id " + entityId));
            return false;
        }
        return this.loadConnection(entry);
    }

    @Override
    protected synchronized void removeConnectionFromMaps(ConnectionBase conn) {
        super.removeConnectionFromMaps(conn);
    }

    @Override
    protected synchronized int getMaxSizeIdpConnMap() {
        return this.maxSizeIdpConnMap;
    }

    @Override
    protected synchronized int getMaxSizeSpConnMap() {
        return this.maxSizeSpConnMap;
    }

    protected synchronized void saveConnections(Collection<? extends ConnectionBase> conns) {
        int entryCount = this.connDb.getEntryCount();
        for (ConnectionBase connectionBase : conns) {
            this.log.debug((Object)("Saving " + connectionBase.getRoleType() + " connection " + connectionBase.getEntityId()));
            if (connectionBase.getId() == null) {
                connectionBase.assignId();
            }
            this.removeConnectionFromMaps(connectionBase);
            EntityDescriptorType entity = this.toEntityDescriptorType(connectionBase);
            if (connectionBase.getFileSystemPath() == null) {
                connectionBase.setFileSystemPath(this.newFileSystemPath(entryCount, connectionBase.getId()));
            }
            long lastModified = this.saveEntity(entity, connectionBase.getFileSystemPath());
            this.indexConnection(connectionBase, lastModified);
            if (this.deltaReplState.removeTombstones(connectionBase.getId())) {
                this.saveDeltaReplicationState();
            }
            connectionBase.setEntityIdOnDisk(connectionBase.getEntityId());
            connectionBase.setSourceIdOnDisk(connectionBase.getSourceId());
            if (this.isAllConnectionsLoaded()) {
                this.loadConnectionFromStore(connectionBase.getId());
            }
            ++entryCount;
        }
        this.resetConnectionCountCacheForLicensing();
    }

    private EntityDescriptorType toEntityDescriptorType(ConnectionBase conn) {
        if (conn instanceof SpConnection) {
            return this.connectionUtil.toEntityDescriptorType((SpConnection)conn);
        }
        return this.connectionUtil.toEntityDescriptorType((IdpConnection)conn);
    }

    private void loadAffiliationMetadata() {
        this.log.debug((Object)"Loading affiliations from sourceid-saml2-metadata.xml");
        this.affiliationMetadata = (EntitiesDescriptorDocument)this.xmlLoader.load(this.sysDirInfo.getDataDirectory(), AFFILIATIONS_XML_FILE_NAME);
        this.loadAffiliationMap(this.affiliationMetadata);
    }

    private void ensureConnsDirExists() {
        File connsDir = this.getConnsDirectory();
        if (!connsDir.exists() && !connsDir.mkdirs()) {
            throw new ConfigurationException("Failed to create directory " + connsDir);
        }
    }

    private void migrateConnections() {
        if (this.configStore.getBooleanValue(CFG_MIGRATION_COMPLETE_8_4, false)) {
            return;
        }
        this.log.info((Object)"Migrating connections to new storage format ...");
        EntitiesDescriptorType edt = this.affiliationMetadata.getEntitiesDescriptor();
        int connsFound = 0;
        for (int i = 0; i < edt.sizeOfEntityDescriptorArray(); ++i) {
            EntityDescriptorType entityDescType = edt.getEntityDescriptorArray(i);
            if (entityDescType.getAffiliationDescriptor() != null) continue;
            try {
                ConnectionBase conn = this.connectionUtil.toConn(entityDescType);
                if (conn == null) {
                    this.log.warn((Object)("sourceid-saml2-metadata.xml contains invalid entry: " + entityDescType.toString()));
                    continue;
                }
                this.checkForDuplicateEntityId(conn);
                this.checkForDuplicateId(conn);
                conn.setFileSystemPath(this.newFileSystemPath(0, entityDescType.getID()));
                long lastModified = this.saveEntity(entityDescType, conn.getFileSystemPath());
                this.indexConnection(conn, lastModified);
                this.log.info((Object)("Migrated " + conn.getRoleType() + " connection " + conn.getEntityId() + " to file " + conn.getFileSystemPath()));
                edt.removeEntityDescriptor(i);
                this.saveAffiliationsFile();
                --i;
                ++connsFound;
                continue;
            }
            catch (Exception e) {
                String message = "An error occurred while migrating a connection from sourceid-saml2-metadata.xml. Cannot complete connection migration. Please contact Ping Identity support. The entry causing the error has ID " + entityDescType.getID() + ".";
                if (e.getMessage() != null) {
                    message = message + " Error detail: " + e.getMessage();
                }
                if (isStartup) {
                    this.connDb.flushCommits();
                    ErrorHandler.handleFatalError(message, e);
                    continue;
                }
                this.log.error((Object)message, (Throwable)e);
                throw new ConfigurationException(message, e);
            }
        }
        isStartup = false;
        this.configStore.setBooleanValue(CFG_MIGRATION_COMPLETE_8_4, true);
        this.log.info((Object)("Finished migrating, total conns migrated = " + connsFound));
    }

    private void checkForDuplicateId(ConnectionBase conn) {
        if (this.connDb.getEntry(conn.getId()) != null) {
            throw new ConfigurationException("sourceid-saml2-metadata.xml contains multiple entries with ID " + conn.getId());
        }
    }

    private void checkForDuplicateEntityId(ConnectionBase conn) throws IOException {
        ConnectionDbEntry existing = this.connDb.getEntryByEntityId(conn.getRoleType(), conn.getEntityId());
        if (existing != null) {
            File existingFile = new File(this.getAbsolutePath(existing));
            if (existingFile.exists()) {
                EntityDescriptorDocument doc = (EntityDescriptorDocument)this.xmlLoader.load(existingFile.getParent(), existingFile.getName());
                EntityDescriptorType entity = doc.getEntityDescriptor();
                this.saveUnmigratedConnection(entity);
            }
            this.connDb.deleteEntry(existing.getId());
            this.log.warn((Object)("sourceid-saml2-metadata.xml contains more than one " + conn.getRoleType() + " connection with entity ID " + conn.getEntityId() + ". Only the last entry will be migrated. Unmigrated entries can be found in " + this.getUnmigratedConnectionsFile() + "."));
        }
    }

    private void saveUnmigratedConnection(EntityDescriptorType entityDescType) {
        EntitiesDescriptorDocument doc = null;
        EntitiesDescriptorType entities = null;
        File unmigratedConnsFile = this.getUnmigratedConnectionsFile();
        if (!unmigratedConnsFile.exists()) {
            doc = EntitiesDescriptorDocument.Factory.newInstance();
            entities = doc.addNewEntitiesDescriptor();
        } else {
            doc = (EntitiesDescriptorDocument)this.xmlLoader.load(this.sysDirInfo.getDataDirectory(), UNMIGRATED_CONNECTIONS_FILE_NAME);
            entities = doc.getEntitiesDescriptor();
        }
        EntityDescriptorType newEntity = entities.addNewEntityDescriptor();
        newEntity.set((XmlObject)entityDescType);
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), UNMIGRATED_CONNECTIONS_FILE_NAME, (XmlObject)doc);
    }

    private File getUnmigratedConnectionsFile() {
        return new File(this.sysDirInfo.getDataDirectory(), UNMIGRATED_CONNECTIONS_FILE_NAME);
    }

    private int indexDirectory(File dir, int connsIndexed) {
        this.log.debug((Object)("Indexing directory " + dir));
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (!file.isFile() || !file.getName().endsWith(EXTENSION)) continue;
                try {
                    this.indexConnectionFile(file);
                    if (++connsIndexed % 1000 != 0) continue;
                    this.log.debug((Object)("Indexed " + connsIndexed + " connections"));
                }
                catch (Exception e) {
                    this.log.error((Object)("Unexpected error while indexing connection file " + file), (Throwable)e);
                }
            }
        }
        return connsIndexed;
    }

    private void indexConnectionFile(File file) {
        ConnectionBase conn = this.getConnectionFromFile(file);
        this.indexConnection(conn, file.lastModified());
    }

    private boolean loadConnection(ConnectionDbEntry entry) {
        String connPath = this.getAbsolutePath(entry);
        try {
            ExpressionManager expressionManager;
            ConnectionBase conn = this.getConnectionFromFile(new File(connPath));
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(entry.getLastModifiedMillis());
            conn.setLastModified(lastModified);
            if (conn.hasExpressions() && (expressionManager = ExpressionManager.getInstance()).isEvaluateExpressionsSilent()) {
                expressionManager.setEvaluateExpressionsOn();
            }
            this.addConnectionToMaps(conn);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Error loading connection from file " + connPath), (Throwable)e);
            return false;
        }
    }

    private ConnectionBase getConnectionFromFile(File file) {
        ConnectionBase connectionBase;
        FileInputStream inStream = new FileInputStream(file);
        try {
            ConnectionBase conn = this.getConnectionFromStream(inStream);
            if (conn == null) {
                throw new ConfigurationException("No connection found in file " + file);
            }
            conn.setFileSystemPath(file.getParentFile().getName() + File.separator + file.getName());
            connectionBase = conn;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Error loading connection from file " + file, e);
            }
        }
        ((InputStream)inStream).close();
        return connectionBase;
    }

    private ConnectionBase getConnectionFromStream(InputStream inStream) {
        EntityDescriptorDocument doc = (EntityDescriptorDocument)this.xmlLoader.load(inStream);
        return this.connectionUtil.toConn(doc.getEntityDescriptor());
    }

    private long saveEntity(EntityDescriptorType entity, String relativePath) {
        EntityDescriptorDocument doc = EntityDescriptorDocument.Factory.newInstance();
        doc.setEntityDescriptor(entity);
        File file = new File(this.getAbsolutePath(relativePath));
        this.xmlLoader.save(file.getParent(), file.getName(), (XmlObject)doc);
        return file.lastModified();
    }

    private byte[] serializeConnection(ConnectionBase conn) {
        byte[] byArray;
        EntityDescriptorDocument doc = EntityDescriptorDocument.Factory.newInstance();
        doc.setEntityDescriptor(this.toEntityDescriptorType(conn));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            XmlOptions options = XmlBeansUtil.getXmlOptions();
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(4);
            doc.save((OutputStream)outStream, options);
            byArray = outStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Error serializing connection", e);
            }
        }
        outStream.close();
        return byArray;
    }

    private ConnectionBase deserializeConnection(byte[] connectionBytes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(connectionBytes);
        return this.getConnectionFromStream(stream);
    }

    private void indexConnection(ConnectionBase conn, long fileLastModified) {
        this.log.trace((Object)("Indexing " + conn.getRoleType() + " connection " + conn.getEntityId()));
        try {
            long lastModified = fileLastModified;
            Calendar connLastModified = conn.getLastModified();
            if (connLastModified != null) {
                lastModified = connLastModified.getTimeInMillis();
            }
            this.connDb.saveEntry(new ConnectionDbEntry(conn.getId(), conn.getEntityId(), conn.getRoleType(), conn.isActive(), "pingfederate:dynamic:sp:conn:id".equals(conn.getEntityId()) || "pingfederate:dynamic:idp:conn:id".equals(conn.getEntityId()), this.isWsTrustEnabled(conn), conn.getEnabledProfiles().isIdpInitiatedSSOEnabled(), conn.getEnabledProfiles().isSpInitiatedSSOEnabled(), lastModified, conn.getFileSystemPath(), this.getTopLevelDomain(conn.getEntityId()), conn.getSourceId(), conn.getProtocol(), conn instanceof IdpConnection ? ((IdpConnection)conn).hasSsoToOAuthAttrMapping() : false, conn instanceof IdpConnection ? ((IdpConnection)conn).getOAuthApcId() : null, conn.getName(), conn.hasConnBasedPluginOverrides()));
            this.indexC2CMapping(conn);
            this.indexTargetAttributeMapping(conn);
            this.removeConnectionFromMaps(conn);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error indexing " + conn.getRoleType() + " connection " + conn.getEntityId(), e);
        }
    }

    private void indexC2CMapping(ConnectionBase conn) {
        ArrayList<C2CMappingDbEntry> dbEntries = new ArrayList<C2CMappingDbEntry>();
        if (conn instanceof SpConnection) {
            SpConnection spConn = (SpConnection)conn;
            for (C2cContractToAssertionMapping mapping : spConn.getC2cMappings()) {
                dbEntries.add(new C2CMappingDbEntry(spConn.getId(), mapping.getContractId()));
            }
            this.c2cMappingDb.deleteAndSaveEntries(spConn.getId(), dbEntries);
        } else if (conn instanceof IdpConnection) {
            IdpConnection idpConn = (IdpConnection)conn;
            for (C2cContractAttributeMapping mapping : idpConn.getC2cContractMappings()) {
                dbEntries.add(new C2CMappingDbEntry(idpConn.getId(), mapping.getContractId()));
            }
            this.c2cMappingDb.deleteAndSaveEntries(idpConn.getId(), dbEntries);
        }
    }

    private void indexTargetAttributeMapping(ConnectionBase conn) {
        if (conn instanceof IdpConnection) {
            IdpConnection idpConn = (IdpConnection)conn;
            ArrayList<TargetAttributeMappingDbEntry> dbEntries = new ArrayList<TargetAttributeMappingDbEntry>();
            for (TargetAttributeMapping mapping : idpConn.getTargetAttributeMappings()) {
                String adapterId = mapping.getAdapterInstanceId();
                AuthnAdapterInstance overrideInstance = mapping.getConnectionOverrideInstance();
                if (overrideInstance != null) {
                    adapterId = overrideInstance.getParentId();
                }
                dbEntries.add(new TargetAttributeMappingDbEntry(idpConn.getId(), adapterId));
            }
            this.targetAttributeMappingDb.deleteAndSaveEntries(idpConn.getId(), dbEntries);
        }
    }

    private boolean isWsTrustEnabled(ConnectionBase conn) {
        if (conn instanceof IdpConnection) {
            return ((IdpConnection)conn).getWsTrustSettings() != null;
        }
        return ((SpConnection)conn).getWsTrustSettings() != null;
    }

    private String getAbsolutePath(ConnectionDbEntry entry) {
        return this.getAbsolutePath(entry.getFileSystemPath());
    }

    private String getAbsolutePath(String relativePath) {
        return new File(this.getConnsDirectory(), relativePath).getAbsolutePath();
    }

    private String newFileSystemPath(int currEntryCount, String systemId) {
        int dirIndex = currEntryCount / this.getConnsPerDirectory();
        String filename = HashUtil.hashToHexString((String)systemId, (HashAlgorithm)HashAlgorithm.SHA256).substring(0, 32) + EXTENSION;
        return dirIndex + File.separator + filename;
    }

    private int getConnsPerDirectory() {
        return this.configStore.getIntValue(CFG_CONNS_PER_DIRECTORY, 1000);
    }

    private void saveAffiliations() {
        this.log.debug((Object)"Saving affiliations to sourceid-saml2-metadata.xml");
        this.saveAffiliationsFile();
        this.loadAffiliationMap(this.affiliationMetadata);
    }

    private void saveAffiliationsFile() {
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), AFFILIATIONS_XML_FILE_NAME, (XmlObject)this.affiliationMetadata);
    }

    private void prepare4SaveAffiliation(Affiliation affiliation) {
        if (!StringUtils.isBlank((String)affiliation.getId())) {
            this.deleteAffiliationFromInMemoryData(affiliation);
        }
    }

    private void deleteAffiliationFromInMemoryData(Affiliation affiliation) {
        EntitiesDescriptorType entitiesDescriptor = this.affiliationMetadata.getEntitiesDescriptor();
        String id = affiliation.getId();
        EntityDescriptorType[] entityDescriptorArray = entitiesDescriptor.getEntityDescriptorArray();
        for (int i = 0; i < entityDescriptorArray.length; ++i) {
            EntityDescriptorType entityDescType = entityDescriptorArray[i];
            if (!entityDescType.getID().equals(id)) continue;
            entitiesDescriptor.removeEntityDescriptor(i);
            break;
        }
    }

    @Override
    public synchronized Set<AppliesTo> getAppliesToInUseForSpConnections(Set<AppliesTo> appliesToToCheck) {
        return this.getAppliesToInUseForSpConnections(appliesToToCheck, null);
    }

    @Override
    public synchronized Set<AppliesTo> getAppliesToInUseForSpConnections(Set<AppliesTo> appliesToToCheck, String connectionId) {
        HashSet<AppliesTo> results = new HashSet<AppliesTo>();
        Collection<ConnectionDbEntry> wstrustConns = MgmtFactory.getConnectionDb().getWstrustConnections(Role.SP);
        for (ConnectionDbEntry entry : wstrustConns) {
            WsTrustFederatedWscSettings wsTrustSettings;
            SpConnection spConn = this.getSpConnection(entry.getEntityId(), false);
            if (spConn == null || (wsTrustSettings = spConn.getWsTrustSettings()) == null || spConn.getId().equals(connectionId)) continue;
            for (AppliesTo appliesToInUse : wsTrustSettings.getAppliesTo()) {
                if (!appliesToToCheck.contains(appliesToInUse)) continue;
                results.add(appliesToInUse);
            }
        }
        return results;
    }

    protected synchronized String getTopLevelDomain(String entityId) {
        String topLevelDomain;
        try {
            URL spEntityIdUrl = new URL(entityId);
            topLevelDomain = spEntityIdUrl.getHost();
        }
        catch (MalformedURLException e) {
            topLevelDomain = entityId;
        }
        return DomainNameUtil.ascertainHigherLevelDomain(topLevelDomain);
    }

    @Override
    public synchronized String getEntityId(byte[] sourceId, Protocol ... protocols) {
        ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
        for (Protocol protocol : protocols) {
            Collection<ConnectionDbEntry> connectionDbEntries = connectionDb.getEntriesByProtocolAndSourceId(sourceId, protocol);
            if (connectionDbEntries.isEmpty()) continue;
            Set entityIds = connectionDbEntries.stream().map(ConnectionDbEntry::getEntityId).collect(Collectors.toSet());
            if (entityIds.size() > 1) {
                this.log.warn((Object)("SourceID mapped to more than one entity id " + new ByteArrayHashKey(sourceId) + " maps to entityIds: " + StringUtils.join(entityIds, (String)",")));
            }
            return connectionDbEntries.iterator().next().getEntityId();
        }
        throw new ConfigurationException("Unable to lookup entity ID for sourceId: " + HexBin.bytesToString((byte[])sourceId));
    }

    @Override
    public synchronized String getEntityId(ByteArrayHashKey key, Protocol ... protocols) {
        return this.getEntityId(key.getValue(), protocols);
    }

    @Override
    public synchronized SpConnection getByTargetUrl(String targetUrlString) {
        URL targetUrl;
        try {
            targetUrl = new URL(targetUrlString);
        }
        catch (MalformedURLException e) {
            try {
                if (targetUrlString.startsWith("/")) {
                    return null;
                }
                targetUrl = new URL("http://" + targetUrlString);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
        String targetHost = targetUrl.getHost();
        String higherLevelTargetDomain = DomainNameUtil.ascertainHigherLevelDomain(targetHost);
        Collection<ConnectionDbEntry> entries = MgmtFactory.getConnectionDb().getEntriesByTargetUrl(higherLevelTargetDomain);
        if (entries.size() == 1) {
            ConnectionDbEntry entry = entries.iterator().next();
            return this.getSpConnection(entry.getEntityId(), false);
        }
        if (entries.size() > 1) {
            this.log.warn((Object)("More than one SP Connection matched the target URL (" + LogGuard.encode(targetUrlString) + "). Results can be unpredictable when multiple matches are found."));
            SpConnection conn = null;
            Iterator<ConnectionDbEntry> iterator = entries.iterator();
            while (conn == null && iterator.hasNext()) {
                ConnectionDbEntry entry = iterator.next();
                conn = this.getSpConnection(entry.getEntityId(), false);
            }
            return conn;
        }
        return null;
    }

    private ObjectMapper makeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return mapper;
    }

    private File getDeltaReplicationStateFile() {
        return new File(MgmtFactory.getSysDirInfo().getReplicationDirectory(), DELTA_REPLICATION_STATE_FILE_NAME);
    }

    private void loadDeltaReplicationState() {
        this.deltaReplState = new DeltaReplicationState();
        this.deltaReplState.setTombstoneTrackingStartTime(new Date());
        File replStateFile = this.getDeltaReplicationStateFile();
        if (replStateFile.exists()) {
            try {
                this.deltaReplState = (DeltaReplicationState)this.objectMapper.readValue(replStateFile, DeltaReplicationState.class);
                if (this.deltaReplState.getTombstoneTrackingStartTime() == null) {
                    this.deltaReplState.setTombstoneTrackingStartTime(new Date());
                    this.saveDeltaReplicationState();
                }
            }
            catch (IOException e) {
                this.log.error((Object)("Error loading file " + replStateFile), (Throwable)e);
            }
        } else {
            this.saveDeltaReplicationState();
        }
    }

    private void saveDeltaReplicationState() {
        this.log.debug((Object)"Saving delta replication state");
        File replStateFile = this.getDeltaReplicationStateFile();
        if (!replStateFile.getParentFile().exists() && !replStateFile.getParentFile().mkdirs()) {
            throw new ConfigurationException("Failed to create directory " + replStateFile.getParentFile());
        }
        try {
            this.objectMapper.writeValue(replStateFile, (Object)this.deltaReplState);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error saving file " + replStateFile, e);
        }
    }

    @Override
    public Collection<IdpConnection> getIdpConnectionsByName(String name) {
        ArrayList<IdpConnection> connections = new ArrayList<IdpConnection>();
        Collection<ConnectionDbEntry> entries = MgmtFactory.getConnectionDb().getEntriesByName(name, Role.IDP);
        if (!entries.isEmpty()) {
            for (ConnectionDbEntry entry : entries) {
                IdpConnection conn = this.getIdpConnection(entry.getEntityId(), false);
                if (conn != null) {
                    connections.add(conn);
                    continue;
                }
                this.log.warn((Object)("The indexed connection database contained an entry for entity ID '" + name + "', but the connection could not be found on disk."));
            }
        }
        return connections;
    }

    @Override
    public Collection<SpConnection> getSpConnectionsByName(String name) {
        ArrayList<SpConnection> connections = new ArrayList<SpConnection>();
        Collection<ConnectionDbEntry> entries = MgmtFactory.getConnectionDb().getEntriesByName(name, Role.SP);
        if (!entries.isEmpty()) {
            for (ConnectionDbEntry entry : entries) {
                SpConnection conn = this.getSpConnection(entry.getEntityId(), false);
                if (conn != null) {
                    connections.add(conn);
                    continue;
                }
                this.log.warn((Object)("The indexed connection database contained an entry for entity ID '" + name + "', but the connection could not be found on disk."));
            }
        }
        return connections;
    }

    @Override
    public Collection<ReplicationRecord> createPartialReplicationRecords(List<ConnectionBase> connections) {
        ArrayList<ReplicationRecord> records = new ArrayList<ReplicationRecord>();
        for (ConnectionBase connection : connections) {
            ConnectionDbEntry entry = this.connDb.getEntry(connection.getId());
            String id = this.createPartialRecordId(entry);
            byte[] data = this.serializeConnection(connection);
            ReplicationRecord record = new ReplicationRecord(id, data);
            records.add(record);
        }
        return records;
    }

    @Override
    public Collection<ReplicationRecord> createSelectiveReplicationRecords(List<ConnectionBase> connections) {
        ArrayList<ReplicationRecord> records = new ArrayList<ReplicationRecord>();
        for (ConnectionBase connection : connections) {
            String id = connection.getId();
            byte[] data = this.serializeConnection(connection);
            ReplicationRecord record = new ReplicationRecord(id, data);
            records.add(record);
        }
        return records;
    }

    @Override
    public Collection<ReplicationRecord> createSelectiveReplicationRecordsForDelete(List<String> connectionsToDelete) {
        ArrayList<ReplicationRecord> records = new ArrayList<ReplicationRecord>();
        for (String id : connectionsToDelete) {
            records.add(ReplicationRecord.ofTombstone(id));
        }
        return records;
    }

    private String createPartialRecordId(ConnectionDbEntry entry) {
        return entry.getId() + PARTIAL_SUFFIX;
    }

    private boolean isPartialId(String id) {
        return id.endsWith(PARTIAL_SUFFIX);
    }

    private String extractIdFromPartialRecord(String id) {
        if (this.isPartialId(id)) {
            return id.substring(0, id.length() - PARTIAL_SUFFIX.length());
        }
        return id;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class DeltaReplicationState {
        private Date tombstoneTrackingStartTime;
        private List<ConnectionTombstone> tombstones = new ArrayList<ConnectionTombstone>();
        private Date latestDeleteTimestamp = new Date(0L);

        public void addTombstone(ConnectionTombstone tombstone) {
            this.tombstones.add(tombstone);
            this.latestDeleteTimestamp = tombstone.getTimestamp();
        }

        public boolean removeTombstones(String id) {
            boolean result = false;
            Iterator<ConnectionTombstone> tombstoneIter = this.tombstones.iterator();
            while (tombstoneIter.hasNext()) {
                ConnectionTombstone tombstone = tombstoneIter.next();
                if (!StringUtils.equals((String)tombstone.getId(), (String)id)) continue;
                tombstoneIter.remove();
                result = true;
            }
            return result;
        }

        public void removeTombstones(Date endTime) {
            this.tombstones.removeIf(tombstone -> endTime == null || tombstone.getTimestamp().before(endTime));
            this.tombstoneTrackingStartTime = endTime;
        }

        public List<ConnectionTombstone> getTombstones() {
            return Collections.unmodifiableList(this.tombstones);
        }

        public void setTombstones(List<ConnectionTombstone> deletedConns) {
            this.tombstones = deletedConns;
        }

        public Date getLatestDeleteTimestamp() {
            return this.latestDeleteTimestamp;
        }

        public Date getTombstoneTrackingStartTime() {
            return this.tombstoneTrackingStartTime;
        }

        public void setTombstoneTrackingStartTime(Date startTime) {
            this.tombstoneTrackingStartTime = startTime;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    protected static class ConnectionTombstone {
        private String id;
        private Date timestamp;

        public ConnectionTombstone() {
        }

        public ConnectionTombstone(String id, Date timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }
    }

    private class RecordIterator
    implements Iterator<ReplicationRecord> {
        private final Collection<ConnectionTombstone> tombstones;
        private final Collection<ConnectionDbEntry> dbEntries;

        public RecordIterator(Collection<ConnectionTombstone> tombstones, Collection<ConnectionDbEntry> dbEntries) {
            this.tombstones = tombstones;
            this.dbEntries = dbEntries;
        }

        @Override
        public boolean hasNext() {
            return !this.tombstones.isEmpty() || !this.dbEntries.isEmpty();
        }

        @Override
        public ReplicationRecord next() {
            if (!this.tombstones.isEmpty()) {
                Iterator<ConnectionTombstone> iter = this.tombstones.iterator();
                ConnectionTombstone tombstone = iter.next();
                iter.remove();
                return ReplicationRecord.ofTombstone(tombstone.getId());
            }
            if (!this.dbEntries.isEmpty()) {
                Iterator<ConnectionDbEntry> iter = this.dbEntries.iterator();
                ConnectionDbEntry dbEntry = iter.next();
                iter.remove();
                ConnectionBase conn = MetadataDirectoryHybridDbImpl.this.getConnection(dbEntry.getId());
                byte[] data = new byte[]{};
                if (conn != null) {
                    data = MetadataDirectoryHybridDbImpl.this.serializeConnection(conn);
                }
                return new ReplicationRecord(dbEntry.getId(), data);
            }
            throw new NoSuchElementException();
        }
    }
}

