/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BindingEndptChooser {
    public static void doCheckBindingOverride(HttpServletRequest req, Endpoints endpoints, OutMessageContext ctx, String name) {
        String binding = req.getParameter("Binding");
        BindingEndptChooser.doCheckBindingOverride(binding, endpoints, ctx, name);
    }

    public static void doCheckBindingOverride(String binding, Endpoints endpoints, OutMessageContext ctx, String name) {
        BindingEndptChooser.doCheckBindingOverride(binding, endpoints, ctx, name, null);
    }

    public static void doCheckBindingOverride(String binding, Endpoints endpoints, OutMessageContext ctx, String name, String acsIdx) {
        if (!StringUtils.isBlank((String)acsIdx)) {
            try {
                int idx = Integer.parseInt(acsIdx);
                Endpoint endpoint = ((IndexedEndpoints)endpoints).getEndpoint(idx);
                if (endpoint == null) {
                    String message = ctx.getEntityId() + " does not have a " + name + " endpoint with ACSIdx: " + acsIdx;
                    throw new ProcessRuntimeException(message);
                }
                ctx.setBinding(endpoint.getBinding());
                ctx.setEndpoint(endpoint.getFullLocation());
            }
            catch (NumberFormatException nfe) {
                String message = "Invalid ACSIdx parameter passed in for " + ctx.getEntityId() + " : " + acsIdx;
                throw new ProcessRuntimeException(message);
            }
        } else if (!StringUtils.isBlank((String)binding)) {
            Endpoint endpointByBinding = endpoints.getEndpointByBinding(binding);
            if (endpointByBinding == null) {
                String message = ctx.getEntityId() + " does not have a " + name + " endpoint with binding: " + binding;
                throw new ProcessRuntimeException(message);
            }
            ctx.setBinding(endpointByBinding.getBinding());
            ctx.setEndpoint(endpointByBinding.getFullLocation());
        }
    }
}

