/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.AdapterLogoutMode;
import org.sourceid.saml20.profiles.BindingEndptChooser;
import org.sourceid.saml20.profiles.PartnerLogoutManager;
import org.sourceid.saml20.profiles.ResumableRequestHandlerBase;
import org.sourceid.saml20.profiles.SpPartnerLogoutManager;
import org.sourceid.saml20.profiles.idp.IdpAdapterLogoutManager;
import org.sourceid.saml20.profiles.sp.SpAdapterLogoutManager;
import org.sourceid.saml20.protocol.StatusResponseTypeUtil;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestType;
import org.sourceid.saml20.xmlbinding.protocol.LogoutResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.websso.profiles.IdpPartnerLogoutManager;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.sp.SloSupport;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class HandleLogoutRequestBase
extends ResumableRequestHandlerBase
implements SloHandler {
    private final ConfigStore config = ConfigStoreFarm.getConfig(HandleLogoutRequestBase.class);
    protected static final String KEY_SUCCESS = "success";
    protected static final String KEY_PROCESSING_STAGE = "processingStage";
    protected static final String KEY_IDP_BEANS = "idpBeans";
    protected static final String KEY_IDP_ADAPTER_BEANS = "idpAdapterBeans";
    protected static final String KEY_IDP_CONN_BEANS = "idpConnBeans";
    protected static final String KEY_SP_BEANS = "spBeans";
    protected static final String KEY_IDP_ADAPTERS_STARTED = "idpAdaptersStarted";
    protected static final String KEY_SP_ADAPTERS_STARTED = "spAdaptersStarted";

    protected abstract ConnectionBase getPartnerMetadata(InMessageContext var1);

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        LogoutRequestDocument logoutRequestDoc = (LogoutRequestDocument)inMsgCtx.getXmlObject();
        LogoutRequestType logoutRequest = logoutRequestDoc.getLogoutRequest();
        LogoutResponseDocument logoutResponseDoc = LogoutResponseDocument.Factory.newInstance();
        StatusResponseType statusResponseType = logoutResponseDoc.addNewLogoutResponse();
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, req).getVirtualEntityId(DomainMode.RUNTIME);
        StatusResponseTypeUtil.setDefaults(virtualServerId, statusResponseType, (RequestAbstractType)logoutRequest);
        OutMessageContext msgCtxOut = new OutMessageContext(inMsgCtx.getRoleType());
        msgCtxOut.setXmlObject((XmlObject)logoutResponseDoc);
        msgCtxOut.setEntityId(inMsgCtx.getEntityId());
        if (inMsgCtx.isBackChannelBinding()) {
            msgCtxOut.setBinding(inMsgCtx.getBinding());
        } else {
            ConnectionBase connectionBase = this.getPartnerMetadata(inMsgCtx);
            Endpoint singleLogoutSvc = connectionBase.getPreferredSingleLogoutService(false);
            msgCtxOut.setBinding(singleLogoutSvc.getBinding());
            msgCtxOut.setEndpoint(singleLogoutSvc.getFullResponseLocation());
            msgCtxOut.setVirtualServerId(VirtualIdentityUtil.getDefaultVirtualIdForRuntime(connectionBase).getVirtualEntityId(DomainMode.RUNTIME));
            if (this.config.getBooleanValue("ReciprocateBinding", false)) {
                EndpointGroup sloSvcs = connectionBase.getSingleLogoutServices();
                BindingEndptChooser.doCheckBindingOverride(inMsgCtx.getBinding(), (Endpoints)sloSvcs, msgCtxOut, "SLO");
            }
        }
        return msgCtxOut;
    }

    protected void addIdpBeansToParams(Collection<IdpHashableAuthnBean> beans, Map<String, Object> params) {
        ArrayList<IdpHashableAuthnBean> allBeans = new ArrayList<IdpHashableAuthnBean>(beans);
        ArrayList<IdpHashableAuthnBean> idpAdapterBeans = new ArrayList<IdpHashableAuthnBean>();
        ArrayList<IdpConnHashableAuthnBean> idpConnBeans = new ArrayList<IdpConnHashableAuthnBean>();
        for (IdpHashableAuthnBean bean : beans) {
            if (bean instanceof IdpConnHashableAuthnBean) {
                idpConnBeans.add((IdpConnHashableAuthnBean)bean);
                continue;
            }
            idpAdapterBeans.add(bean);
        }
        params.put(KEY_IDP_BEANS, allBeans);
        params.put(KEY_IDP_ADAPTER_BEANS, idpAdapterBeans);
        params.put(KEY_IDP_CONN_BEANS, idpConnBeans);
    }

    protected void addSpBeansToParams(Collection<SpHashableAuthnBean> spAuthnBeans, Map<String, Object> params) {
        SpSessionRegistrySupport.unregisterSessions(spAuthnBeans);
        params.put(KEY_SP_BEANS, SloSupport.doCheckConsolidation(spAuthnBeans));
    }

    protected boolean logoutIdpAdapters(final InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, final OutMessageContext outMsgCtx, final Map<String, Object> params) throws IOException, AuthnAdapterException {
        Collection authnBeans = (Collection)params.get(KEY_IDP_ADAPTER_BEANS);
        AdapterLogoutMode logoutMode = inMsgCtx.isBackChannelBinding() ? AdapterLogoutMode.BACK_CHANNEL_ONLY : AdapterLogoutMode.FRONT_OR_BACK_CHANNEL;
        boolean isFirstIdpAdapter = !params.containsKey(KEY_IDP_ADAPTERS_STARTED);
        params.put(KEY_IDP_ADAPTERS_STARTED, true);
        IdpAdapterLogoutManager logoutManager = new IdpAdapterLogoutManager(authnBeans, req, resp, logoutMode, true, isFirstIdpAdapter){

            @Override
            public String saveLogoutState() {
                return HandleLogoutRequestBase.this.saveState(this.req, this.resp, inMsgCtx, outMsgCtx, params);
            }

            @Override
            public void handleLogoutResult(boolean overallResult, boolean currentResult) {
                HandleLogoutRequestBase.this.updateStatus(params, currentResult);
            }
        };
        return logoutManager.doLogout();
    }

    protected boolean logoutSpAdapters(final InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, final OutMessageContext outMsgCtx, final Map<String, Object> params) throws AuthnAdapterException, IOException {
        Collection spBeans = (Collection)params.get(KEY_SP_BEANS);
        AdapterLogoutMode logoutMode = inMsgCtx.isBackChannelBinding() ? AdapterLogoutMode.BACK_CHANNEL_ONLY : AdapterLogoutMode.FRONT_OR_BACK_CHANNEL;
        boolean isFirstSpAdapter = !params.containsKey(KEY_SP_ADAPTERS_STARTED);
        params.put(KEY_SP_ADAPTERS_STARTED, true);
        SpAdapterLogoutManager logoutManager = new SpAdapterLogoutManager(spBeans, req, resp, logoutMode, true, isFirstSpAdapter){

            @Override
            public String saveLogoutState() {
                return HandleLogoutRequestBase.this.saveState(this.req, this.resp, inMsgCtx, outMsgCtx, params);
            }

            @Override
            public void handleLogoutResult(boolean overallResult, boolean currentResult) {
                HandleLogoutRequestBase.this.updateStatus(params, currentResult);
            }
        };
        return logoutManager.doLogout();
    }

    protected boolean logoutIdpPartners(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) {
        boolean success = (Boolean)params.get(KEY_SUCCESS);
        Collection authnBeans = (Collection)params.get(KEY_IDP_CONN_BEANS);
        IdpPartnerLogoutManager logoutManager = IdpPartnerLogoutManager.forSaml(authnBeans, success, null, params);
        String initiatorEntityId = inMsgCtx.getRoleType() == Role.IDP ? inMsgCtx.getEntityId() : null;
        boolean done = logoutManager.doLogout(inMsgCtx.isBackChannelBinding(), null, initiatorEntityId, this.getClass(), inMsgCtx, outMsgCtx, req, resp);
        this.copyLogoutStatusFromManager(logoutManager, params);
        return done;
    }

    protected boolean logoutSpPartners(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) {
        boolean success = (Boolean)params.get(KEY_SUCCESS);
        Collection authnBeans = (Collection)params.get(KEY_IDP_BEANS);
        SpPartnerLogoutManager logoutManager = new SpPartnerLogoutManager(authnBeans, success, null, params);
        String initiatorEntityId = inMsgCtx.getRoleType() == Role.SP ? inMsgCtx.getEntityId() : null;
        boolean done = logoutManager.doLogout(inMsgCtx.isBackChannelBinding(), null, initiatorEntityId, this.getClass(), inMsgCtx, outMsgCtx, req, resp);
        this.copyLogoutStatusFromManager(logoutManager, params);
        return done;
    }

    protected Collection<SpHashableAuthnBean> getSpAdapterBeans(Collection<IdpHashableAuthnBean> idpBeans) {
        ArrayList<SpHashableAuthnBean> spBeans = new ArrayList<SpHashableAuthnBean>();
        Set primarySessionIds = idpBeans.stream().map(IdpHashableAuthnBean::getPrimarySessionId).collect(Collectors.toSet());
        primarySessionIds.stream().forEach(sessionId -> spBeans.addAll(SpSessionRegistrySupport.lookupAuthnBeansAndSessions(sessionId).keySet()));
        return spBeans;
    }

    protected void updateStatus(Map<String, Object> params, boolean successful) {
        if (!successful) {
            params.put(KEY_SUCCESS, false);
        }
    }

    protected void copyLogoutStatusFromManager(PartnerLogoutManager manager, Map<String, Object> params) {
        params.put(KEY_SUCCESS, manager.getOverallResult());
    }

    protected ProcessingStage getStage(Map<String, Object> params) {
        return (ProcessingStage)((Object)params.get(KEY_PROCESSING_STAGE));
    }

    protected void setStage(Map<String, Object> params, ProcessingStage stage) {
        params.put(KEY_PROCESSING_STAGE, (Object)stage);
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        return state.getParameters().containsKey(KEY_PROCESSING_STAGE);
    }

    protected static enum ProcessingStage {
        LOGGING_OUT_IDP_SIDE,
        WAITING_FOR_IDP_SIDE_RESPONSE,
        LOGGING_OUT_IDP_ADAPTERS,
        LOGGING_OUT_IDP_PARTNERS,
        LOGGING_OUT_SP_ADAPTERS,
        LOGGING_OUT_SP_PARTNERS,
        DONE;

    }
}

