/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import com.pingidentity.common.security.LockingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.a2a.Adapter2AdapterMappingReqCreator;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.jose.jwk.JwkHandler;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ParServerPolicy;
import org.sourceid.oauth20.handlers.AccessGrantRequestHandler;
import org.sourceid.oauth20.handlers.DeviceAuthorizationRequestHandler;
import org.sourceid.oauth20.handlers.HandleAuthorizationRequest;
import org.sourceid.oauth20.handlers.PushedAuthorizationRequestHandler;
import org.sourceid.oauth20.handlers.TokenEndpointRequestHandler;
import org.sourceid.oauth20.handlers.TokenIntrospectEndpointRequestHandler;
import org.sourceid.oauth20.handlers.TokenRevocationRequestHandler;
import org.sourceid.oauth20.handlers.UserAuthorizationRequestHandler;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.profiles.OAuthAccessGrantsRequestCreator;
import org.sourceid.openid.ciba.handlers.CibaAuthenticationRequestHandler;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.openid.connect.handlers.ProviderConfigurationInfoHandler;
import org.sourceid.openid.connect.handlers.RpInitiatedLogoutEndpoint;
import org.sourceid.openid.connect.handlers.UserInfoEndpoint;
import org.sourceid.openid.connect.profiles.sp.BackChannelLogoutEndpoint;
import org.sourceid.openid.connect.profiles.sp.CreateOidcAuthnRequest;
import org.sourceid.openid.connect.profiles.sp.FrontChannelLogoutEndpoint;
import org.sourceid.openid.connect.profiles.sp.HandleOIDCResponse;
import org.sourceid.openid.connect.profiles.sp.OidcThirdPartyLoginRequestCreator;
import org.sourceid.openid.connect.profiles.sp.PostLogoutRedirectHandler;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml1x.profiles.ap.HandleRequest;
import org.sourceid.saml1x.profiles.rp.DestinationSiteFirstRequest;
import org.sourceid.saml1x.profiles.rp.HandleResponse;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.IDPLocalPathMappings;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;
import org.sourceid.saml20.profiles.HandleArtifactRequest;
import org.sourceid.saml20.profiles.idp.CreateAuthnResponse;
import org.sourceid.saml20.profiles.idp.CreateLogoutRequest;
import org.sourceid.saml20.profiles.idp.HandleAttrQueryRequest;
import org.sourceid.saml20.profiles.idp.HandleAuthnRequest;
import org.sourceid.saml20.profiles.idp.HandleLogoutRequest;
import org.sourceid.saml20.profiles.idp.HandleLogoutResponse;
import org.sourceid.saml20.profiles.idp.WriteCDC;
import org.sourceid.saml20.profiles.sp.CreateAttrQuery;
import org.sourceid.saml20.profiles.sp.CreateAuthnRequest;
import org.sourceid.saml20.profiles.sp.CreateCdcAuthnRequest;
import org.sourceid.saml20.profiles.sp.HandleAttrQueryResponse;
import org.sourceid.saml20.profiles.sp.HandleAuthnResponse;
import org.sourceid.saml20.profiles.sp.TerminateAccountLinks;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.BasicHttpRequestHandler;
import org.sourceid.websso.profiles.ConnectionMetadataRequestCreator;
import org.sourceid.websso.profiles.EngineHeartbeatHttpRequestHandler;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.profiles.RequestCreator;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.profiles.ResponseCreator;
import org.sourceid.websso.profiles.ResponseHandler;
import org.sourceid.websso.profiles.ResumableRequestCreator;
import org.sourceid.websso.profiles.ResumableRequestHandler;
import org.sourceid.websso.profiles.ResumableResponseHandler;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.profiles.idp.CreateSsoResponse;
import org.sourceid.websso.profiles.idp.SSORespStarter;
import org.sourceid.websso.profiles.sp.CreateSloRequest;
import org.sourceid.websso.profiles.sp.CreateSsoRequest;
import org.sourceid.websso.profiles.sp.SSOStarter;
import org.sourceid.wsfed.profiles.idp.HandleWsFedRequest;
import org.sourceid.wsfed.profiles.sp.CreateRST;
import org.sourceid.wsfed.profiles.sp.HandleRSTR;
import org.sourceid.wsfed.profiles.sp.HandleSignoutCleanupRequest;
import org.sourceid.wstrust.handlers.IdpWSTrustRequestHandler;
import org.sourceid.wstrust.handlers.SpWSTrustRequestHandler;
import org.sourceid.wstrust.handlers.StsWSTrustRequestHandler;

public class ProfileProcessFactory {
    public static final String METADATA_SERVICE_ENDPOINT = "/pf/metadata.ping";
    public static final String ADAPTER_MAPPING_ENDPOINT = "/pf/adapter2adapter.ping";
    public static final String WSTRUST_STS_METADATA_SERVICE_ENDPOINT = "/pf/ws-trust_sts_metadata.ping";
    public static final String WSTRUST_STS_MEX_ENDPOINT = "/pf/sts_mex.ping";
    public static final String SAML_WSFED_METADATA_ENDPOINT = "/pf/federation_metadata.ping";
    public static final String OAUTH_ACCESS_GRANT_ENDPOINT = "/as/oauth_access_grants.ping";
    public static final String OAUTH_TOKEN_ENDPOINT = "/as/token.oauth2";
    public static final String OAUTH_AUTHZ_ENDPOINT = "/as/authorization.oauth2";
    public static final String OAUTH_GRANTS_ENDPOINT = "/as/grants.oauth2";
    public static final String OAUTH_REVOKE_TOKEN_ENDPOINT = "/as/revoke_token.oauth2";
    public static final String OAUTH_INTROSPECT_ENDPOINT = "/as/introspect.oauth2";
    public static final String OAUTH_DEVICE_AUTHZ_ENDPOINT = "/as/device_authz.oauth2";
    public static final String OAUTH_USER_AUTHZ_ENDPOINT = "/as/user_authz.oauth2";
    public static final String OAUTH_PAR_ENDPOINT = "/as/par.oauth2";
    public static final String OIDC_CB = "/sp/cb.openid";
    public static final String OIDC_THIRD_PARTY_LOGIN = "/sp/init_login.ping";
    public static final String OIDC_BACK_CHANNEL_LOGOUT_ENDPOINT = "/sp/bc-logout.openid";
    public static final String OIDC_FRONT_CHANNEL_LOGOUT_ENDPOINT = "/sp/fc-logout.openid";
    public static final String OIDC_POST_LOGOUT_ENDPOINT = "/sp/post-logout.openid";
    public static final String STS_ENDPOINT = "/pf/sts.wst";
    public static final String JWK_SET_URL = "/pf/JWKS";
    public static final String OPENID_PROVIDER_INFO_ENDPOINT = "/.well-known/openid-configuration";
    public static final String OAUTH_AUTHORIZATION_SERVER_ENDPOINT = "/.well-known/oauth-authorization-server";
    public static final String OAUTH_DYNAMIC_CLIENT_REG_ENDPOINT = "/as/clients.oauth2";
    public static final String OPENID_USERINFO_ENDPOINT = "/idp/userinfo.openid";
    public static final String OPENID_RP_INITIATED_LOGOUT_ENDPOINT = "/idp/init_logout.openid";
    public static final String CIBA_AUTHN_REQUEST_ENDPOINT = "/as/bc-auth.ciba";
    public static final String PF_WS_REST_SESSION_MGMT_PATH = "/pf-ws/rest/sessionMgmt/";
    public static final String PING_REVOKED_SRIS_ENDPOINT = "/pf-ws/rest/sessionMgmt/revokedSris";
    public static final String PING_SESSION_MANAGEMENT_SRIS_ENDPOINT = "/pf-ws/rest/sessionMgmt/sessions";
    public static final String PING_SESSION_MANAGEMENT_USERS_ENDPOINT = "/pf-ws/rest/sessionMgmt/users";
    public static final String HEARTBEAT_ENDPOINT = "/pf/heartbeat.ping";
    private final Log log = LogFactory.getLog(this.getClass());
    private final LightweightStandardsBasedMap<String, RequestCreator> requestCreatorsMap;
    private final LightweightStandardsBasedMap<String, ResponseCreator> responseCreatorsMap;
    private final LightweightStandardsBasedMap<String, ResumableRequestCreator> resumableRequestCreatorsMap;
    private final LightweightStandardsBasedMap<String, ResumableRequestHandler> resumableRequestHandlersMap;
    private final LightweightStandardsBasedMap<String, ResumableResponseHandler> resumableResponseHandlersMap;
    private final LightweightStandardsBasedMap<String, RequestHandler> requestHandlerMap;
    private final LightweightStandardsBasedMap<String, ResponseHandler> responseHandlersMap;
    private final LightweightStandardsBasedMap<String, BasicHttpRequestHandler> basicHttpRequestHandlerMap;
    private final LightweightStandardsBasedMap<String, ResponseHandler> relatedResponseHandlersMap;
    private final LightweightStandardsBasedMap<String, Role> pathToPartnerRoleMap;
    private final Map<String, ResumeRequestFromAuthnResponseHandler> class2ResumeRequestFromAuthnResponseHandlerMap;
    private final Map<String, ResumeRequestFromResponseHandler> class2ResumeRequestFromResponseHandlerMap;
    private final CreateSsoRequest createSsoRequest;
    private final CreateSsoResponse createSsoResponse = new CreateSsoResponse();
    private final CreateSloRequest createSloRequest = new CreateSloRequest();
    private static Map<String, ResumeRequestFromAuthnResponseHandler> staticClass2ResumeRequestFromAuthnResponseHandlerMap = new ConcurrentHashMap<String, ResumeRequestFromAuthnResponseHandler>();

    public ProfileProcessFactory(MetadataLocal localMetaData) {
        this.requestCreatorsMap = new LightweightStandardsBasedMap("request creator");
        this.responseCreatorsMap = new LightweightStandardsBasedMap("response creator");
        this.resumableRequestCreatorsMap = new LightweightStandardsBasedMap("resumable request creator");
        this.resumableRequestHandlersMap = new LightweightStandardsBasedMap("resumable request handler");
        this.resumableResponseHandlersMap = new LightweightStandardsBasedMap("resumable response handler");
        this.requestHandlerMap = new LightweightStandardsBasedMap("request handler");
        this.responseHandlersMap = new LightweightStandardsBasedMap("response handler");
        this.relatedResponseHandlersMap = new LightweightStandardsBasedMap("related response handler");
        this.basicHttpRequestHandlerMap = new LightweightStandardsBasedMap("Basic HTTP Request Handler");
        this.pathToPartnerRoleMap = new LightweightStandardsBasedMap("handler (role)");
        this.class2ResumeRequestFromAuthnResponseHandlerMap = new HashMap<String, ResumeRequestFromAuthnResponseHandler>();
        this.class2ResumeRequestFromResponseHandlerMap = new HashMap<String, ResumeRequestFromResponseHandler>();
        HandleArtifactRequest handleArtifactReq = new HandleArtifactRequest();
        this.createSsoRequest = new CreateSsoRequest(localMetaData);
        boolean licenseValidated = LicenseManager.isValidForRuntime();
        Mediator mediator = MgmtFactory.getMediator();
        boolean isEngine = mediator.isEngine();
        if (licenseValidated && isEngine) {
            this.saml20Idp(localMetaData, handleArtifactReq);
            this.saml20Sp(localMetaData, handleArtifactReq);
            this.oidcSp(localMetaData);
            this.saml1xIdp(localMetaData);
            this.saml1xSp(localMetaData);
            this.wsfedIdp(localMetaData);
            this.wsfedSp(localMetaData);
            this.setupHeartbeat();
            this.setupConnectionMetadata();
            this.setupSts(localMetaData);
            this.setupOAuth(localMetaData);
            this.setupOpenIDConnect(localMetaData);
            this.setUpAdapter2AdapterSSO(localMetaData);
            this.setupSLOEndpoints(localMetaData);
        } else {
            this.log.debug((Object)("license validated: " + licenseValidated + " && is engine: " + isEngine));
        }
        ArrayList<LightweightStandardsBasedMap<String, Object>> maps = new ArrayList<LightweightStandardsBasedMap<String, Object>>();
        maps.add(this.requestCreatorsMap);
        maps.add(this.responseCreatorsMap);
        maps.add(this.resumableRequestCreatorsMap);
        maps.add(this.resumableRequestHandlersMap);
        maps.add(this.resumableResponseHandlersMap);
        maps.add(this.requestHandlerMap);
        maps.add(this.responseHandlersMap);
        maps.add(this.relatedResponseHandlersMap);
        maps.add(this.pathToPartnerRoleMap);
        for (LightweightStandardsBasedMap lightweightStandardsBasedMap : maps) {
            this.log.debug((Object)lightweightStandardsBasedMap);
        }
    }

    private void setupSLOEndpoints(MetadataLocal localMetaData) {
        OpenIdConnectProviderPolicyManager connectProviderPolicyMgr;
        boolean trackAdapterSessionsForLogout = MgmtFactory.getSessionSettingsManager().getSessionSettings().isTrackAdapterSessionsForLogout();
        if (MetadataLocalHelper.isEnableIdp(localMetaData) && trackAdapterSessionsForLogout) {
            this.setUpIdpInitSlo(null, localMetaData);
        }
        if (MetadataLocalHelper.isEnableSp(localMetaData) && trackAdapterSessionsForLogout) {
            this.setUpStartSLO(localMetaData);
        }
        if (MgmtFactory.getAuthzServerManager().isEnableOAuth() && (connectProviderPolicyMgr = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class)).getPolicy().isTrackUserSessionsForLogout()) {
            if (MetadataLocalHelper.isEnableIdp(localMetaData)) {
                this.setUpIdpInitSlo(null, localMetaData);
            }
            if (MetadataLocalHelper.isEnableSp(localMetaData)) {
                this.setUpStartSLO(localMetaData);
            }
        }
    }

    private void setupOpenIDConnect(MetadataLocal localMetaData) {
        OpenIdConnectProviderPolicyManager connectProviderPolicyManager = GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
        if (connectProviderPolicyManager.getPolicy().isEnabled()) {
            UserInfoEndpoint userInfoEndpoint = new UserInfoEndpoint();
            this.requestHandlerMap.put(OPENID_USERINFO_ENDPOINT, userInfoEndpoint);
            this.pathToPartnerRoleMap.put(OPENID_USERINFO_ENDPOINT, Role.SP);
            this.basicHttpRequestHandlerMap.put(OPENID_PROVIDER_INFO_ENDPOINT, ProviderConfigurationInfoHandler.createOpenIDConnectProviderConfigurationInfoHandler());
            this.basicHttpRequestHandlerMap.put(JWK_SET_URL, new JwkHandler(MgmtFactory.getJWKSEndpointManager()));
            this.setUpIdpInitSlo(null, localMetaData);
            CibaAuthenticationRequestHandler ciba = new CibaAuthenticationRequestHandler();
            this.requestHandlerMap.put(CIBA_AUTHN_REQUEST_ENDPOINT, ciba);
            this.pathToPartnerRoleMap.put(CIBA_AUTHN_REQUEST_ENDPOINT, Role.SP);
            RpInitiatedLogoutEndpoint rpInitiatedLogoutEndpoint = new RpInitiatedLogoutEndpoint();
            this.requestHandlerMap.put(OPENID_RP_INITIATED_LOGOUT_ENDPOINT, rpInitiatedLogoutEndpoint);
            this.pathToPartnerRoleMap.put(OPENID_RP_INITIATED_LOGOUT_ENDPOINT, Role.SP);
            PostLogoutRedirectHandler postLogoutRedirectHandler = new PostLogoutRedirectHandler();
            this.responseHandlersMap.put(OIDC_POST_LOGOUT_ENDPOINT, postLogoutRedirectHandler);
            this.pathToPartnerRoleMap.put(OIDC_POST_LOGOUT_ENDPOINT, Role.IDP);
        }
    }

    private void setupOAuth(MetadataLocal localMD) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        if (authzServerManager.isEnableOAuth()) {
            HandleAuthorizationRequest handleAuthzReq = new HandleAuthorizationRequest();
            String resumeAuthzPath = localMD.getPathUtil().convertToResumePath(OAUTH_AUTHZ_ENDPOINT, null, null);
            this.requestHandlerMap.put(OAUTH_AUTHZ_ENDPOINT, handleAuthzReq);
            Role whatroleistheasanyway = Role.SP;
            this.pathToPartnerRoleMap.put(OAUTH_AUTHZ_ENDPOINT, whatroleistheasanyway);
            this.resumableRequestHandlersMap.put(resumeAuthzPath, handleAuthzReq);
            this.class2ResumeRequestFromAuthnResponseHandlerMap.put(handleAuthzReq.getClass().getName(), handleAuthzReq);
            this.basicHttpRequestHandlerMap.put(OAUTH_AUTHORIZATION_SERVER_ENDPOINT, ProviderConfigurationInfoHandler.createOAuthProviderConfigurationInfoHandler());
            ParServerPolicy.Status parStatus = authzServerManager.getParServerPolicy().getStatus();
            if (parStatus != ParServerPolicy.Status.DISABLED) {
                this.requestHandlerMap.put(OAUTH_PAR_ENDPOINT, new PushedAuthorizationRequestHandler());
                this.pathToPartnerRoleMap.put(OAUTH_PAR_ENDPOINT, whatroleistheasanyway);
            }
            AccessGrantRequestHandler accessGrantRequestHandler = new AccessGrantRequestHandler();
            String resumeAccessGrantRequestHandlerPath = localMD.getPathUtil().convertToResumePath(OAUTH_GRANTS_ENDPOINT, null, null);
            this.requestHandlerMap.put(OAUTH_GRANTS_ENDPOINT, accessGrantRequestHandler);
            this.pathToPartnerRoleMap.put(OAUTH_GRANTS_ENDPOINT, Role.SP);
            this.resumableRequestHandlersMap.put(resumeAccessGrantRequestHandlerPath, accessGrantRequestHandler);
            this.class2ResumeRequestFromAuthnResponseHandlerMap.put(accessGrantRequestHandler.getClass().getName(), accessGrantRequestHandler);
            TokenEndpointRequestHandler tokenEndpointHandler = new TokenEndpointRequestHandler();
            this.requestHandlerMap.put(OAUTH_TOKEN_ENDPOINT, tokenEndpointHandler);
            this.pathToPartnerRoleMap.put(OAUTH_TOKEN_ENDPOINT, whatroleistheasanyway);
            OAuthAccessGrantsRequestCreator oauthAccessGrantsRequestCreator = new OAuthAccessGrantsRequestCreator();
            this.requestCreatorsMap.put(OAUTH_ACCESS_GRANT_ENDPOINT, oauthAccessGrantsRequestCreator);
            TokenRevocationRequestHandler tokenRevocationHandler = new TokenRevocationRequestHandler();
            this.requestHandlerMap.put(OAUTH_REVOKE_TOKEN_ENDPOINT, tokenRevocationHandler);
            this.pathToPartnerRoleMap.put(OAUTH_REVOKE_TOKEN_ENDPOINT, whatroleistheasanyway);
            TokenIntrospectEndpointRequestHandler tokenIntrospectHandler = new TokenIntrospectEndpointRequestHandler();
            this.requestHandlerMap.put(OAUTH_INTROSPECT_ENDPOINT, tokenIntrospectHandler);
            this.pathToPartnerRoleMap.put(OAUTH_INTROSPECT_ENDPOINT, whatroleistheasanyway);
            KeyValueStateSupport keyValueStateSupport = new KeyValueStateSupport();
            DeviceAuthorizationRequestHandler deviceAuthorizationRequestHandler = new DeviceAuthorizationRequestHandler(authzServerManager, MgmtFactory.getDeviceFlowManager(), keyValueStateSupport, OAuthIssuerUtils.getInstance());
            this.requestHandlerMap.put(OAUTH_DEVICE_AUTHZ_ENDPOINT, deviceAuthorizationRequestHandler);
            this.pathToPartnerRoleMap.put(OAUTH_DEVICE_AUTHZ_ENDPOINT, whatroleistheasanyway);
            LockingService userAuthzLockingService = MgmtFactory.getAccountLockingService().getInstance(UserAuthorizationRequestHandler.class.getSimpleName());
            ConfigStore userAuthzConfig = ConfigStoreFarm.getConfig("oauth-device-flow");
            UserAuthorizationRequestHandler userAuthorizationRequestHandler = new UserAuthorizationRequestHandler(keyValueStateSupport, MgmtFactory.getDeviceFlowManager(), MgmtFactory.getClientManager(), userAuthzLockingService, userAuthzConfig, MgmtFactory.getOAuthConsentManager(), MgmtFactory.getAuthzServerManager());
            this.requestHandlerMap.put(OAUTH_USER_AUTHZ_ENDPOINT, userAuthorizationRequestHandler);
            this.pathToPartnerRoleMap.put(OAUTH_USER_AUTHZ_ENDPOINT, whatroleistheasanyway);
            String resumeUserAuthzRequestHandlerPath = localMD.getPathUtil().convertToResumePath(OAUTH_USER_AUTHZ_ENDPOINT, null, null);
            this.resumableRequestHandlersMap.put(resumeUserAuthzRequestHandlerPath, userAuthorizationRequestHandler);
            this.class2ResumeRequestFromAuthnResponseHandlerMap.put(userAuthorizationRequestHandler.getClass().getName(), userAuthorizationRequestHandler);
        }
    }

    private void setUpAdapter2AdapterSSO(MetadataLocal localMD) {
        Adapter2AdapterManager adapter2AdapterMgr = GlobalRegistry.getService(Adapter2AdapterManager.class);
        if (!adapter2AdapterMgr.getMappings().isEmpty()) {
            Adapter2AdapterMappingReqCreator sirc = new Adapter2AdapterMappingReqCreator(localMD);
            this.requestCreatorsMap.put(ADAPTER_MAPPING_ENDPOINT, sirc);
            String resumePath = localMD.getPathUtil().convertToResumePath(ADAPTER_MAPPING_ENDPOINT, null, null);
            this.resumableRequestCreatorsMap.put(resumePath, sirc);
            this.class2ResumeRequestFromAuthnResponseHandlerMap.put(sirc.getClass().getName(), sirc);
        }
    }

    private void saml1xSp(MetadataLocal localMetaData) {
        if (localMetaData.getEnableSaml11Rp() || localMetaData.getEnableSaml10Rp()) {
            String[] acss;
            for (String saml1xAcsEndpint : acss = new String[]{localMetaData.getSaml1xAcsEndpoint()}) {
                HandleResponse handleResponse = new HandleResponse();
                this.responseHandlersMap.put(saml1xAcsEndpint, handleResponse);
                this.pathToPartnerRoleMap.put(saml1xAcsEndpint, Role.IDP);
                String resumeLocation = localMetaData.getPathUtil().convertToResumePath(saml1xAcsEndpint, null, null);
                this.resumableResponseHandlersMap.put(resumeLocation, handleResponse);
            }
            DestinationSiteFirstRequest starter = new DestinationSiteFirstRequest();
            this.setUpStartSSO(localMetaData, Protocol.SAML10, starter);
            this.setUpStartSSO(localMetaData, Protocol.SAML11, starter);
        }
    }

    private void setupSts(MetadataLocal localMetaData) {
        if (localMetaData.getEnableSpWsTrustSts()) {
            this.pathToPartnerRoleMap.put(localMetaData.getSpWsTrustStsEndpoint(), Role.IDP);
            SpWSTrustRequestHandler spWSTrustRequestHandler = new SpWSTrustRequestHandler();
            spWSTrustRequestHandler.setEndpoint(localMetaData.getSpWsTrustStsEndpoint());
            this.requestHandlerMap.put(localMetaData.getSpWsTrustStsEndpoint(), spWSTrustRequestHandler);
        }
        if (localMetaData.getEnableIdpWsTrustSts()) {
            this.pathToPartnerRoleMap.put(localMetaData.getIdpWsTrustStsEndpoint(), Role.SP);
            IdpWSTrustRequestHandler idpWSTrustRequestHandler = new IdpWSTrustRequestHandler();
            idpWSTrustRequestHandler.setEndpoint(localMetaData.getIdpWsTrustStsEndpoint());
            this.requestHandlerMap.put(localMetaData.getIdpWsTrustStsEndpoint(), idpWSTrustRequestHandler);
        }
        if (localMetaData.getEnableIdpWsTrustSts() && localMetaData.getEnableSpWsTrustSts()) {
            StsWSTrustRequestHandler stsWSTrustRequestHandler = new StsWSTrustRequestHandler();
            this.pathToPartnerRoleMap.put(STS_ENDPOINT, Role.NA);
            this.requestHandlerMap.put(STS_ENDPOINT, stsWSTrustRequestHandler);
        }
    }

    private void saml1xIdp(MetadataLocal localMetaData) {
        if (localMetaData.getEnableSaml11Ap() || localMetaData.getEnableSaml10Ap()) {
            String[] isxs;
            CreateResponse starter = new CreateResponse();
            this.setUpStartSSOResp(localMetaData, Protocol.SAML10, starter, starter);
            this.setUpStartSSOResp(localMetaData, Protocol.SAML11, starter, starter);
            this.class2ResumeRequestFromAuthnResponseHandlerMap.put(starter.getClass().getName(), starter);
            for (String isxpath : isxs = new String[]{localMetaData.getSaml1xIsxEndpoint()}) {
                this.requestHandlerMap.put(isxpath, starter);
                this.pathToPartnerRoleMap.put(isxpath, Role.SP);
                String resumePath = localMetaData.getPathUtil().convertToResumePath(isxpath, Protocol.SAML10.toString(), null);
                this.resumableRequestHandlersMap.put(resumePath, starter);
                resumePath = localMetaData.getPathUtil().convertToResumePath(isxpath, Protocol.SAML11.toString(), null);
                this.resumableRequestHandlersMap.put(resumePath, starter);
            }
            String[] soaps = new String[]{localMetaData.getSaml1xSoapEndpoint()};
            HandleRequest handleReq = new HandleRequest();
            for (String saml1xSoapEndpoint : soaps) {
                this.requestHandlerMap.put(saml1xSoapEndpoint, handleReq);
                this.pathToPartnerRoleMap.put(saml1xSoapEndpoint, Role.SP);
            }
        }
    }

    private void wsfedSp(MetadataLocal localMetaData) {
        if (localMetaData.getEnableWsFedSp()) {
            this.setUpStartSSO(localMetaData, Protocol.WSFED, new CreateRST());
            String spWsFedEndpoint = localMetaData.getSpWsFedEndpoint();
            this.pathToPartnerRoleMap.put(spWsFedEndpoint, Role.IDP);
            HandleRSTR handleRSTR = new HandleRSTR();
            this.responseHandlersMap.put(spWsFedEndpoint, handleRSTR);
            String resumeLocation = localMetaData.getPathUtil().convertToResumePath(spWsFedEndpoint, null, null);
            this.resumableResponseHandlersMap.put(resumeLocation, handleRSTR);
            this.setUpStartSLO(localMetaData);
            HandleSignoutCleanupRequest cleanupHandler = new HandleSignoutCleanupRequest();
            this.requestHandlerMap.put(spWsFedEndpoint, cleanupHandler);
            String resumePathQualifier = "scr";
            String resumeCleanupLocation = localMetaData.getPathUtil().convertToResumePath(spWsFedEndpoint, resumePathQualifier, null);
            this.resumableRequestHandlersMap.put(resumeCleanupLocation, cleanupHandler);
        }
    }

    private void wsfedIdp(MetadataLocal localMetaData) {
        if (localMetaData.getEnableWsFedIdP()) {
            String idpWsFedEndpoint = localMetaData.getIdpWsFedEndpoint();
            HandleWsFedRequest handleWsFedRequest = new HandleWsFedRequest();
            handleWsFedRequest.registerRstHandlerAsResumeFromResponseHandler(this.class2ResumeRequestFromAuthnResponseHandlerMap);
            this.requestHandlerMap.put(idpWsFedEndpoint, handleWsFedRequest);
            this.pathToPartnerRoleMap.put(idpWsFedEndpoint, Role.SP);
            String resumeLocation = localMetaData.getPathUtil().convertToResumePath(idpWsFedEndpoint, null, null);
            this.resumableRequestHandlersMap.put(resumeLocation, handleWsFedRequest);
            this.setUpIdpInitSlo(null, localMetaData);
        }
    }

    private void setupHeartbeat() {
        EngineHeartbeatHttpRequestHandler heartbeatHandler = new EngineHeartbeatHttpRequestHandler();
        this.basicHttpRequestHandlerMap.put(HEARTBEAT_ENDPOINT, heartbeatHandler);
    }

    private void setupConnectionMetadata() {
        ConnectionMetadataRequestCreator wsTrustStsMetadataRequestCreator = new ConnectionMetadataRequestCreator();
        this.requestCreatorsMap.put(WSTRUST_STS_METADATA_SERVICE_ENDPOINT, wsTrustStsMetadataRequestCreator);
        this.requestCreatorsMap.put(WSTRUST_STS_MEX_ENDPOINT, wsTrustStsMetadataRequestCreator);
        this.requestCreatorsMap.put(SAML_WSFED_METADATA_ENDPOINT, wsTrustStsMetadataRequestCreator);
    }

    private void saml20Sp(MetadataLocal localMetaData, HandleArtifactRequest handleArtifactReq) {
        if (localMetaData.getEnableSaml20Sp()) {
            Role currentPartnerRole = Role.IDP;
            SPLocalPathMappings spLocalPaths = localMetaData.getSpLocalPathMappings();
            this.setUpStartSSO(localMetaData, Protocol.SAML20, new CreateAuthnRequest());
            CreateCdcAuthnRequest spCreateCdcAuthnRequest = new CreateCdcAuthnRequest();
            this.requestCreatorsMap.put(spLocalPaths.getInitiateCdcSSOPath(), spCreateCdcAuthnRequest);
            String initiateCdcSSOPath = spLocalPaths.getInitiateCdcSSOPath();
            String resumeSpCreateCdcAuthnRequestPath = localMetaData.getPathUtil().convertToResumePath(initiateCdcSSOPath, null, null);
            this.resumableRequestCreatorsMap.put(resumeSpCreateCdcAuthnRequestPath, spCreateCdcAuthnRequest);
            org.sourceid.saml20.profiles.sp.HandleLogoutResponse spHandleLogoutResponse = new org.sourceid.saml20.profiles.sp.HandleLogoutResponse();
            this.setUpStartSLO(localMetaData);
            TerminateAccountLinks terminateAccountLinks = new TerminateAccountLinks();
            String termPath = spLocalPaths.getTerminateLocalLinksPath();
            this.requestCreatorsMap.put(termPath, terminateAccountLinks);
            String resumeTermPath = localMetaData.getPathUtil().convertToResumePath(termPath, null, null);
            this.resumableRequestCreatorsMap.put(resumeTermPath, terminateAccountLinks);
            HandleAuthnResponse handleAuthnResponse = new HandleAuthnResponse();
            IndexedEndpoints assertionConsumerServices = localMetaData.getAssertionConsumerServices();
            for (Endpoint endpoint : assertionConsumerServices.getEndpointsMap().values()) {
                String location = endpoint.getFullLocation();
                this.responseHandlersMap.put(location, handleAuthnResponse);
                this.pathToPartnerRoleMap.put(location, currentPartnerRole);
                String resumeLocation = localMetaData.getPathUtil().convertToResumePath(location, null, null);
                this.resumableResponseHandlersMap.put(resumeLocation, handleAuthnResponse);
            }
            org.sourceid.saml20.profiles.sp.HandleLogoutRequest spHandleLogoutRequest = new org.sourceid.saml20.profiles.sp.HandleLogoutRequest();
            EndpointGroup spSingleLogoutServices = localMetaData.getSpSingleLogoutServices();
            for (Object endpoint : spSingleLogoutServices.getEndpoints()) {
                String location = ((Endpoint)endpoint).getFullLocation();
                this.requestHandlerMap.put(location, spHandleLogoutRequest);
                this.pathToPartnerRoleMap.put(location, currentPartnerRole);
                String resumeLocation = localMetaData.getPathUtil().convertToResumePath(location, null, null);
                this.resumableRequestHandlersMap.put(resumeLocation, spHandleLogoutRequest);
                String responseLocation = ((Endpoint)endpoint).getResponseLocation();
                this.responseHandlersMap.put(responseLocation, spHandleLogoutResponse);
                this.pathToPartnerRoleMap.put(responseLocation, currentPartnerRole);
            }
            IndexedEndpoints artifactResolutionServices = localMetaData.getSpArtifactResolutionServices();
            for (Endpoint endpoint : artifactResolutionServices.getEndpointsMap().values()) {
                String location = endpoint.getFullLocation();
                this.requestHandlerMap.put(location, handleArtifactReq);
                this.pathToPartnerRoleMap.put(location, currentPartnerRole);
            }
            CreateAttrQuery createAttrQuery = new CreateAttrQuery();
            HandleAttrQueryResponse handleAttrQueryResponse = new HandleAttrQueryResponse();
            String path = spLocalPaths.getInitiateAttributeQueryPath();
            this.requestCreatorsMap.put(path, createAttrQuery);
            this.relatedResponseHandlersMap.put(path, handleAttrQueryResponse);
        }
    }

    private void oidcSp(MetadataLocal localMetaData) {
        if (localMetaData.getEnableOIDCSp()) {
            this.setUpStartSSO(localMetaData, Protocol.OIDC, new CreateOidcAuthnRequest());
            HandleOIDCResponse handleOIDCResponse = new HandleOIDCResponse();
            this.responseHandlersMap.put(OIDC_CB, handleOIDCResponse);
            OidcThirdPartyLoginRequestCreator oidcThirdPartyLoginRequestCreator = new OidcThirdPartyLoginRequestCreator();
            this.requestCreatorsMap.put(OIDC_THIRD_PARTY_LOGIN, oidcThirdPartyLoginRequestCreator);
            this.pathToPartnerRoleMap.put(OIDC_THIRD_PARTY_LOGIN, Role.IDP);
            this.pathToPartnerRoleMap.put(OIDC_CB, Role.IDP);
            String resumeLocation = localMetaData.getPathUtil().convertToResumePath(OIDC_CB, null, null);
            this.resumableResponseHandlersMap.put(resumeLocation, handleOIDCResponse);
            this.basicHttpRequestHandlerMap.put(JWK_SET_URL, new JwkHandler(MgmtFactory.getJWKSEndpointManager()));
            BackChannelLogoutEndpoint backChannelLogoutEndpoint = new BackChannelLogoutEndpoint();
            this.requestHandlerMap.put(OIDC_BACK_CHANNEL_LOGOUT_ENDPOINT, backChannelLogoutEndpoint);
            this.pathToPartnerRoleMap.put(OIDC_BACK_CHANNEL_LOGOUT_ENDPOINT, Role.IDP);
            FrontChannelLogoutEndpoint frontChannelLogoutEndpoint = new FrontChannelLogoutEndpoint();
            this.requestHandlerMap.put(OIDC_FRONT_CHANNEL_LOGOUT_ENDPOINT, frontChannelLogoutEndpoint);
            this.pathToPartnerRoleMap.put(OIDC_FRONT_CHANNEL_LOGOUT_ENDPOINT, Role.IDP);
            resumeLocation = localMetaData.getPathUtil().convertToResumePath(OIDC_FRONT_CHANNEL_LOGOUT_ENDPOINT, null, null);
            this.resumableRequestHandlersMap.put(resumeLocation, frontChannelLogoutEndpoint);
        }
    }

    private void setUpStartSSO(MetadataLocal localMetaData, Protocol proto, SSOStarter starter) {
        SPLocalPathMappings spLocalPaths = localMetaData.getSpLocalPathMappings();
        this.createSsoRequest.setSSOStarter(proto, starter);
        String initiateSsoPath = spLocalPaths.getInitiateSSOPath();
        this.requestCreatorsMap.put(initiateSsoPath, this.createSsoRequest);
        String resumeInitSsoPath = localMetaData.getPathUtil().convertToResumePath(initiateSsoPath, null, null);
        this.resumableRequestCreatorsMap.put(resumeInitSsoPath, this.createSsoRequest);
        this.class2ResumeRequestFromAuthnResponseHandlerMap.put(this.createSsoRequest.getClass().getName(), this.createSsoRequest);
    }

    private void setUpStartSSOResp(MetadataLocal localMetaData, Protocol proto, SSORespStarter starter, ResumableRequestHandler resumableRequestHandler) {
        IDPLocalPathMappings idpLocalPaths = localMetaData.getIdpLocalPathMappings();
        this.createSsoResponse.setSsoRespStarter(proto, starter);
        this.responseCreatorsMap.put(idpLocalPaths.getInitiateSSOPath(), this.createSsoResponse);
        String initiateSsoPath = idpLocalPaths.getInitiateSSOPath();
        String resumeInitSsoPath = localMetaData.getPathUtil().convertToResumePath(initiateSsoPath, proto.toString(), null);
        this.resumableRequestHandlersMap.put(resumeInitSsoPath, resumableRequestHandler);
    }

    private void setUpStartSLO(MetadataLocal localMetaData) {
        SPLocalPathMappings spLocalPaths = localMetaData.getSpLocalPathMappings();
        String spInitSloPath = spLocalPaths.getInitiateSLOPath();
        this.requestCreatorsMap.put(spInitSloPath, this.createSloRequest);
        org.sourceid.saml20.profiles.sp.HandleLogoutResponse spHandleLogoutResponse = new org.sourceid.saml20.profiles.sp.HandleLogoutResponse();
        this.relatedResponseHandlersMap.put(spInitSloPath, spHandleLogoutResponse);
        String resumeSpInitSloPath = localMetaData.getPathUtil().convertToResumePath(spInitSloPath, null, null);
        this.resumableRequestCreatorsMap.put(resumeSpInitSloPath, this.createSloRequest);
        this.relatedResponseHandlersMap.put(resumeSpInitSloPath, spHandleLogoutResponse);
        this.setUpIdpInitSlo(null, localMetaData);
    }

    private void saml20Idp(MetadataLocal localMetaData, HandleArtifactRequest handleArtifiactReq) {
        if (localMetaData.getEnableSaml20IdP()) {
            String location;
            Role currentPartnerRole = Role.SP;
            IDPLocalPathMappings idpLocalPaths = localMetaData.getIdpLocalPathMappings();
            CreateAuthnResponse createAuthnResponse = new CreateAuthnResponse();
            HandleAuthnRequest handleAuthnRequest = createAuthnResponse.handleAuthnRequest;
            this.setUpStartSSOResp(localMetaData, Protocol.SAML20, createAuthnResponse, handleAuthnRequest);
            this.class2ResumeRequestFromAuthnResponseHandlerMap.put(handleAuthnRequest.getClass().getName(), handleAuthnRequest);
            HandleLogoutRequest idpHandleLogoutRequest = new HandleLogoutRequest();
            this.class2ResumeRequestFromResponseHandlerMap.put(idpHandleLogoutRequest.getClass().getName(), idpHandleLogoutRequest);
            HandleLogoutResponse idpHandleLogoutResponse = new HandleLogoutResponse();
            this.setUpIdpInitSlo(idpHandleLogoutResponse, localMetaData);
            EndpointGroup singleSignOnServices = localMetaData.getSingleSignOnServices();
            for (Object endpoint : singleSignOnServices.getEndpoints()) {
                String location2 = ((Endpoint)endpoint).getFullLocation();
                this.requestHandlerMap.put(location2, handleAuthnRequest);
                this.pathToPartnerRoleMap.put(location2, currentPartnerRole);
                String resumeLocation = localMetaData.getPathUtil().convertToResumePath(location2, Protocol.SAML20.toString(), null);
                this.resumableRequestHandlersMap.put(resumeLocation, handleAuthnRequest);
            }
            EndpointGroup idpSingleLogoutServices = localMetaData.getIdpSingleLogoutServices();
            for (Object endpoint : idpSingleLogoutServices.getEndpoints()) {
                location = ((Endpoint)endpoint).getFullLocation();
                this.requestHandlerMap.put(location, idpHandleLogoutRequest);
                this.pathToPartnerRoleMap.put(location, currentPartnerRole);
                String resume = localMetaData.getPathUtil().convertToResumePath(location, idpHandleLogoutRequest.RESUME_PATH_QUALIFIER, null);
                this.resumableRequestHandlersMap.put(resume, idpHandleLogoutRequest);
                String responseLocation = ((Endpoint)endpoint).getResponseLocation();
                this.responseHandlersMap.put(responseLocation, idpHandleLogoutResponse);
                this.pathToPartnerRoleMap.put(responseLocation, currentPartnerRole);
                resume = localMetaData.getPathUtil().convertToResumePath(responseLocation, "/resp", null);
                this.resumableResponseHandlersMap.put(resume, idpHandleLogoutResponse);
            }
            IndexedEndpoints artifactResolutionServices = localMetaData.getIdpArtifactResolutionServices();
            for (Endpoint endpoint : artifactResolutionServices.getEndpointsMap().values()) {
                String location3 = endpoint.getFullLocation();
                this.requestHandlerMap.put(location3, handleArtifiactReq);
                this.pathToPartnerRoleMap.put(location3, currentPartnerRole);
            }
            HandleAttrQueryRequest handleAttrQueryRequest = new HandleAttrQueryRequest();
            location = localMetaData.getAttributeService();
            this.requestHandlerMap.put(location, handleAttrQueryRequest);
            this.pathToPartnerRoleMap.put(location, currentPartnerRole);
            IdpDiscovery idpDiscovery = localMetaData.getIdpDiscovery();
            if (idpDiscovery.isIdpCommonDomainClient() && localMetaData.getEnableIdpDiscovery()) {
                this.requestCreatorsMap.put(idpLocalPaths.getInitiateWriteCDC(), new WriteCDC());
            }
        }
    }

    private void setUpIdpInitSlo(HandleLogoutResponse idpHandleLogoutResponse, MetadataLocal localMetaData) {
        CreateLogoutRequest idpCreateLogoutRequest = new CreateLogoutRequest();
        IDPLocalPathMappings idpLocalPaths = localMetaData.getIdpLocalPathMappings();
        String idpInitSloPath = idpLocalPaths.getInitiateSLOPath();
        this.requestCreatorsMap.put(idpInitSloPath, idpCreateLogoutRequest);
        if (idpHandleLogoutResponse != null) {
            this.relatedResponseHandlersMap.put(idpInitSloPath, idpHandleLogoutResponse);
            this.class2ResumeRequestFromResponseHandlerMap.put(idpHandleLogoutResponse.getClass().getName(), idpHandleLogoutResponse);
        }
        String resumeIdpInitSloPath = localMetaData.getPathUtil().convertToResumePath(idpInitSloPath, null, null);
        this.resumableRequestCreatorsMap.put(resumeIdpInitSloPath, idpCreateLogoutRequest);
        this.class2ResumeRequestFromResponseHandlerMap.put(idpCreateLogoutRequest.getClass().getName(), idpCreateLogoutRequest);
    }

    public Role getPartnerRoleType(String identifier) throws NoSuchProcessException {
        return this.pathToPartnerRoleMap.checkedGet(identifier);
    }

    public RequestCreator getRequestCreator(String identifier) throws NoSuchProcessException {
        return this.requestCreatorsMap.checkedGet(identifier);
    }

    public ResponseCreator getResponseCreator(String identifier) throws NoSuchProcessException {
        return this.responseCreatorsMap.checkedGet(identifier);
    }

    public RequestHandler geRequestHandler(String identifier) throws NoSuchProcessException {
        return this.requestHandlerMap.checkedGet(identifier);
    }

    public ResumableRequestCreator getResumableRequestCreator(String identifier) throws NoSuchProcessException {
        return (ResumableRequestCreator)this.resumableRequestCreatorsMap.get(identifier);
    }

    public ResumableResponseHandler getResumableResponseHandler(String identifier) throws NoSuchProcessException {
        return (ResumableResponseHandler)this.resumableResponseHandlersMap.get(identifier);
    }

    public ResumableRequestHandler getResumableRequestHandler(String identifier) throws NoSuchProcessException {
        return this.resumableRequestHandlersMap.checkedGet(identifier);
    }

    public ResponseHandler getResponseHandler(String identifier) throws NoSuchProcessException {
        ResponseHandler handler = this.responseHandlersMap.containsKey(identifier) ? this.responseHandlersMap.checkedGet(identifier) : this.relatedResponseHandlersMap.checkedGet(identifier);
        return handler;
    }

    public BasicHttpRequestHandler getBasicHttpRequestHandler(String identifier) {
        return (BasicHttpRequestHandler)this.basicHttpRequestHandlerMap.get(identifier);
    }

    public boolean isRequestCreatorProcess(String identifier) {
        return this.requestCreatorsMap.containsKey(identifier);
    }

    public boolean isResponseCreatorProcess(String identifier) {
        return this.responseCreatorsMap.containsKey(identifier);
    }

    public boolean isResumeCreateRequestProcess(String identifier) {
        return this.resumableRequestCreatorsMap.containsKey(identifier);
    }

    public boolean isResumeHandleRequestProcess(String identifier) {
        return this.resumableRequestHandlersMap.containsKey(identifier);
    }

    public boolean isResumeHandleResponseProcess(String identifier) {
        return this.resumableResponseHandlersMap.containsKey(identifier);
    }

    public boolean isBasicHttpRequestHandler(String identifier) {
        return this.basicHttpRequestHandlerMap.containsKey(identifier);
    }

    public CreateSsoRequest getSsoRequestCreator() {
        return this.createSsoRequest;
    }

    public ResumeRequestFromAuthnResponseHandler getResumeRequestFromAuthnResponseHandler(String className) {
        ResumeRequestFromAuthnResponseHandler handler = this.class2ResumeRequestFromAuthnResponseHandlerMap.get(className);
        if (handler != null) {
            return handler;
        }
        return staticClass2ResumeRequestFromAuthnResponseHandlerMap.get(className);
    }

    public static void addStaticResumeRequestFromAuthnResponseHandler(ResumeRequestFromAuthnResponseHandler handler) {
        staticClass2ResumeRequestFromAuthnResponseHandlerMap.put(handler.getClass().getName(), handler);
    }

    public ResumeRequestFromResponseHandler getResumeFromResponseHandler(String className) {
        return this.class2ResumeRequestFromResponseHandlerMap.get(className);
    }

    private static class LightweightStandardsBasedMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;
        final String exMsgPrefix;
        final String name;

        LightweightStandardsBasedMap(String valueName) {
            this.name = valueName;
            this.exMsgPrefix = "No " + valueName + " found for: ";
        }

        V checkedGet(K s) throws NoSuchProcessException {
            Object value = super.get(s);
            if (value == null) {
                throw new NoSuchProcessException(this.exMsgPrefix + s);
            }
            return value;
        }

        @Override
        public String toString() {
            return this.name + ": " + super.toString();
        }
    }
}

