/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.profiles.ProfileProcessFactory;
import org.sourceid.saml20.profiles.ProfileProcessMgmtService;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.profiles.BasicHttpRequestHandler;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.profiles.RequestCreator;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.profiles.ResponseCreator;
import org.sourceid.websso.profiles.ResponseHandler;
import org.sourceid.websso.profiles.ResumableRequestCreator;
import org.sourceid.websso.profiles.ResumableRequestHandler;
import org.sourceid.websso.profiles.ResumableResponseHandler;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wsfed.profiles.idp.HandleWsFedRequest;

public class ProfileProcessManager
implements ProfileProcessMgmtService {
    private MetadataLocal localMetadata;

    public void setLocalMetadata(MetadataLocal localMetadata) {
        this.localMetadata = localMetadata;
    }

    @Override
    public OutMessageContext doCreateRequest(HttpServletRequest req, HttpServletResponse resp) throws NoSuchProcessException, IOException {
        RequestCreator requestCreator = this.getFactory().getRequestCreator(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(requestCreator, req, resp);
        return requestCreator.process(req, resp);
    }

    @Override
    public OutMessageContext doCreateResponse(HttpServletRequest req, HttpServletResponse resp) throws NoSuchProcessException, IOException {
        ResponseCreator responseCreator = this.getFactory().getResponseCreator(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(responseCreator, req, resp);
        return responseCreator.process(req, resp);
    }

    @Override
    public OutMessageContext doHandleRequest(InMessageContext msgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, NoSuchProcessException, HttpStatusCodeException {
        RequestHandler requestHandler = this.getFactory().geRequestHandler(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(requestHandler, req, resp);
        return requestHandler.process(msgCtx, req, resp);
    }

    @Override
    public OutMessageContext resumeCreateRequest(HttpServletRequest req, HttpServletResponse resp) throws NoSuchProcessException, IOException, RenderPageException {
        ResumableRequestCreator resumableRequestCreator = this.getFactory().getResumableRequestCreator(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(resumableRequestCreator, req, resp);
        return resumableRequestCreator.resume(req, resp);
    }

    @Override
    public OutMessageContext resumeHandleRequest(HttpServletRequest req, HttpServletResponse resp) throws NoSuchProcessException, IOException, RenderPageException {
        ResumableRequestHandler resumableReqHandler = this.getFactory().getResumableRequestHandler(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(resumableReqHandler, req, resp);
        return resumableReqHandler.resume(req, resp);
    }

    @Override
    public void resumeHandleResponse(HttpServletRequest req, HttpServletResponse resp) throws NoSuchProcessException, IOException, RenderPageException {
        ResumableResponseHandler resumableResponseHandler = this.getFactory().getResumableResponseHandler(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(resumableResponseHandler, req, resp);
        resumableResponseHandler.resume(req, resp);
    }

    @Override
    public void doHandleResponse(OutMessageContext requestMsgCtx, InMessageContext respMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, NoSuchProcessException, RenderPageException {
        ResponseHandler responseHandler = this.getFactory().getResponseHandler(this.getServletPathWithoutPathParams(req));
        this.checkPreProcessRequest(responseHandler, req, resp);
        responseHandler.process(requestMsgCtx, respMsgCtx, req, resp);
    }

    @Override
    public void doHandleBasicHttpRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, HttpStatusCodeException {
        BasicHttpRequestHandler httpRequestHandler = this.getFactory().getBasicHttpRequestHandler(req.getServletPath());
        this.checkPreProcessRequest(httpRequestHandler, req, resp);
        httpRequestHandler.process(req, resp);
    }

    @Override
    public boolean isRequestCreatorProcess(HttpServletRequest req) {
        return this.getFactory().isRequestCreatorProcess(this.getServletPathWithoutPathParams(req));
    }

    @Override
    public boolean isResponseCreatorProcess(HttpServletRequest req) {
        return this.getFactory().isResponseCreatorProcess(this.getServletPathWithoutPathParams(req));
    }

    @Override
    public boolean isResumeCreateRequestProcess(HttpServletRequest req) {
        return this.getFactory().isResumeCreateRequestProcess(this.getServletPathWithoutPathParams(req));
    }

    @Override
    public boolean isResumeHandleRequestProcess(HttpServletRequest req) {
        return this.getFactory().isResumeHandleRequestProcess(this.getServletPathWithoutPathParams(req));
    }

    @Override
    public boolean isResumeHandleResponseProcess(HttpServletRequest req) {
        return this.getFactory().isResumeHandleResponseProcess(this.getServletPathWithoutPathParams(req));
    }

    @Override
    public boolean isBasicHttpRequest(HttpServletRequest req) {
        return this.getFactory().isBasicHttpRequestHandler(req.getServletPath());
    }

    @Override
    public Role getType(HttpServletRequest req) throws NoSuchProcessException {
        ProfileProcessFactory factory = this.getFactory();
        return factory.getPartnerRoleType(this.getServletPathWithoutPathParams(req));
    }

    private ProfileProcessFactory getFactory() {
        return this.localMetadata.getProfileProcessFactory();
    }

    private String getServletPathWithoutPathParams(HttpServletRequest req) {
        PathUtil pathUtil = this.localMetadata.getPathUtil();
        return pathUtil.stripPathParams(req.getServletPath());
    }

    private void checkPreProcessRequest(Object handler, HttpServletRequest req, HttpServletResponse resp) {
        if (!(handler instanceof SloHandler) && !(handler instanceof HandleWsFedRequest)) {
            StateMgmtFactory.checkSessionRevoked(req, resp);
        }
    }
}

