/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ProfileProcessorMatrix {
    public static final int PROCESSOR_SP_CREATE_AUTHN_REQUEST = 0;
    public static final int PROCESSOR_SP_CREATE_LOGOUT_REQUEST = 1;
    public static final int PROCESSOR_SP_HANDLE_AUTHN_RESPONSE_IDP_INITIATED = 2;
    public static final int PROCESSOR_SP_HANDLE_LOGOUT_REQUEST = 3;
    public static final int PROCESSOR_IDP_CREATE_AUTHN_RESPONSE = 4;
    public static final int PROCESSOR_IDP_CREATE_LOGOUT_REQUEST = 5;
    public static final int PROCESSOR_IDP_HANDLE_AUTHN_REQUEST_FROM_SP = 6;
    public static final int PROCESSOR_IDP_HANDLE_LOGOUT_REQUEST = 7;
    public static final int TOTAL = 8;
    private boolean[] idpInitSSOProcessors = new boolean[8];
    private boolean[] spInitSSOProcessors = new boolean[8];
    private boolean[] idpInitSLOProcessors = new boolean[8];
    private boolean[] spInitSLOProcessors = new boolean[8];
    private static String[] processorNames = new String[8];
    private static String[] likelyProfile4Processor = new String[8];
    private static ProfileProcessorMatrix instance = new ProfileProcessorMatrix();
    private Log log = LogFactory.getLog(this.getClass());

    private ProfileProcessorMatrix() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.idpInitSSOProcessors[i] = false;
        }
        for (i = 0; i < 8; ++i) {
            this.spInitSSOProcessors[i] = false;
        }
        for (i = 0; i < 8; ++i) {
            this.idpInitSLOProcessors[i] = false;
        }
        for (i = 0; i < 8; ++i) {
            this.spInitSLOProcessors[i] = false;
        }
        this.idpInitSSOProcessors[2] = true;
        this.idpInitSSOProcessors[4] = true;
        this.spInitSSOProcessors[0] = true;
        this.spInitSSOProcessors[6] = true;
        this.idpInitSLOProcessors[3] = true;
        this.idpInitSLOProcessors[5] = true;
        this.spInitSLOProcessors[1] = true;
        this.spInitSLOProcessors[7] = true;
        ProfileProcessorMatrix.processorNames[0] = "SP.CreateAuthnRequest";
        ProfileProcessorMatrix.processorNames[1] = "SP.CreateLogoutRequest";
        ProfileProcessorMatrix.processorNames[2] = "SP.HandleAuthnResponse";
        ProfileProcessorMatrix.processorNames[3] = "SP.HandleLogoutRequest";
        ProfileProcessorMatrix.processorNames[4] = "IDP.CreateAuthnResponse";
        ProfileProcessorMatrix.processorNames[5] = "IDP.CreateLogoutRequest";
        ProfileProcessorMatrix.processorNames[6] = "IDP.HandleAuthnRequest";
        ProfileProcessorMatrix.processorNames[7] = "IDP.HandleLogoutRequest";
        ProfileProcessorMatrix.likelyProfile4Processor[0] = "SP-initiated SSO";
        ProfileProcessorMatrix.likelyProfile4Processor[1] = "SP-initiated SLO";
        ProfileProcessorMatrix.likelyProfile4Processor[2] = "IDP-initiated SSO";
        ProfileProcessorMatrix.likelyProfile4Processor[3] = "IDP-initiated SLO";
        ProfileProcessorMatrix.likelyProfile4Processor[4] = "IDP-initiated SSO";
        ProfileProcessorMatrix.likelyProfile4Processor[5] = "IDP-initiated SLO";
        ProfileProcessorMatrix.likelyProfile4Processor[6] = "SP-initiated SSO";
        ProfileProcessorMatrix.likelyProfile4Processor[7] = "SP-initiated SLO";
    }

    public static ProfileProcessorMatrix getInstance() {
        return instance;
    }

    public void verifyProcessorEnablement(int processor, EnabledProfiles profiles) {
        if (!(profiles.isIdpInitiatedSSOEnabled() && this.idpInitSSOProcessors[processor] || profiles.isSpInitiatedSSOEnabled() && this.spInitSSOProcessors[processor] || profiles.isIdpInitiatedSLOEnabled() && this.idpInitSLOProcessors[processor] || profiles.isSpInitiatedSLOEnabled() && this.spInitSLOProcessors[processor])) {
            this.log.debug((Object)("Access to " + processorNames[processor] + " is disabled due to profile restriction for the connection. Enabled profiles for the connection are " + profiles));
            String msg = likelyProfile4Processor[processor] + " is not enabled.";
            throw new ProcessRuntimeException(msg);
        }
    }
}

