/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.StatusResponseTypeUtil;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandler;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public abstract class ResumableRequestHandlerBase
extends org.sourceid.websso.profiles.ResumableRequestHandlerBase
implements ResumableRequestHandler {
    protected abstract void doResume(InMessageContext var1, HttpServletRequest var2, HttpServletResponse var3, OutMessageContext var4, Map<String, Object> var5) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException;

    @Override
    protected void doProcess(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        if (!inMsgCtx.isUnsolicitedResponse()) {
            this.validateXml(inMsgCtx);
            this.verifySignature(inMsgCtx);
        }
        this.handle(inMsgCtx, req, resp, outMsgCtx);
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
        XmlObject doc = outMsgCtx.getXmlObject();
        XmlObject type = XmlBeansUtil.unwrapDocumentToType(doc);
        StatusResponseType statusResponseType = (StatusResponseType)type;
        statusResponseType.setIssueInstant(Util.getUtcCalendar());
        this.doResume(inMsgCtx, req, resp, outMsgCtx, otherState);
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StatusResponseException statusRespEx = e instanceof StatusResponseException ? (StatusResponseException)e : new StatusResponseException(TopLevelStatusCode.RESPONDER, e.getMessage(), e);
        String virtualServerId = VirtualIdentityUtil.resolve(inMsgCtx).getVirtualEntityId(DomainMode.RUNTIME);
        StatusResponseTypeUtil.writeStatus(statusRespEx, inMsgCtx.getXmlObject(), outMsgCtx.getXmlObject(), virtualServerId);
    }

    protected void verifySignature(InMessageContext inMsgCtx) throws StatusResponseException {
        SignatureStatus signatureStatus = inMsgCtx.getSignatureStatus();
        if (signatureStatus == SignatureStatus.NOT_PRESENT) {
            if (inMsgCtx.isSignatureRequired()) {
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "Signature required");
            }
        } else {
            if (signatureStatus == SignatureStatus.INVALID) {
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "Invalid signature");
            }
            if (signatureStatus == SignatureStatus.UNVERIFIED) {
                if (inMsgCtx.isSignatureRequired()) {
                    this.log.error((Object)"Unable to verify the signature. Please make sure that verification certificates are properly configured and not expired.");
                    throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "Unable to verify the signature");
                }
            } else if (signatureStatus != SignatureStatus.VALID) {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "Unknown or unexpected signature status : " + signatureStatus);
            }
        }
    }

    protected void validateXml(InMessageContext inMsgCtx) throws StatusResponseException {
        try {
            XmlBeansUtil.validate(inMsgCtx.getXmlObject());
        }
        catch (InvalidXmlException e) {
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "Request was invalid XML", e);
        }
    }
}

