/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.PartnerSessionGroup;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.protocol.SingleLogoutUtil;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.util.NameIdHashKey;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.LogoutProcessor;
import org.sourceid.websso.wrapper.OutMessageContext;

public class Saml2LogoutProcessor
implements LogoutProcessor {
    private SLOSupport sloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());

    @Override
    public Collection<IdpConnHashableAuthnBean> gatherBeansForLogoutRequest(Collection<IdpConnHashableAuthnBean> beans, String initiatorEntityId, Predicate<IdpConnection> filter) {
        NameIdHashKey initialNameIdKey = null;
        ArrayList<IdpConnHashableAuthnBean> result = new ArrayList<IdpConnHashableAuthnBean>();
        for (IdpConnHashableAuthnBean idpConnBean : this.gatherProtocolBeans(beans)) {
            IdpConnection idpConn;
            if (!idpConnBean.isDoLogout() || !(idpConn = this.getIdpConnection(idpConnBean)).getEnabledProfiles().isSpInitiatedSLOEnabled() || !filter.test(idpConn) || initiatorEntityId != null && idpConn.getEntityId().equals(initiatorEntityId)) continue;
            NameIdHashKey nameIdKey = new NameIdHashKey(idpConn.getEntityId(), idpConnBean.getNameId());
            if (initialNameIdKey == null) {
                result.add(idpConnBean);
                initialNameIdKey = nameIdKey;
                continue;
            }
            if (!nameIdKey.equals(initialNameIdKey)) continue;
            result.add(idpConnBean);
        }
        return result;
    }

    @Override
    public OutMessageContext createLogoutRequest(Collection<IdpConnHashableAuthnBean> beans, String binding, HttpServletRequest req) {
        if (beans.isEmpty()) {
            throw new IllegalArgumentException("No beans provided");
        }
        PartnerSessionGroup sessionGroup = this.makePartnerSessionGroup(beans);
        OutMessageContext outMsgCtx = SingleLogoutUtil.createLogoutRequestMsgCtx(req, sessionGroup, false, binding);
        this.sloSupport.securityAuditLog(sessionGroup, Protocol.SAML20, outMsgCtx);
        return outMsgCtx;
    }

    @Override
    public void invalidateBeans(Collection<IdpConnHashableAuthnBean> beans) {
        IdpSessionRegistrySupport.setBeansInvalidForLogout(new ArrayList<IdpHashableAuthnBean>(beans));
    }

    public PartnerSessionGroup makePartnerSessionGroup(Collection<IdpConnHashableAuthnBean> beans) {
        Iterator<IdpConnHashableAuthnBean> iter = beans.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        IdpConnHashableAuthnBean first = iter.next();
        PartnerSessionGroup sessionGroup = new PartnerSessionGroup(first.getEntityId(), first.getVirtualServerId(), first.getNameId(), false);
        sessionGroup.addSessionIndex(first.getSessionIndex());
        while (iter.hasNext()) {
            sessionGroup.addSessionIndex(iter.next().getSessionIndex());
        }
        return sessionGroup;
    }

    protected Collection<IdpConnHashableAuthnBean> gatherProtocolBeans(Collection<IdpConnHashableAuthnBean> beans) {
        ArrayList<IdpConnHashableAuthnBean> result = new ArrayList<IdpConnHashableAuthnBean>();
        for (IdpConnHashableAuthnBean idpConnBean : beans) {
            IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
            if (idpConn == null || idpConn.getProtocol() != Protocol.SAML20) continue;
            result.add(idpConnBean);
        }
        return result;
    }

    private IdpConnection getIdpConnection(IdpConnHashableAuthnBean idpConnBean) {
        return MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), true);
    }
}

