/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.util.Collections;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class SloConfirmationPrompt {
    private static final String KEY_CSRF_TOKEN = "sloCsrfToken";
    private static final String PARAM_CSRF_TOKEN = "csrfToken";
    private static final String PARAM_CONSENT_GIVEN = "consentGiven";
    private static final String VAR_CSRF_TOKEN = "csrfToken";
    private static final String VAR_ACTION = "action";
    private static final String VAR_CANCELLED = "cancelled";
    private static final String VAR_POST_PARAMS = "postParams";
    private static final String CONFIRM_TEMPLATE = "idp.slo.confirm.page.template.html";
    private MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public boolean checkDisplayConfirmationPrompt(HttpServletRequest req, HttpServletResponse resp, boolean forceDisplayPrompt, Supplier<String> saveStateSupplier) throws ResponseTemplateRendererException {
        boolean result = false;
        if (forceDisplayPrompt || this.metadataLocal.isConfirmSlo()) {
            HashMap<String, Object> templateVars = new HashMap<String, Object>();
            SessionStateSupport stateSupport = new SessionStateSupport();
            String prevToken = (String)stateSupport.getAttribute(KEY_CSRF_TOKEN, req, resp);
            String incomingToken = req.getParameter("csrfToken");
            if (incomingToken == null || !incomingToken.equals(prevToken)) {
                String newToken = this.getNewCsrfToken(req, resp);
                String resumePath = saveStateSupplier.get();
                templateVars.put("csrfToken", newToken);
                templateVars.put(VAR_ACTION, resumePath);
                templateVars.put(VAR_CANCELLED, false);
                templateVars.put(VAR_POST_PARAMS, Collections.emptyMap());
                result = true;
            } else {
                stateSupport.removeAttribute(KEY_CSRF_TOKEN, req, resp);
                String consentGiven = req.getParameter(PARAM_CONSENT_GIVEN);
                if ("true".equals(consentGiven)) {
                    result = false;
                } else {
                    templateVars.put(VAR_CANCELLED, true);
                    result = true;
                }
            }
            if (result) {
                ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
                renderer.render(req, resp, CONFIRM_TEMPLATE, templateVars);
            }
        }
        return result;
    }

    public String getNewCsrfToken(HttpServletRequest req, HttpServletResponse resp) {
        SessionStateSupport stateSupport = new SessionStateSupport();
        String newToken = IDGenerator.rndAlphaNumeric(20);
        stateSupport.setAttribute(KEY_CSRF_TOKEN, (Object)newToken, req, resp, false);
        return newToken;
    }
}

