/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.openid.connect.OidcLogoutSupport;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.PartnerLogoutManager;
import org.sourceid.saml20.profiles.PartnerSessionGroup;
import org.sourceid.saml20.profiles.idp.HandleLogoutResponse;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.protocol.SingleLogoutUtil;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.OidcSession;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestType;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.LogoutResult;
import org.sourceid.websso.profiles.LogoutResultHandler;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class SpPartnerLogoutManager
implements PartnerLogoutManager {
    private static final Log log = LogFactory.getLog(SpPartnerLogoutManager.class);
    private static final String KEY_PARTNER_LOGOUT_STATE = "SpPartnerLogoutState";
    private BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
    private PartnerLogoutState logoutState;
    private Map<String, Object> params;
    private SLOSupport sloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());
    private OidcLogoutSupport oidcLogoutSupport = new OidcLogoutSupport();

    public SpPartnerLogoutManager(Collection<IdpHashableAuthnBean> beans, boolean overallResult, List<String> problems, Map<String, Object> params) {
        this.logoutState = new PartnerLogoutState(beans, overallResult, problems);
        this.params = params;
        params.put(KEY_PARTNER_LOGOUT_STATE, this.logoutState);
    }

    public SpPartnerLogoutManager(Map<String, Object> params) {
        this.params = params;
        this.logoutState = (PartnerLogoutState)params.get(KEY_PARTNER_LOGOUT_STATE);
    }

    @Override
    public boolean doLogout(boolean requestIsBackchannel, String binding, String initiatorEntityId, Class<? extends ResumeRequestFromResponseHandler> handlerClass, InMessageContext origInMsgCtx, OutMessageContext origOutMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        boolean done = false;
        boolean requestSent = false;
        while (!done && !requestSent) {
            PartnerSessionGroup sessionGroup;
            Map<IdpHashableAuthnBean, Collection<Session>> beansAndSessions = IdpSessionRegistrySupport.getIssuedSessions(this.logoutState.getBeans());
            this.checkDoOidcBackchannelLogouts(beansAndSessions, requestIsBackchannel);
            Collection<Session> issuedSessions = this.gatherSessions(beansAndSessions);
            List<WebSsoSession> remainingSessions = this.sloSupport.getRemainingSaml2Sessions(issuedSessions, initiatorEntityId);
            Collection<PartnerSessionGroup> groupedRemainingSessions = SingleLogoutUtil.groupAndFilterSessions(remainingSessions);
            if (requestIsBackchannel) {
                sessionGroup = this.removeNextSessionGroup(groupedRemainingSessions, spConn -> spConn.supportsBackChannelSingleLogout());
            } else {
                sessionGroup = this.removeNextSessionGroup(groupedRemainingSessions, spConn -> this.bindingSvc.isBackChannelBinding(spConn.getPreferredSingleLogoutService().getBinding()));
                if (sessionGroup == null) {
                    sessionGroup = this.removeNextSessionGroup(groupedRemainingSessions, spConn -> true);
                }
            }
            if (sessionGroup == null) {
                done = true;
                if (groupedRemainingSessions.isEmpty()) continue;
                String problem = "Not all partner sessions could be terminated using back-channel logout";
                this.logoutState.addProblem(problem);
                this.logoutState.setOverallResult(false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)problem);
                continue;
            }
            IdpSessionRegistrySupport.unregisterSessions(sessionGroup.getSessionIndices());
            try {
                OutMessageContext outMsgCtx = SingleLogoutUtil.createLogoutRequestMsgCtx(req, sessionGroup, true, binding);
                if (requestIsBackchannel) {
                    this.setBackchannelBinding(outMsgCtx, sessionGroup.getEntityId());
                }
                this.securityAuditLog(sessionGroup, outMsgCtx);
                State originalState = new State();
                originalState.setInMsgCtx(origInMsgCtx);
                originalState.setOutMsgCtx(origOutMsgCtx);
                originalState.setParameters(this.params);
                ResumeRequestFromResponseSupport.registerResumeFromResponseHandler(outMsgCtx, handlerClass, req, originalState);
                InMessageContext inMsgCtx = this.transportRequest(outMsgCtx, req, resp);
                if (inMsgCtx != null) {
                    this.handleBackchannelResponse(inMsgCtx, outMsgCtx, req, resp);
                    continue;
                }
                requestSent = true;
            }
            catch (Exception e) {
                String problem = "Unexpected problem sending logout request: " + e.getMessage();
                this.logoutState.addProblem(problem);
                this.logoutState.setOverallResult(false);
                log.error((Object)problem, (Throwable)e);
            }
        }
        return !requestSent;
    }

    @Override
    public boolean getOverallResult() {
        return this.logoutState.getOverallResult();
    }

    @Override
    public List<String> getProblems() {
        return this.logoutState.getProblems();
    }

    @Override
    public void handleLogoutResult(LogoutResult logoutResult) {
        this.logoutState.setOverallResult(this.logoutState.getOverallResult() && logoutResult.isSuccess());
        if (!logoutResult.isSuccess()) {
            this.logoutState.addProblem(logoutResult.getErrorDescription());
        }
    }

    protected PartnerSessionGroup removeNextSessionGroup(Collection<PartnerSessionGroup> sessionGroups, Predicate<SpConnection> filter) {
        Iterator<PartnerSessionGroup> iter = sessionGroups.iterator();
        while (iter.hasNext()) {
            PartnerSessionGroup sessionGroup = iter.next();
            String spEntityId = sessionGroup.getEntityId();
            SpConnection spConn = MetadataSupport.getSpConnection(spEntityId);
            if (!filter.test(spConn)) continue;
            iter.remove();
            return sessionGroup;
        }
        return null;
    }

    protected void handleBackchannelResponse(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        LogoutResultHandler logoutResultHandler = new LogoutResultHandler(){

            @Override
            public void handleLogoutResult(LogoutResult result) {
                SpPartnerLogoutManager.this.handleLogoutResult(result);
            }
        };
        HandleLogoutResponse responseHandler = new HandleLogoutResponse();
        responseHandler.setResultHandler(logoutResultHandler);
        responseHandler.process(reqMsgCtx, respMsgCtx, req, resp);
    }

    protected void setBackchannelBinding(OutMessageContext outMsgCtx, String partnerEntityId) {
        SpConnection spConn = MgmtFactory.getMetadataDirectory().getSpConnection(partnerEntityId, true);
        Endpoint sloServiceEndpoint = spConn.getPreferredSingleLogoutService(true);
        outMsgCtx.setEndpoint(sloServiceEndpoint.getFullLocation());
        outMsgCtx.setBinding(sloServiceEndpoint.getBinding());
    }

    protected void checkDoOidcBackchannelLogouts(Map<IdpHashableAuthnBean, Collection<Session>> beansAndSessions, boolean requestIsBackChannel) {
        if (this.logoutState.isOidcBackchannelLogoutsComplete()) {
            return;
        }
        this.logoutState.setOidcBackchannelLogoutsComplete(true);
        boolean result = this.doOidcBackChannelLogouts(beansAndSessions, requestIsBackChannel);
        if (!result) {
            this.logoutState.setOverallResult(false);
            this.logoutState.addProblem("Error occurred while sending OIDC back-channel logout requests.");
        }
    }

    protected boolean doOidcBackChannelLogouts(Map<IdpHashableAuthnBean, Collection<Session>> beansAndSessions, boolean requestIsBackChannel) {
        boolean result = true;
        HashSet<OidcSession> sessionsToLogout = new HashSet<OidcSession>();
        for (Map.Entry<IdpHashableAuthnBean, Collection<Session>> entry : beansAndSessions.entrySet()) {
            Collection<OidcSession> eligibleSessions = this.gatherEligibleOidcSessions(entry.getKey(), entry.getValue(), requestIsBackChannel);
            sessionsToLogout.addAll(eligibleSessions);
            IdpSessionRegistrySupport.unregisterSessions(entry.getKey(), eligibleSessions);
        }
        for (OidcSession oidcSession : sessionsToLogout) {
            Client client = MgmtFactory.getClientManager().getCachedClient(oidcSession.getClientId());
            if (client == null) continue;
            boolean requestResult = this.sendOidcLogoutRequest(client, oidcSession);
            this.securityAuditLog(oidcSession, requestResult);
            result = result && requestResult;
        }
        return result;
    }

    protected boolean sendOidcLogoutRequest(Client client, OidcSession oidcSession) {
        return this.oidcLogoutSupport.sendLogoutRequest(client, oidcSession);
    }

    private Collection<OidcSession> gatherEligibleOidcSessions(IdpHashableAuthnBean bean, Collection<Session> sessions, boolean requestIsBackChannel) {
        ArrayList<OidcSession> result = new ArrayList<OidcSession>();
        ArrayList<OidcSession> toUnregister = new ArrayList<OidcSession>();
        for (Session session : sessions) {
            if (!(session instanceof OidcSession)) continue;
            OidcSession oidcSession = (OidcSession)session;
            Client client = MgmtFactory.getClientManager().getCachedClient(oidcSession.getClientId());
            if (client == null) {
                toUnregister.add(oidcSession);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping registered OIDC session as client " + oidcSession.getClientId() + " no longer exists"));
                continue;
            }
            if ((!requestIsBackChannel || client.getBackChannelLogoutUri() == null) && client.getLogoutMode() != ClientLogoutMode.OIDC_BACK_CHANNEL) continue;
            result.add(oidcSession);
        }
        IdpSessionRegistrySupport.unregisterSessions(bean, toUnregister);
        return result;
    }

    private void securityAuditLog(PartnerSessionGroup sessionGroup, OutMessageContext outMsgCtx) {
        LogoutRequestType requestType;
        IdpAuditLogger.setEvent("SLO");
        IdpAuditLogger.setProtocol(Protocol.SAML20.toString());
        if (sessionGroup.isMaskNameId()) {
            IdpAuditLogger.setUserName("*****");
        } else {
            IdpAuditLogger.setUserName(sessionGroup.getNameId());
        }
        IdpAuditLogger.setPartnerId(sessionGroup.getEntityId());
        IdpAuditLogger.setVirtualServerId(sessionGroup.getVirtualServerId());
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
        ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(outMsgCtx).toString());
        LogoutRequestDocument requestDoc = (LogoutRequestDocument)outMsgCtx.getXmlObject();
        if (requestDoc != null && (requestType = requestDoc.getLogoutRequest()) != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.REQUEST_ID.toString(), (String)requestType.getID());
        }
        IdpAuditLogger.log("IdP initiated logout ...");
    }

    private void securityAuditLog(OidcSession session, boolean success) {
        String origStatus = AsAuditLogger.getStatus();
        AsAuditLogger.setProtocol(Protocol.OIDC.name());
        AsAuditLogger.setEvent("SLO");
        if (session.getOAuthIssuerId() != null) {
            OAuthIssuerUtils.getInstance().setAuditLogVirtualServerId(session.getOAuthIssuerId());
        }
        AsAuditLogger.setPartnerId(session.getClientId());
        AsAuditLogger.setUserName(session.getUserNameForLog());
        AsAuditLogger.setExtendedSri(new ExtendedSri(session.getExtendedSri()));
        AsAuditLogger.setStatus(success ? "success" : "failure");
        AsAuditLogger.log(success ? "logout" : "logout error");
        AsAuditLogger.clearRequestJti();
        AsAuditLogger.clearVirtualServerId();
        AsAuditLogger.clearPartnerId();
        AsAuditLogger.clearUserName();
        AsAuditLogger.clearExtendedSri();
        if (origStatus != null) {
            AsAuditLogger.setStatus(origStatus);
        } else {
            AsAuditLogger.clearStatus();
        }
    }

    protected InMessageContext transportRequest(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, BindingException, RedirectException, RenderPageException, NoSuchProcessException, HttpStatusCodeException {
        return this.bindingSvc.transportRequest(req, resp, outMsgCtx);
    }

    private Collection<Session> gatherSessions(Map<IdpHashableAuthnBean, Collection<Session>> beansAndSessions) {
        LinkedHashSet<Session> result = new LinkedHashSet<Session>();
        beansAndSessions.values().forEach(sessions -> result.addAll((Collection<Session>)sessions));
        return result;
    }

    private static class PartnerLogoutState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean oidcBackchannelLogoutsComplete = false;
        private Collection<IdpHashableAuthnBean> beans;
        private boolean overallResult;
        private List<String> problems = new ArrayList<String>();

        public PartnerLogoutState(Collection<IdpHashableAuthnBean> beans, boolean overallResult, List<String> problems) {
            this.beans = beans;
            this.overallResult = overallResult;
            if (problems != null) {
                this.problems = new ArrayList<String>(problems);
            }
        }

        public Collection<IdpHashableAuthnBean> getBeans() {
            return this.beans;
        }

        public boolean getOverallResult() {
            return this.overallResult;
        }

        public void setOverallResult(boolean result) {
            this.overallResult = result;
        }

        public List<String> getProblems() {
            return this.problems;
        }

        public void addProblem(String problem) {
            this.problems.add(problem);
        }

        public boolean isOidcBackchannelLogoutsComplete() {
            return this.oidcBackchannelLogoutsComplete;
        }

        public void setOidcBackchannelLogoutsComplete(boolean oidcBackchannelLogoutsComplete) {
            this.oidcBackchannelLogoutsComplete = oidcBackchannelLogoutsComplete;
        }
    }
}

