/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.GoodTreeVisitor;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class AuthnTreeHelper {
    private static final Log log = LogFactory.getLog(AuthnTreeHelper.class);

    public static List<AuthnSelectionTree> copyApplicableAuthnTree(Set<AuthnSourceKey> acceptableAuthnMappings, Set<String> acceptableApcs, ProxyScoping proxyScoping) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Beginning copy/prune of authn policy trees");
        }
        AuthnSelectionConfigManager authnSelectionMgr = MgmtFactory.getAuthnSelectionConfigManager();
        List<AuthnSelectionTree> allTrees = authnSelectionMgr.getAuthnSelectionTrees();
        LinkedList<AuthnSelectionTree> prunedTrees = new LinkedList<AuthnSelectionTree>();
        HashSet<Tree.Node<AuthnSelectionAction>> acceptableNodes = new HashSet<Tree.Node<AuthnSelectionAction>>();
        if (acceptableAuthnMappings != null) {
            for (AuthnSourceKey key : acceptableAuthnMappings) {
                List<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = authnSelectionMgr.getAuthnSelectionAuthnSourcePaths(key);
                AuthnTreeHelper.addAcceptableNodes(paths, proxyScoping, acceptableNodes);
            }
        }
        if (acceptableApcs != null) {
            for (String apcId : acceptableApcs) {
                List<LinkedList<Tree.Node<AuthnSelectionAction>>> apcPaths = authnSelectionMgr.getAuthnSelectionApcPaths(apcId);
                AuthnTreeHelper.addAcceptableNodes(apcPaths, proxyScoping, acceptableNodes);
                List<LinkedList<Tree.Node<AuthnSelectionAction>>> fragmentPaths = authnSelectionMgr.getAuthnSelectionTerminatingFragmentPaths(apcId);
                AuthnTreeHelper.addAcceptableNodes(fragmentPaths, proxyScoping, acceptableNodes);
            }
        }
        for (AuthnSelectionTree fullTree : allTrees) {
            Tree.Node<AuthnSelectionAction> copiedRootNode;
            List<LinkedList<Tree.Node<AuthnSelectionAction>>> pathsEndingWithAuthnSelectors;
            boolean bl;
            List<LinkedList<Tree.Node<AuthnSelectionAction>>> restartPaths;
            boolean hasRestart;
            boolean hasContinue;
            if (fullTree.isDisabled()) {
                log.debug((Object)("Policy '" + fullTree.getName() + "' is disabled. Ignoring this tree for inclusion."));
                continue;
            }
            List<LinkedList<Tree.Node<AuthnSelectionAction>>> continuePaths = authnSelectionMgr.getAuthnSelectionContinuePaths(fullTree);
            boolean bl2 = hasContinue = continuePaths != null;
            if (hasContinue) {
                for (LinkedList<Tree.Node<AuthnSelectionAction>> path : continuePaths) {
                    for (Tree.Node node : path) {
                        acceptableNodes.add((Tree.Node<AuthnSelectionAction>)node);
                    }
                }
            }
            boolean bl3 = hasRestart = (restartPaths = authnSelectionMgr.getAuthnSelectionRestartPaths(fullTree)) != null;
            if (hasRestart) {
                for (LinkedList linkedList : restartPaths) {
                    acceptableNodes.addAll(linkedList);
                }
            }
            boolean bl4 = bl = (pathsEndingWithAuthnSelectors = authnSelectionMgr.getAuthnSelectionDonePathsEndingWithAuthnSelectors(fullTree)) != null;
            if (bl) {
                for (LinkedList<Tree.Node<AuthnSelectionAction>> path : pathsEndingWithAuthnSelectors) {
                    acceptableNodes.addAll(path);
                }
            }
            if ((copiedRootNode = AuthnTreeHelper.copyAndPruneNode((Tree.Node<AuthnSelectionAction>)fullTree.getRootNode(), acceptableNodes)) != null) {
                AuthnSelectionTree copiedTree = new AuthnSelectionTree(copiedRootNode);
                copiedTree.setId(fullTree.getId());
                copiedTree.setName(fullTree.getName());
                copiedTree.setDescription(fullTree.getDescription());
                copiedTree.setOverrideAuthnApiApplicationId(fullTree.getOverrideAuthnApiApplicationId());
                copiedTree.setHandleFailuresLocally(fullTree.isHandleFailuresLocally());
                PreOrderTraversal traversal = new PreOrderTraversal();
                GoodTreeVisitor visitor = new GoodTreeVisitor();
                traversal.traverse((Tree)copiedTree, (TraversalVisitor)visitor);
                if (visitor.isGoodTree()) {
                    prunedTrees.add(copiedTree);
                    log.debug((Object)("Policy '" + fullTree.getName() + "' is applicable to the request."));
                    continue;
                }
            }
            log.debug((Object)("Policy '" + fullTree.getName() + "' is inapplicable to the request, skipping..."));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Completed copy/prune of authn policy trees");
        }
        return prunedTrees;
    }

    private static void addAcceptableNodes(List<LinkedList<Tree.Node<AuthnSelectionAction>>> paths, ProxyScoping proxyScoping, Set<Tree.Node<AuthnSelectionAction>> acceptableNodes) {
        if (paths != null) {
            for (LinkedList<Tree.Node<AuthnSelectionAction>> path : paths) {
                if (!AuthnTreeHelper.isPathAcceptable(path, proxyScoping)) continue;
                for (Tree.Node node : path) {
                    acceptableNodes.add((Tree.Node<AuthnSelectionAction>)node);
                }
            }
        }
    }

    private static boolean isPathAcceptable(LinkedList<Tree.Node<AuthnSelectionAction>> path, ProxyScoping proxyScoping) {
        if (proxyScoping == null) {
            return true;
        }
        if (proxyScoping.hasIdpSet()) {
            Set<String> idpSet = proxyScoping.getIdpSet();
            for (Tree.Node node : path) {
                AuthnSourceAction asAction;
                AuthnSourceKey key;
                if (!(node.getData() instanceof AuthnSourceAction) || (key = (asAction = (AuthnSourceAction)node.getData()).getAuthnSourceKey()).getType() != AuthnSourceKey.AuthnSourceType.IDP_CONN || idpSet.contains(key.getFriendlyId())) continue;
                return false;
            }
        }
        return true;
    }

    private static Tree.Node<AuthnSelectionAction> copyAndPruneNode(Tree.Node<AuthnSelectionAction> origNode, Set<Tree.Node<AuthnSelectionAction>> acceptableNodes) {
        if (!acceptableNodes.contains(origNode)) {
            return null;
        }
        Tree.Node copiedNode = new Tree.Node((Object)((AuthnSelectionAction)origNode.getData()));
        if (origNode.hasChildren()) {
            for (Tree.Node origChildNode : origNode.getChildren()) {
                Tree.Node<AuthnSelectionAction> copiedChildNode = AuthnTreeHelper.copyAndPruneNode((Tree.Node<AuthnSelectionAction>)origChildNode, acceptableNodes);
                if (copiedChildNode == null) continue;
                copiedNode.addChildNode(copiedChildNode);
            }
        }
        return copiedNode;
    }
}

