/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.locale.LocaleUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.profiles.AdapterLogoutMode;
import org.sourceid.saml20.profiles.PartnerLogoutManager;
import org.sourceid.saml20.profiles.SloConfirmationPrompt;
import org.sourceid.saml20.profiles.SpPartnerLogoutManager;
import org.sourceid.saml20.profiles.idp.IdpAdapterLogoutManager;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.profiles.idp.StartSloResponse;
import org.sourceid.saml20.profiles.sp.SpAdapterLogoutManager;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.IdpPartnerLogoutManager;
import org.sourceid.websso.profiles.LogoutResult;
import org.sourceid.websso.profiles.ProtocolResponseObject;
import org.sourceid.websso.profiles.ResumableRequestCreatorBase;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.idp.BaseSloTemplateRenderer;
import org.sourceid.websso.profiles.idp.InvisibleSloTemplateRenderer;
import org.sourceid.websso.profiles.idp.SloTemplateRenderer;
import org.sourceid.websso.profiles.sp.SloSupport;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateLogoutRequest
extends ResumableRequestCreatorBase
implements SloHandler {
    private static final String KEY_PROCESSING_STAGE = "processingStage";
    private static final String KEY_START_SLO_REQUEST = "startSloRequest";
    private static final String KEY_IDP_BEANS = "beans";
    private static final String KEY_IDP_ADAPTER_BEANS = "idpAdapterBeans";
    private static final String KEY_IDP_CONN_BEANS = "idpConnBeans";
    private static final String KEY_OIDC_IDP_CONN_BEANS = "oidcIdpConnBeans";
    private static final String KEY_SP_BEANS = "spBeans";
    private static final String KEY_SUCCESS = "suc";
    private static final String KEY_BINDING = "binding";
    private static final String KEY_PROBLEMS = "problems";
    private static MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final SLOSupport sloSupport = new SLOSupport(localMetaData);
    private static TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.addTrackedParams(req, params);
        StartSloRequest startSloRequest = this.sloSupport.getStartSloRequest(req, resp);
        if (startSloRequest != null) {
            if (startSloRequest.getUiLocales() != null) {
                req = LocaleUtil.createLocaleWrappedRequest(req, startSloRequest.getUiLocales());
            }
            params.put(KEY_START_SLO_REQUEST, startSloRequest);
        }
        params.put(KEY_PROCESSING_STAGE, (Object)ProcessingStage.INITIAL_CLEANUP);
        params.put(KEY_BINDING, this.getBinding(req, params));
        String targetResource = this.getTargetResource(req, params);
        String inErrorResource = this.getInErrorResource(req, params);
        OutMessageContext initialCtx = new OutMessageContext(Role.SP);
        initialCtx.setTargetResource(targetResource);
        initialCtx.setInErrorResource(inErrorResource);
        if (!this.determineLogoutType(initialCtx, req, resp, params)) {
            return null;
        }
        this.resume(initialCtx, req, resp, params);
        return initialCtx;
    }

    @Override
    protected OutMessageContext doResume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, AuthnAdapterException {
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null && startSloRequest.getUiLocales() != null && !(req instanceof LocaleUtil.LocaleOverrideHttpServletRequest) && !(req instanceof LocaleUtil.LocaleOverrideAuthnApiRequest)) {
            req = LocaleUtil.createLocaleWrappedRequest(req, startSloRequest.getUiLocales());
        }
        boolean suspend = false;
        boolean isFirstIdpAdapter = false;
        boolean isFirstSpAdapter = false;
        while (!suspend) {
            switch (this.getStage(params)) {
                case INITIAL_CLEANUP: {
                    if (this.doInitialCleanup(reqMsgCtx, req, resp, params)) {
                        this.setStage(params, ProcessingStage.LOGGING_OUT_IDP_ADAPTERS);
                        isFirstIdpAdapter = true;
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_IDP_ADAPTERS: {
                    if (this.logoutIdpAdapters(reqMsgCtx, req, resp, params, isFirstIdpAdapter)) {
                        this.setStage(params, ProcessingStage.LOGGING_OUT_IDP_PARTNERS);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_IDP_PARTNERS: {
                    if (this.logoutIdpPartners(reqMsgCtx, req, resp, params)) {
                        this.setStage(params, ProcessingStage.LOGGING_OUT_SP_ADAPTERS);
                        isFirstSpAdapter = true;
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_SP_ADAPTERS: {
                    if (this.logoutSpAdapters(reqMsgCtx, req, resp, params, isFirstSpAdapter)) {
                        this.setStage(params, ProcessingStage.LOGGING_OUT_SP_PARTNERS);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_SP_PARTNERS: {
                    if (this.logoutSpPartners(reqMsgCtx, req, resp, params)) {
                        this.setStage(params, ProcessingStage.LOGGING_OUT_OIDC_IDP_PARTNERS);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_OIDC_IDP_PARTNERS: {
                    if (this.logoutOidcIdpPartners(reqMsgCtx, req, resp, params)) {
                        this.setStage(params, ProcessingStage.DONE);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case DONE: {
                    this.finishLogout(reqMsgCtx, req, resp, params);
                    suspend = true;
                }
            }
        }
        return null;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    private boolean determineLogoutType(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        String logoutTypeParam = req.getParameter("LogoutType");
        if (logoutTypeParam != null) {
            try {
                LogoutType logoutType = LogoutType.valueOf(logoutTypeParam);
                params.put("LogoutType", (Object)logoutType);
            }
            catch (IllegalArgumentException e) {
                String problem = "Unrecognized value for LogoutType";
                this.sloSupport.finishLocalLogout(false, outMsgCtx, req, resp, Arrays.asList(problem), true);
                return false;
            }
        }
        return true;
    }

    private LogoutType getLogoutType(Map<String, Object> params) {
        LogoutType logoutType = (LogoutType)((Object)params.get("LogoutType"));
        if (logoutType == null) {
            return LogoutType.All;
        }
        return logoutType;
    }

    private StartSloRequest getStartSloRequest(Map<String, Object> params) {
        return (StartSloRequest)params.get(KEY_START_SLO_REQUEST);
    }

    private ProcessingStage getStage(Map<String, Object> params) {
        return (ProcessingStage)((Object)params.get(KEY_PROCESSING_STAGE));
    }

    private void setStage(Map<String, Object> params, ProcessingStage stage) {
        params.put(KEY_PROCESSING_STAGE, (Object)stage);
    }

    private String getTargetResource(HttpServletRequest req, Map<String, Object> params) {
        String targetResource = null;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            targetResource = startSloRequest.getReturnUrl();
        }
        if (targetResource == null && (targetResource = ProprietaryURLParams.getParam(req, "TargetResource")) == null) {
            targetResource = localMetaData.getApplicationURL("idp.after.slo");
        }
        return targetResource;
    }

    private String getInErrorResource(HttpServletRequest req, Map<String, Object> params) {
        String result = null;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            result = startSloRequest.getReturnUrl();
        }
        if (result == null) {
            result = ProprietaryURLParams.getParam(req, "InErrorResource");
        }
        return result;
    }

    private String getBinding(HttpServletRequest req, Map<String, Object> params) {
        StartSloRequest request;
        if (params != null && (request = this.getStartSloRequest(params)) != null) {
            return request.getBinding();
        }
        return ProprietaryURLParams.getParam(req, "Binding");
    }

    private boolean checkDisplayConfirmationPrompt(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws ResponseTemplateRendererException {
        boolean forceDisplayPrompt = false;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            if (!startSloRequest.isConfirmLogout()) {
                return false;
            }
            forceDisplayPrompt = true;
        }
        SloConfirmationPrompt prompt = new SloConfirmationPrompt();
        return prompt.checkDisplayConfirmationPrompt(req, resp, forceDisplayPrompt, () -> this.saveState(req, resp, outMsgCtx, params));
    }

    private boolean doInitialCleanup(OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        StartSloRequest startSloRequest;
        Map<IdpHashableAuthnBean, Collection<Session>> registered;
        if (this.checkDisplayConfirmationPrompt(outMsgCtx, req, resp, params)) {
            return false;
        }
        if (!this.isSessionAlreadyRevoked(params)) {
            IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
        }
        if (!((registered = IdpSessionRegistrySupport.getRegisteredForSession(req, resp)).isEmpty() && !SpSessionRegistrySupport.hasSessions(req, resp) || this.isSessionAlreadyRevoked(params))) {
            this.sloSupport.checkRevokeUserSession(req, resp);
        }
        IdpSessionRegistrySupport.setInvalidForSso(registered.keySet());
        IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
        this.sloSupport.terminateAndUnregisterIrsmSessions(registered, req, resp);
        LogoutType logoutType = this.getLogoutType(params);
        if (logoutType != LogoutType.SyncOnly) {
            BaseSloTemplateRenderer renderer = this.useInvisibleSloTemplate(params) ? new InvisibleSloTemplateRenderer(req, resp) : new SloTemplateRenderer(req, resp, logoutType == LogoutType.All);
            params.putAll(renderer.getParams());
        }
        this.addIdpBeansToParams(registered.keySet(), params);
        if (this.getLogoutType(params) != LogoutType.AsyncOnly) {
            Set<SpHashableAuthnBean> spBeans = SpSessionRegistrySupport.lookupAuthnBeansAndSessions(StateMgmtFactory.getLocalSessionId(req, resp)).keySet();
            SpSessionRegistrySupport.unregisterSessions(spBeans);
            params.put(KEY_SP_BEANS, SloSupport.doCheckConsolidation(spBeans));
        }
        if ((startSloRequest = this.getStartSloRequest(params)) != null && !startSloRequest.getCurrentResult()) {
            params.put(KEY_SUCCESS, false);
        } else {
            params.put(KEY_SUCCESS, true);
        }
        return true;
    }

    private void addIdpBeansToParams(Collection<IdpHashableAuthnBean> beans, Map<String, Object> params) {
        ArrayList<IdpHashableAuthnBean> allBeans = new ArrayList<IdpHashableAuthnBean>(beans);
        ArrayList<IdpHashableAuthnBean> idpAdapterBeans = new ArrayList<IdpHashableAuthnBean>();
        ArrayList<IdpConnHashableAuthnBean> idpConnBeans = new ArrayList<IdpConnHashableAuthnBean>();
        ArrayList<IdpConnHashableAuthnBean> oidcIdpConnBeans = new ArrayList<IdpConnHashableAuthnBean>();
        ArrayList<IdpHashableAuthnBean> beansToInvalidate = new ArrayList<IdpHashableAuthnBean>();
        for (IdpHashableAuthnBean bean : beans) {
            if (bean instanceof IdpConnHashableAuthnBean) {
                IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)bean;
                if (this.isOidcIdpConnBean(idpConnBean)) {
                    oidcIdpConnBeans.add(new IdpConnHashableAuthnBean(idpConnBean, false));
                    if (!idpConnBean.isDoLogout()) continue;
                    beansToInvalidate.add(idpConnBean);
                    continue;
                }
                idpConnBeans.add(idpConnBean);
                continue;
            }
            idpAdapterBeans.add(bean);
        }
        params.put(KEY_IDP_BEANS, allBeans);
        params.put(KEY_IDP_ADAPTER_BEANS, idpAdapterBeans);
        params.put(KEY_IDP_CONN_BEANS, idpConnBeans);
        params.put(KEY_OIDC_IDP_CONN_BEANS, oidcIdpConnBeans);
        if (!beansToInvalidate.isEmpty()) {
            IdpSessionRegistrySupport.setBeansInvalidForLogout(beansToInvalidate);
        }
    }

    private boolean isOidcIdpConnBean(IdpConnHashableAuthnBean idpConnBean) {
        IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
        return idpConn != null && idpConn.getProtocol() == Protocol.OIDC;
    }

    private boolean isSessionAlreadyRevoked(Map<String, Object> params) {
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        return startSloRequest != null && !startSloRequest.isForWsfedOidcSignout();
    }

    private boolean logoutIdpPartners(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (this.getLogoutType(params) == LogoutType.AsyncOnly) {
            return true;
        }
        boolean success = (Boolean)params.get(KEY_SUCCESS);
        List problems = (List)params.get(KEY_PROBLEMS);
        Collection authnBeans = (Collection)params.get(KEY_IDP_CONN_BEANS);
        IdpPartnerLogoutManager logoutManager = IdpPartnerLogoutManager.forSaml(authnBeans, success, problems, params);
        String initiator = null;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            initiator = startSloRequest.getInitiatorEntityId();
        }
        boolean done = logoutManager.doLogout(false, (String)params.get(KEY_BINDING), initiator, this.getClass(), null, reqMsgCtx, req, resp);
        this.copyLogoutStatusFromManager(logoutManager, params, reqMsgCtx);
        return done;
    }

    private boolean logoutOidcIdpPartners(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (this.getLogoutType(params) == LogoutType.AsyncOnly) {
            return true;
        }
        boolean success = (Boolean)params.get(KEY_SUCCESS);
        List problems = (List)params.get(KEY_PROBLEMS);
        Collection authnBeans = (Collection)params.get(KEY_OIDC_IDP_CONN_BEANS);
        IdpPartnerLogoutManager logoutManager = IdpPartnerLogoutManager.forOidc(authnBeans, success, problems, params);
        String initiator = null;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            initiator = startSloRequest.getInitiatorEntityId();
        }
        boolean done = logoutManager.doLogout(false, (String)params.get(KEY_BINDING), initiator, this.getClass(), null, reqMsgCtx, req, resp);
        this.copyLogoutStatusFromManager(logoutManager, params, reqMsgCtx);
        return done;
    }

    private boolean logoutSpPartners(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (this.getLogoutType(params) == LogoutType.AsyncOnly) {
            return true;
        }
        boolean success = (Boolean)params.get(KEY_SUCCESS);
        List problems = (List)params.get(KEY_PROBLEMS);
        Collection authnBeans = (Collection)params.get(KEY_IDP_BEANS);
        SpPartnerLogoutManager logoutManager = new SpPartnerLogoutManager(authnBeans, success, problems, params);
        boolean done = logoutManager.doLogout(false, (String)params.get(KEY_BINDING), null, this.getClass(), null, reqMsgCtx, req, resp);
        this.copyLogoutStatusFromManager(logoutManager, params, reqMsgCtx);
        return done;
    }

    @Override
    protected void doResumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) {
        LogoutResult logoutResult = (LogoutResult)responseObject;
        ProcessingStage processingStage = this.getStage(originalState.getParameters());
        PartnerLogoutManager logoutManager = processingStage == ProcessingStage.LOGGING_OUT_IDP_PARTNERS ? IdpPartnerLogoutManager.forSaml(originalState.getParameters()) : (processingStage == ProcessingStage.LOGGING_OUT_OIDC_IDP_PARTNERS ? IdpPartnerLogoutManager.forOidc(originalState.getParameters()) : new SpPartnerLogoutManager(originalState.getParameters()));
        logoutManager.handleLogoutResult(logoutResult);
        this.copyLogoutStatusFromManager(logoutManager, originalState.getParameters(), originalState.getOutMsgCtx());
    }

    private void copyLogoutStatusFromManager(PartnerLogoutManager manager, Map<String, Object> params, OutMessageContext outMsgCtx) {
        params.put(KEY_SUCCESS, manager.getOverallResult());
        params.put(KEY_PROBLEMS, manager.getProblems());
    }

    private boolean logoutSpAdapters(final OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, final Map<String, Object> params, boolean isFirstSpAdapter) throws AuthnAdapterException, IOException {
        if (this.getLogoutType(params) == LogoutType.AsyncOnly) {
            return true;
        }
        boolean loSuccess = (Boolean)params.get(KEY_SUCCESS);
        Collection spBeans = (Collection)params.get(KEY_SP_BEANS);
        SpAdapterLogoutManager logoutManager = new SpAdapterLogoutManager(spBeans, req, resp, AdapterLogoutMode.FRONT_OR_BACK_CHANNEL, loSuccess, isFirstSpAdapter){

            @Override
            public String saveLogoutState() {
                return CreateLogoutRequest.this.saveState(this.req, this.resp, reqMsgCtx, params);
            }

            @Override
            public void handleLogoutResult(boolean overallResult, boolean currentResult) {
                params.put(CreateLogoutRequest.KEY_SUCCESS, overallResult);
            }
        };
        return logoutManager.doLogout();
    }

    private boolean logoutIdpAdapters(final OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, final Map<String, Object> params, boolean isFirstIdpAdapter) throws AuthnAdapterException, IOException {
        if (this.getLogoutType(params) == LogoutType.AsyncOnly) {
            return true;
        }
        boolean loSuccess = (Boolean)params.get(KEY_SUCCESS);
        Collection authnBeans = (Collection)params.get(KEY_IDP_ADAPTER_BEANS);
        IdpAdapterLogoutManager logoutManager = new IdpAdapterLogoutManager(authnBeans, req, resp, AdapterLogoutMode.FRONT_OR_BACK_CHANNEL, loSuccess, isFirstIdpAdapter){

            @Override
            public String saveLogoutState() {
                return CreateLogoutRequest.this.saveState(this.req, this.resp, reqMsgCtx, params);
            }

            @Override
            public void handleLogoutResult(boolean overallResult, boolean currentResult) {
                params.put(CreateLogoutRequest.KEY_SUCCESS, overallResult);
            }
        };
        return logoutManager.doLogout();
    }

    private void finishLogout(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        boolean success = (Boolean)params.get(KEY_SUCCESS);
        List problems = (List)params.get(KEY_PROBLEMS);
        boolean validateRedirects = true;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            validateRedirects = false;
            this.sloSupport.saveStartSloResponse(startSloRequest, new StartSloResponse(success, problems), req, resp);
        }
        if (this.checkRenderSloTemplate(reqMsgCtx, req, resp, params, validateRedirects)) {
            return;
        }
        this.sloSupport.finishLocalLogout(success, reqMsgCtx, req, resp, problems, validateRedirects);
    }

    private boolean checkRenderSloTemplate(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, boolean validateRedirects) throws IOException {
        if (this.getLogoutType(params) == LogoutType.SyncOnly) {
            return false;
        }
        BaseSloTemplateRenderer sloTemplateSupport = this.useInvisibleSloTemplate(params) ? new InvisibleSloTemplateRenderer(params) : new SloTemplateRenderer(params);
        if (sloTemplateSupport.checkRenderTemplate() && !sloTemplateSupport.isTemplateRendered()) {
            sloTemplateSupport.setIdpLogoutSuccess((Boolean)params.get(KEY_SUCCESS));
            String targetResource = reqMsgCtx.getTargetResource();
            String inErrorResource = reqMsgCtx.getInErrorResource();
            if (validateRedirects) {
                if (StringUtils.isNotBlank((String)targetResource)) {
                    try {
                        redirectValidationMgr.validateTargetResourceSloAndOther(targetResource, "idp.after.slo");
                    }
                    catch (InvalidRedirectValidationException ex) {
                        sloTemplateSupport.setIdpLogoutSuccess(false);
                        targetResource = null;
                    }
                }
                if (StringUtils.isNotBlank((String)inErrorResource)) {
                    try {
                        redirectValidationMgr.validateInErrorResource(inErrorResource);
                    }
                    catch (InvalidRedirectValidationException ex) {
                        sloTemplateSupport.setIdpLogoutSuccess(false);
                        inErrorResource = null;
                    }
                }
            }
            sloTemplateSupport.renderTemplate(targetResource, inErrorResource, req, resp);
            return true;
        }
        return false;
    }

    private boolean useInvisibleSloTemplate(Map<String, Object> params) {
        boolean useInvisibleSloTemplate = false;
        StartSloRequest startSloRequest = this.getStartSloRequest(params);
        if (startSloRequest != null) {
            useInvisibleSloTemplate = startSloRequest.isUseInvisibleSloTemplate();
        }
        return useInvisibleSloTemplate;
    }

    private static enum ProcessingStage {
        INITIAL_CLEANUP,
        LOGGING_OUT_IDP_ADAPTERS,
        LOGGING_OUT_IDP_PARTNERS,
        LOGGING_OUT_SP_ADAPTERS,
        LOGGING_OUT_SP_PARTNERS,
        LOGGING_OUT_OIDC_IDP_PARTNERS,
        DONE;

    }

    public static enum LogoutType {
        All,
        SyncOnly,
        AsyncOnly;

    }
}

