/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.local.IDPLocalPathMappings;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.profiles.PartnerSessionGroup;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.profiles.idp.StartSloResponse;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.IrsmSession;
import org.sourceid.saml20.service.OidcSession;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestType;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.bindings.FormPost;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class SLOSupport {
    private static final Log log = LogFactory.getLog(SLOSupport.class);
    private final MetadataLocal localMetadata;
    private static TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private final SessionStateSupport sessionStateSupport = new SessionStateSupport();

    public SLOSupport(MetadataLocal localMetadata) {
        this.localMetadata = localMetadata;
    }

    public void checkRevokeUserSession(HttpServletRequest req, HttpServletResponse resp) {
        this.checkRevokeUserSession(StateMgmtFactory.getSri(req, resp));
    }

    public void checkRevokeUserSession(String sri) {
        if (MgmtFactory.getSessionSettingsManager().getSessionSettings().isRevokeUserSessionOnLogout()) {
            StateMgmtFactory.getSessionRevocationService().addRevokedSri(sri);
            IdpAuditLogger.logSessionRevocation("logout");
        }
    }

    public String makeRequestStateRef() {
        return IDGenerator.rndAlphaNumeric(25);
    }

    public void sendStartSloRequest(StartSloRequest request, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IDPLocalPathMappings idpLocalPaths = this.localMetadata.getIdpLocalPathMappings();
        String idpInitSloPath = AdapterPathSupport.convertPath(req, resp, idpLocalPaths.getInitiateSLOPath());
        this.sessionStateSupport.setAttribute(request.getRequestStateRef(), (Object)request, req, resp, false);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("RequestStateRef", request.getRequestStateRef());
        log.debug((Object)("Sending StartSloRequest to " + idpInitSloPath + ", returnUrl=" + request.getReturnUrl()));
        FormPost.post(idpInitSloPath, postParams, req, resp);
    }

    public StartSloRequest getStartSloRequest(HttpServletRequest req, HttpServletResponse resp) {
        String requestStateRef = req.getParameter("RequestStateRef");
        if (requestStateRef == null) {
            return null;
        }
        Object attr = this.sessionStateSupport.removeAttribute(requestStateRef, req, resp);
        if (attr instanceof StartSloRequest) {
            StartSloRequest request = (StartSloRequest)attr;
            log.debug((Object)("Received StartSloRequest, returnUrl=" + request.getReturnUrl()));
            return request;
        }
        return null;
    }

    public void saveStartSloResponse(StartSloRequest request, StartSloResponse response, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!request.isForWsfedOidcSignout()) {
            log.debug((Object)("Saving StartSloResponse, overallResult=" + response.getOverallResult()));
            this.sessionStateSupport.setAttribute(request.getRequestStateRef(), (Object)response, req, resp, false);
        }
    }

    public StartSloResponse getStartSloResponse(String requestStateRef, HttpServletRequest req, HttpServletResponse resp) {
        Object attr = this.sessionStateSupport.removeAttribute(requestStateRef, req, resp);
        if (attr instanceof StartSloResponse) {
            StartSloResponse response = (StartSloResponse)attr;
            log.debug((Object)("Received StartSloResponse, overallResult=" + response.getOverallResult()));
            return response;
        }
        return null;
    }

    public void finishLocalLogout(boolean success, OutMessageContext reqCtx, HttpServletRequest req, HttpServletResponse resp, List<String> problems, boolean validateRedirects) throws IOException {
        problems = problems == null ? new ArrayList<String>() : new ArrayList<String>(problems);
        boolean targetResourceSloValidationFailed = false;
        if (success) {
            String applicationURL;
            String string = applicationURL = reqCtx != null ? reqCtx.getTargetResource() : null;
            if (applicationURL == null) {
                applicationURL = this.localMetadata.getApplicationURL("idp.after.slo");
            }
            if (!StringUtils.isBlank((String)applicationURL)) {
                try {
                    if (validateRedirects) {
                        redirectValidationMgr.validateTargetResourceSloAndOther(applicationURL, "idp.after.slo");
                    }
                    resp.sendRedirect(applicationURL);
                }
                catch (InvalidRedirectValidationException ex) {
                    targetResourceSloValidationFailed = true;
                    problems.add(ex.getMessage());
                }
            } else {
                ResponseTemplateRenderer renderingThing = ResponseTemplateRenderer.getInstance();
                HashMap<String, Object> pageParams = new HashMap<String, Object>();
                renderingThing.render(req, resp, "idp.slo.success.page.template.html", pageParams);
            }
        }
        if (!success || targetResourceSloValidationFailed) {
            String errorResource = reqCtx != null ? reqCtx.getInErrorResource() : null;
            boolean inErrorValidationFailed = false;
            if (!StringUtils.isBlank((String)errorResource)) {
                try {
                    if (validateRedirects) {
                        redirectValidationMgr.validateInErrorResource(errorResource);
                    }
                    resp.sendRedirect(errorResource);
                }
                catch (InvalidRedirectValidationException ex) {
                    inErrorValidationFailed = true;
                    problems.add(ex.getMessage());
                }
            }
            if (StringUtils.isBlank((String)errorResource) || inErrorValidationFailed) {
                this.renderErrorPage(req, resp, problems);
            }
        }
    }

    public void renderErrorPage(HttpServletRequest req, HttpServletResponse resp, List<String> problems) throws ResponseTemplateRendererException {
        ResponseTemplateRenderer renderingThing = ResponseTemplateRenderer.getInstance();
        HashMap<String, Object> pageParams = new HashMap<String, Object>();
        pageParams.put("errorMessage", Util.isEmpty(problems) ? "" : StringUtils.join(problems, (String)" "));
        renderingThing.render(req, resp, "idp.slo.error.page.template.html", pageParams);
    }

    public List<WebSsoSession> getRemainingSaml2Sessions(Collection<Session> sessions, String partnerEntityId) {
        LinkedList<WebSsoSession> remainingSessions = new LinkedList<WebSsoSession>();
        LinkedList<String> toUnregister = new LinkedList<String>();
        List<WebSsoSession> issuedSessions = this.getWebSsoSessions(sessions);
        for (WebSsoSession session : issuedSessions) {
            if (partnerEntityId != null && session.getEntityId().equals(partnerEntityId)) {
                toUnregister.add(session.getAssertionId());
                continue;
            }
            if (!this.isSaml2(session)) continue;
            remainingSessions.add(session);
        }
        IdpSessionRegistrySupport.unregisterSessions(toUnregister);
        return remainingSessions;
    }

    boolean isSaml2(WebSsoSession session) {
        String spEntityId = session.getEntityId();
        SpConnection spConnection = MetadataSupport.getSpConnection(spEntityId);
        return Protocol.SAML20 == spConnection.getProtocol();
    }

    public List<WebSsoSession> getProtocolSessions(Map<IdpHashableAuthnBean, Collection<Session>> registered, Protocol protocol) {
        LinkedList<WebSsoSession> sessions = new LinkedList<WebSsoSession>();
        for (Collection<Session> issuedSessions : registered.values()) {
            sessions.addAll(this.getProtocolSessions(issuedSessions, protocol));
        }
        return sessions;
    }

    public List<WebSsoSession> getProtocolSessions(Collection<Session> issuedSessions, Protocol protocol) {
        LinkedList<WebSsoSession> sessions = new LinkedList<WebSsoSession>();
        for (WebSsoSession webSsoSession : this.getWebSsoSessions(issuedSessions)) {
            String spEntityId = webSsoSession.getEntityId();
            SpConnection spConnection = MetadataSupport.getSpConnection(spEntityId);
            if (protocol != spConnection.getProtocol()) continue;
            sessions.add(webSsoSession);
        }
        return sessions;
    }

    public Map<IdpHashableAuthnBean, Collection<WebSsoSession>> getWebSsoSessions(Map<IdpHashableAuthnBean, Collection<Session>> sessions) {
        HashMap<IdpHashableAuthnBean, Collection<WebSsoSession>> result = new HashMap<IdpHashableAuthnBean, Collection<WebSsoSession>>();
        for (Map.Entry<IdpHashableAuthnBean, Collection<Session>> entry : sessions.entrySet()) {
            List<WebSsoSession> webSsoSessions = this.getWebSsoSessions(entry.getValue());
            if (webSsoSessions.isEmpty()) continue;
            result.put(entry.getKey(), webSsoSessions);
        }
        return result;
    }

    List<WebSsoSession> getWebSsoSessions(Collection<Session> sessions) {
        LinkedList<WebSsoSession> result = new LinkedList<WebSsoSession>();
        for (Session session : sessions) {
            if (!session.isWebSsoSession()) continue;
            result.add(session.getWebSsoSession());
        }
        return result;
    }

    public List<OidcSession> getOidcSessions(Map<IdpHashableAuthnBean, Collection<Session>> registered) {
        LinkedList<OidcSession> result = new LinkedList<OidcSession>();
        for (Collection<Session> sessions : registered.values()) {
            result.addAll(this.getOidcSessions(sessions));
        }
        return result;
    }

    public void terminateAndUnregisterIrsmSessions(Map<IdpHashableAuthnBean, Collection<Session>> registered, HttpServletRequest req, HttpServletResponse resp) {
        Map<IdpHashableAuthnBean, List<IrsmSession>> irsmSessions = this.getIrsmSessionsByAuthnBean(registered);
        for (Map.Entry<IdpHashableAuthnBean, List<IrsmSession>> entry : irsmSessions.entrySet()) {
            for (IrsmSession session : entry.getValue()) {
                for (String attrKey : session.getAttributeKeys()) {
                    this.sessionStateSupport.removeAttribute(attrKey, req, resp);
                }
            }
            IdpSessionRegistrySupport.unregisterSessions(entry.getKey(), (Collection<? extends Session>)entry.getValue());
        }
    }

    public Map<IdpHashableAuthnBean, List<IrsmSession>> getIrsmSessionsByAuthnBean(Map<IdpHashableAuthnBean, Collection<Session>> registered) {
        HashMap<IdpHashableAuthnBean, List<IrsmSession>> result = new HashMap<IdpHashableAuthnBean, List<IrsmSession>>();
        for (Map.Entry<IdpHashableAuthnBean, Collection<Session>> entry : registered.entrySet()) {
            List<IrsmSession> irsmSessions = this.getIrsmSessions(entry.getValue());
            if (irsmSessions.isEmpty()) continue;
            result.put(entry.getKey(), irsmSessions);
        }
        return result;
    }

    public Map<IdpHashableAuthnBean, List<OidcSession>> getOidcSessionsByAuthnBean(Map<IdpHashableAuthnBean, Collection<Session>> registered) {
        HashMap<IdpHashableAuthnBean, List<OidcSession>> result = new HashMap<IdpHashableAuthnBean, List<OidcSession>>();
        for (Map.Entry<IdpHashableAuthnBean, Collection<Session>> entry : registered.entrySet()) {
            List<OidcSession> oidcSessions = this.getOidcSessions(entry.getValue());
            if (oidcSessions.isEmpty()) continue;
            result.put(entry.getKey(), oidcSessions);
        }
        return result;
    }

    public void securityAuditLog(PartnerSessionGroup sessionGroup, Protocol protocol, OutMessageContext outMsgCtx) {
        SpAuditLogger.setUserName(sessionGroup.getNameId());
        SpAuditLogger.setPartnerId(sessionGroup.getEntityId());
        SpAuditLogger.setVirtualServerId(sessionGroup.getVirtualServerId());
        SpAuditLogger.setProtocol(protocol.toString());
        SpAuditLogger.setEvent("SLO");
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        if (outMsgCtx != null) {
            LogoutRequestType requestType;
            outMsgCtx.populateOutUrlAuditLogParameter();
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(outMsgCtx).toString());
            LogoutRequestDocument requestDoc = (LogoutRequestDocument)outMsgCtx.getXmlObject();
            if (requestDoc != null && (requestType = requestDoc.getLogoutRequest()) != null) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.REQUEST_ID.toString(), (String)requestType.getID());
            }
        }
        SpAuditLogger.log("SP-initiated SLO...");
    }

    public void securityAuditLogForOidc(IdpConnHashableAuthnBean bean) {
        SpAuditLogger.setUserName(bean.getSubject());
        SpAuditLogger.setPartnerId(bean.getEntityId());
        SpAuditLogger.setProtocol(Protocol.OIDC.toString());
        SpAuditLogger.setEvent("SLO");
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        if (bean.getSid() != null) {
            TrackingIdSupport.addReference(bean.getSid());
        }
        SpAuditLogger.log("RP-initiated SLO...");
    }

    List<OidcSession> getOidcSessions(Collection<Session> issuedSessions) {
        LinkedList<OidcSession> sessions = new LinkedList<OidcSession>();
        for (Session issuedSession : issuedSessions) {
            if (!issuedSession.isOidcSession()) continue;
            sessions.add(issuedSession.getOidcSession());
        }
        return sessions;
    }

    List<IrsmSession> getIrsmSessions(Collection<Session> issuedSessions) {
        LinkedList<IrsmSession> sessions = new LinkedList<IrsmSession>();
        for (Session issuedSession : issuedSessions) {
            if (!issuedSession.isIrsmSession()) continue;
            sessions.add(issuedSession.getIrsmSession());
        }
        return sessions;
    }
}

