/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.websso.commondomain.CommonDomainUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestCreatorBase;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.OutMessageContext;

public class WriteCDC
extends RequestCreatorBase {
    protected static final TargetResourceValidationMgr targetResourceValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String entityId = this.localMetaData.getEntityId();
        String returnUrl = ProprietaryURLParams.getParam(req, "TargetResource");
        String string = returnUrl = StringUtils.isBlank((String)returnUrl) ? req.getHeader("Referer") : returnUrl;
        if (returnUrl == null) {
            throw new ProcessRuntimeException("A return URL must be specified either with the TargetResource param or via a 'Referer' header.");
        }
        try {
            targetResourceValidationMgr.validateTargetResourceIdpDiscovery(returnUrl);
        }
        catch (InvalidRedirectValidationException e) {
            throw new ProcessRuntimeException(e.getMessage());
        }
        String idpRegistrationUrl = CommonDomainUtil.createIdpRegistrationUrl(entityId, returnUrl);
        resp.sendRedirect(idpRegistrationUrl);
        return null;
    }
}

