/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AdvancedAuthnPolicy;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.profiles.BindingEndptChooser;
import org.sourceid.saml20.profiles.PaosSupport;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.protocol.AuthnRequestUtil;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.saml20.xmlbinding.protocol.AuthnContextComparisonType;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestType;
import org.sourceid.util.AuthenticationContextUtil;
import org.sourceid.util.ResourceEvaluator;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.sp.SSOStarter;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateAuthnRequest
implements SSOStarter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final ResourceEvaluator resourceEvaluator = new ResourceEvaluator();
    private final MetadataLocal localMeta = MetaDataFactory.getLocalMetaData();
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();

    @Override
    public OutMessageContext startSso(HttpServletRequest req, HttpServletResponse resp, OutMessageContext ctx, IdpConnection idpConn, AuthnPolicy authnPolicy) {
        String allowCreateStr = req.getParameter("AllowCreate");
        boolean allowCreate = allowCreateStr == null || Boolean.parseBoolean(allowCreateStr);
        boolean isPassive = Boolean.parseBoolean(req.getParameter("IsPassive"));
        boolean forceAuthn = Boolean.parseBoolean(req.getParameter("ForceAuthn"));
        String requestedFormat = req.getParameter("RequestedFormat");
        String requestedSpNameQualifier = req.getParameter("RequestedSPNameQualifier");
        String[] authnCtxClassRefs = req.getParameterValues("RequestedAuthnCtx");
        Object authnCtxDeclRefs = req.getParameterValues("RequestedAuthnDeclRef");
        String ctxComparisonMethodStr = req.getParameter("CtxComparisonMethod");
        String[] authenticatingIdpIdArray = req.getParameterValues("AuthenticatingIdpId");
        Collection<String> authenticatingIdpIds = null;
        if (authenticatingIdpIdArray != null) {
            authenticatingIdpIds = Arrays.asList(authenticatingIdpIdArray);
        }
        Integer proxyCount = null;
        LinkedList<String> requesterIds = null;
        String virtualServerId = ctx.getVirtualServerId();
        AuthnContextComparisonType.Enum ctxComparisonMethod = null;
        if (ctxComparisonMethodStr != null) {
            ctxComparisonMethod = AuthnContextComparisonType.Enum.forString((String)ctxComparisonMethodStr);
        }
        if (authnPolicy != null) {
            isPassive = !authnPolicy.allowUserInteraction();
            forceAuthn = authnPolicy.reauthenticate();
            List<String> authnCtxs = authnPolicy.getRequestAuthnContexts();
            if (authnCtxs.isEmpty()) {
                authnCtxs = Arrays.asList("");
            }
            authnCtxClassRefs = authnCtxs.toArray(new String[authnCtxs.size()]);
            AuthenticationContextUtil.performLocalToRemoteMapping(idpConn, authnCtxClassRefs);
            if (authnPolicy instanceof AdvancedAuthnPolicy) {
                AdvancedAuthnPolicy advAuthnPolicy = (AdvancedAuthnPolicy)authnPolicy;
                List<String> authnCtxDecls = advAuthnPolicy.getRequestedAuthnContextDecl();
                authnCtxDeclRefs = !authnCtxDecls.isEmpty() ? authnCtxDecls.toArray(new String[authnCtxDecls.size()]) : null;
                ctxComparisonMethod = advAuthnPolicy.getComparisonType();
                ProxyScoping proxyScoping = advAuthnPolicy.getProxyScoping();
                if (proxyScoping != null) {
                    if (proxyScoping.hasProxyCount()) {
                        proxyCount = proxyScoping.getProxyCount() - 1;
                    }
                    if (proxyScoping.hasIdpSet()) {
                        authenticatingIdpIds = proxyScoping.getIdpSet();
                    }
                    if (proxyScoping.hasRequesterIds()) {
                        requesterIds = new LinkedList<String>(proxyScoping.getRequesterIds());
                    }
                }
            }
        }
        AuthnRequestDocument authnRequestDoc = AuthnRequestUtil.createBasicAuthnRequest(virtualServerId, forceAuthn, isPassive);
        AuthnRequestType authnRequestType = authnRequestDoc.getAuthnRequest();
        AuthnRequestUtil.setNameIDPolicy(authnRequestType, allowCreate, requestedFormat, requestedSpNameQualifier);
        AuthnRequestUtil.setRequestedAuthnCtx(authnRequestType, authnCtxClassRefs, authnCtxDeclRefs, ctxComparisonMethod);
        AuthnRequestUtil.setScoping(authnRequestType, authenticatingIdpIds, proxyCount, requesterIds);
        AuthnRequestUtil.setSubject(authnRequestType, ctx.getRequestedUserId());
        VirtualIdentity defaultVsid = VirtualIdentityUtil.getDefaultVirtualIdForRuntime(idpConn);
        this.setRequestedBindingEndpt(req, authnRequestType, defaultVsid.getVirtualEntityId(DomainMode.RUNTIME));
        this.verifyProfile(idpConn);
        this.doCheckBindingOverride(req, idpConn, ctx);
        this.doPaos(req, idpConn, ctx);
        this.setSigPolicy(idpConn, ctx);
        Map<String, Object> authReqCustomizeContext = MessageCustomization.getAuthnReqCustomizeContext(idpConn, req);
        authnRequestDoc = idpConn.messageCustomize("authn-request", AuthnRequestDocument.class, req, resp, authnRequestDoc, "AuthnRequestDocument", authReqCustomizeContext);
        ctx.setXmlObject((XmlObject)authnRequestDoc);
        return ctx;
    }

    private void verifyProfile(IdpConnection idpConn) {
        EnabledProfiles enabledProfiles = idpConn.getEnabledProfiles();
        this.profileProcessorMatrix.verifyProcessorEnablement(0, enabledProfiles);
    }

    private void setRequestedBindingEndpt(HttpServletRequest req, AuthnRequestType authnRequestType, String connectionDefaultVsid) {
        String requestedAcsUrl;
        String requestedBinding;
        String requestedAcsIdxStr = req.getParameter("RequestedACSIdx");
        if (!StringUtils.isBlank((String)requestedAcsIdxStr)) {
            try {
                int idx = Integer.parseInt(requestedAcsIdxStr);
                authnRequestType.setAssertionConsumerServiceIndex(idx);
            }
            catch (NumberFormatException e) {
                throw new ProcessRuntimeException(requestedAcsIdxStr + " is not a valid number", e);
            }
        }
        if (!StringUtils.isBlank((String)(requestedBinding = req.getParameter("RequestedBinding")))) {
            authnRequestType.setProtocolBinding(requestedBinding);
        }
        if (!StringUtils.isBlank((String)(requestedAcsUrl = req.getParameter("RequestedAcsUrl")))) {
            ResourceEvaluator.Result result;
            String requestedVsid = VirtualIdentityUtil.extractVsid(req);
            boolean isDefaultVsidRequested = StringUtils.isBlank((String)requestedVsid) || requestedVsid.equals(connectionDefaultVsid);
            StringJoiner mismatchedUrls = new StringJoiner(", ");
            if (isDefaultVsidRequested) {
                String url = this.getExpectedAcsUrl(null);
                result = this.resourceEvaluator.isResourceMatch(requestedAcsUrl, url);
                if (!result.isMatch()) {
                    mismatchedUrls.add(url);
                    url = this.getExpectedAcsUrl(connectionDefaultVsid);
                    result = this.resourceEvaluator.isResourceMatch(requestedAcsUrl, url);
                    if (!result.isMatch()) {
                        mismatchedUrls.add(url);
                    }
                }
            } else {
                String url = this.getExpectedAcsUrl(requestedVsid);
                result = this.resourceEvaluator.isResourceMatch(requestedAcsUrl, url);
                if (!result.isMatch()) {
                    mismatchedUrls.add(url);
                }
            }
            if (result.isMatch()) {
                authnRequestType.setAssertionConsumerServiceURL(requestedAcsUrl);
            } else {
                String msg = "RequestedAcsUrl did not match the allowed value(s): " + mismatchedUrls.toString();
                String[] errorDetailParameters = new String[]{"RequestedAcsUrl", mismatchedUrls.toString()};
                throw new InvalidRequestParameterException(msg, "errorDetail.createAuthnRequest.resourceEvaluationCriteriaNotMet", errorDetailParameters);
            }
        }
    }

    private String getExpectedAcsUrl(String vsid) {
        String suffix;
        String url = this.localMeta.getBaseUrl();
        if (StringUtils.isNotEmpty((String)vsid)) {
            HashMap<String, Object> vsidMap = new HashMap<String, Object>();
            vsidMap.put("vsid", vsid);
            suffix = new PathUtil("/resume", ".ping").encodeParamMap(this.localMeta.getAssertionConsumerServices().getDefault().getLocation(), vsidMap);
        } else {
            suffix = this.localMeta.getAssertionConsumerServices().getDefault().getLocation();
        }
        return url + suffix;
    }

    private void doCheckBindingOverride(HttpServletRequest req, IdpConnection idpConn, OutMessageContext ctx) {
        BindingEndptChooser.doCheckBindingOverride(req, (Endpoints)idpConn.getSingleSignOnServices(), ctx, "SSO");
    }

    private void setSigPolicy(IdpConnection idpConn, OutMessageContext ctx) {
        if (!idpConn.isWantAuthnRequestsSigned()) {
            ctx.setSignaturePolicy(SignaturePolicy.DO_NOT_SIGN);
        }
    }

    private void doPaos(HttpServletRequest req, IdpConnection idpConn, OutMessageContext ctx) {
        if (PaosSupport.hasPaosHeaders(req)) {
            EndpointGroup singleSignOnServices = idpConn.getSingleSignOnServices();
            Endpoint soapSsoEndpoint = singleSignOnServices.getEndpointByBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            if (soapSsoEndpoint == null && this.config.getBooleanValue("ForceTryPaos", true)) {
                soapSsoEndpoint = new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:PAOS", ctx.getEndpoint());
            }
            if (soapSsoEndpoint != null) {
                ctx.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
                ctx.setEndpoint(soapSsoEndpoint.getFullLocation());
            }
        }
    }
}

