/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.util.filter.ConnectionFilter;
import org.sourceid.saml20.domain.util.filter.FilterCriteria;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.profiles.ProfileProcessFactory;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.commondomain.CommonDomainCookie;
import org.sourceid.websso.commondomain.CommonDomainUtil;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestCreator;
import org.sourceid.websso.profiles.ResumableRequestCreatorBase;
import org.sourceid.websso.profiles.sp.IdpSelector;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateCdcAuthnRequest
extends ResumableRequestCreatorBase {
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final boolean autoSelectLastIdp = this.config.getBooleanValue("AutoSelectLastIdp", false);
    private final ConnectionFilter filter;

    public CreateCdcAuthnRequest() {
        FilterCriteria criteria = new FilterCriteria();
        criteria.setRoles(Role.IDP);
        criteria.setActive(true);
        criteria.setSpInitSSO(true);
        criteria.setProtocols(Protocol.SAML20);
        this.filter = new ConnectionFilter(criteria);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OutMessageContext reqMsgCtx = null;
        String partnerIdpId = req.getParameter("PartnerIdpId");
        IdpDiscovery idpDiscoveryParams = this.localMetaData.getIdpDiscovery();
        boolean sPCommonDomainClientEnabled = idpDiscoveryParams.isSpCommonDomainClient() && this.localMetaData.getEnableIdpDiscovery();
        SPLocalPathMappings spLocalPaths = this.localMetaData.getSpLocalPathMappings();
        Map<String, Object> params = IdpSelector.getRelatedRequestParams(req);
        this.addTrackedParams(req, params);
        String policyAction = ProprietaryURLParams.getParam(req, "PolicyAction");
        params.put("PolicyAction", policyAction);
        if (!StringUtils.isBlank((String)partnerIdpId)) {
            ProfileProcessFactory processFactory = this.localMetaData.getProfileProcessFactory();
            try {
                RequestCreator requestCreator = processFactory.getRequestCreator(spLocalPaths.getInitiateSSOPath());
                return requestCreator.process(req, resp);
            }
            catch (NoSuchProcessException ex) {
                throw new ProcessRuntimeException("Unable to find processor for " + spLocalPaths.getInitiateSSOPath());
            }
        }
        if (!sPCommonDomainClientEnabled) {
            if (!this.config.getBooleanValue("ShowAllIdPsEvenIfCDCisDisabled", true)) throw new ProcessRuntimeException("The system (SP) is not configured to use Common Domain Service.");
            return this.resume(null, req, resp, params);
        }
        String resumePath = this.saveState(req, resp, reqMsgCtx, params);
        this.requestCommonDomainCookie(req, resp, resumePath);
        return reqMsgCtx;
    }

    private void requestCommonDomainCookie(HttpServletRequest req, HttpServletResponse resp, String resumePath) throws IOException {
        String url = CommonDomainUtil.createGetIdpsUrl(req, resumePath);
        resp.sendRedirect(url);
    }

    @Override
    protected OutMessageContext doResume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, AuthnAdapterException {
        boolean foundViaCDC = true;
        ArrayList<String> idpList = new ArrayList<String>();
        String cookieParam = req.getParameter("C");
        if (!StringUtils.isBlank((String)cookieParam)) {
            List<String> idpListInCookie = CommonDomainCookie.decodeCommonDomainCookie(cookieParam);
            List<String> activeIdpList = MetaDataFactory.getMetadataDirectory().getIdpEntityIds();
            HashSet<String> S2 = new HashSet<String>(activeIdpList);
            for (String idp : idpListInCookie) {
                if (!S2.contains(idp)) continue;
                idpList.add(idp);
            }
        }
        if (idpList.isEmpty()) {
            foundViaCDC = false;
            Collection<IdpConnection> idpConnections = this.metadataDirectory.getIdpConnections();
            for (ConnectionBase idp : this.filter.filter(idpConnections)) {
                idpList.add(idp.getEntityId());
            }
        }
        if (this.config.getBooleanValue("AutoStartSSOWithOneIdp", true) && (idpList.size() == 1 || this.autoSelectLastIdp)) {
            String resultIdp = (String)idpList.get(0);
            if (this.autoSelectLastIdp) {
                resultIdp = (String)idpList.get(idpList.size() - 1);
            }
            String reqUrlWithIdpId = IdpSelector.createAuthnRequestUrl(resultIdp, params);
            this.log.debug((Object)("Redirecting to " + reqUrlWithIdpId));
            resp.sendRedirect(AdapterPathSupport.convertPath(req, resp, reqUrlWithIdpId));
        } else {
            IdpSelector.renderIdpSelectionPage(req, resp, idpList, params, foundViaCDC);
        }
        return null;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }
}

