/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.AttributeNameMapping;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.ResponseHandlerBase;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.ValidateAttQueryResp;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.util.AttributeWriter;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleAttrQueryResponse
extends ResponseHandlerBase {
    protected final ValidateAttQueryResp validateAttQueryResp = new ValidateAttQueryResp();
    protected final AssertionAssembler disassembler = new AssertionAssembler();

    @Override
    protected void verifySignature(InMessageContext inMsgCtx, HttpServletRequest req) throws InvalidResponseException {
        IdpConnection idp = MetadataSupport.getIdpConnection(inMsgCtx.getEntityId());
        boolean requireSignedResponse = idp.getAttributeAuthority().isRequireSignedResponse();
        inMsgCtx.setSignatureRequired(requireSignedResponse);
        super.verifySignature(inMsgCtx, req);
    }

    @Override
    protected void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException {
        XmlObject xmlObject = respMsgCtx.getXmlObject();
        ResponseDocument respDoc = (ResponseDocument)xmlObject;
        IdpConnection idp = MetadataSupport.getIdpConnection(respMsgCtx.getEntityId());
        String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idp).getVirtualEntityId(DomainMode.RUNTIME);
        Assertion assertion = this.validateAttQueryResp.validate(respDoc, idp, virtualEntityId, respMsgCtx);
        Map<String, AttributeValue> attributes = this.disassembler.disassembleAttrStmts(assertion.getAssertionType());
        AttributeAuthority attributeAuthority = idp.getAttributeAuthority();
        AttributeNameMapping attributeNameMapping = attributeAuthority.getAttributeNameMapping();
        attributes = attributeNameMapping.mapToAppAttributeNames(attributes);
        AttributeWriter.writeResponse(resp, attributes);
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.log.error((Object)"Problem with attribute query response handling.  No attributes will be returned to the calling application.");
    }
}

