/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.HandleLogoutRequestBase;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.profiles.idp.StartSloRequest;
import org.sourceid.saml20.profiles.idp.StartSloResponse;
import org.sourceid.saml20.service.SessionInfoForPartnerSessionsResult;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.util.DeficientPartnerWorkaround;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestType;
import org.sourceid.saml20.xmlbinding.protocol.LogoutResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class HandleLogoutRequest
extends HandleLogoutRequestBase {
    private static final String KEY_REQUEST_STATE_REF = "requestStateRef";
    private static final String KEY_INITIATOR = "initiator";
    private final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);
    private final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();
    private final SLOSupport idpSloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        LogoutRequestDocument logoutRequestDoc = (LogoutRequestDocument)inMsgCtx.getXmlObject();
        LogoutRequestType logoutRequest = logoutRequestDoc.getLogoutRequest();
        ConnectionBase conn = this.getPartnerMetadata(inMsgCtx);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, conn).getVirtualEntityId(DomainMode.RUNTIME);
        this.decryptNameID(conn, logoutRequest, virtualServerId);
        String entityId = inMsgCtx.getEntityId();
        if (!logoutRequest.isSetNotOnOrAfter()) {
            StringBuilder msg = new StringBuilder();
            msg.append("The session authority (").append(entityId).append(") MUST set the value of the ");
            msg.append("NotOnOrAfter attribute of the logout request message.");
            StatusResponseException e = new StatusResponseException(TopLevelStatusCode.REQUESTER, msg.toString());
            DeficientPartnerWorkaround.checkThrow(e, entityId, "LogoutRequestSessionAuthorityMustSetNotOnOrAfter");
        } else {
            String[] now = new Date();
            Date notOnOrAfter = logoutRequest.getNotOnOrAfter().getTime();
            if (!now.before(notOnOrAfter)) {
                String msg = "NotOnOrAfter attribute of the logout request message has past";
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, msg);
            }
        }
        for (String sessionIndex : logoutRequest.getSessionIndexArray()) {
            TrackingIdSupport.addReference(sessionIndex);
        }
        if (!inMsgCtx.isBackChannelBinding()) {
            IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
            IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
        }
        NameIDType nameId = logoutRequest.getNameID();
        SessionInfoForPartnerSessionsResult sessionIds = IdpSessionRegistrySupport.getSessionInfoForPartnerSessions(entityId, nameId, Arrays.asList(logoutRequest.getSessionIndexArray()));
        IdpSessionRegistrySupport.setSessionBeansInvalidForSso(sessionIds.getPrimarySessionIds());
        IdpSessionRegistrySupport.deleteStoredSessions(sessionIds.getStoredSessionGroupIds());
        Set<SpHashableAuthnBean> spAuthnBeans = this.getSpAdapterBeansForSessionIds(sessionIds.getPrimarySessionIds());
        if (!(inMsgCtx.isBackChannelBinding() || spAuthnBeans.isEmpty() && !IdpSessionRegistrySupport.hasSessions(req, resp))) {
            this.idpSloSupport.checkRevokeUserSession(req, resp);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("success", true);
        params.put("processingStage", (Object)HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_SIDE);
        params.put(KEY_INITIATOR, entityId);
        if (inMsgCtx.isBackChannelBinding() || !IdpSessionRegistrySupport.hasSessions(req, resp)) {
            this.addIdpBeansToParams(sessionIds.getBeans(), params);
            this.addSpBeansToParams(spAuthnBeans, params);
            this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_ADAPTERS);
        }
        this.securityAuditLog(nameId, entityId, virtualServerId, inMsgCtx, outMsgCtx);
        this.resume(inMsgCtx, req, resp, outMsgCtx, params);
    }

    protected void securityAuditLog(NameIDType nameId, String entityId, String virtualServerId, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        SpAuditLogger.setEvent("SLO");
        SpAuditLogger.setProtocol(Protocol.SAML20.toString());
        SpAuditLogger.setUserName(nameId);
        SpAuditLogger.setPartnerId(entityId);
        SpAuditLogger.setVirtualServerId(virtualServerId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"Request");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(inMsgCtx).toString());
        if (outMsgCtx != null) {
            StatusResponseType responseType;
            outMsgCtx.populateOutUrlAuditLogParameter();
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(outMsgCtx).toString());
            LogoutResponseDocument responseDoc = (LogoutResponseDocument)outMsgCtx.getXmlObject();
            if (responseDoc != null && (responseType = responseDoc.getLogoutResponse()) != null) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString(), (String)responseType.getID());
                String inResponseTo = responseType.isSetInResponseTo() ? responseType.getInResponseTo() : null;
                ThreadContext.put((String)AuditLogger.MDC_KEY.REQUEST_ID.toString(), (String)inResponseTo);
                ThreadContext.put((String)AuditLogger.MDC_KEY.IN_RESPONSE_TO.toString(), (String)inResponseTo);
            }
        }
        SpAuditLogger.log("logging out ...");
    }

    protected Set<SpHashableAuthnBean> getSpAdapterBeansForSessionIds(Collection<String> primarySessionIds) {
        HashSet<SpHashableAuthnBean> result = new HashSet<SpHashableAuthnBean>();
        for (String primarySessionId : primarySessionIds) {
            Map<SpHashableAuthnBean, WebSsoSession> registered = SpSessionRegistrySupport.lookupAuthnBeansAndSessions(primarySessionId);
            result.addAll(registered.keySet());
        }
        return result;
    }

    @Override
    protected void doResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws StatusResponseException, IOException, AuthnAdapterException {
        boolean suspend = false;
        while (!suspend) {
            switch (this.getStage(params)) {
                case LOGGING_OUT_IDP_SIDE: {
                    this.logoutIdpSide(inMsgCtx, req, resp, outMsgCtx, params);
                    suspend = true;
                    break;
                }
                case WAITING_FOR_IDP_SIDE_RESPONSE: {
                    this.handleIdpSideLogoutResponse(req, resp, params);
                    this.setStage(params, HandleLogoutRequestBase.ProcessingStage.DONE);
                    break;
                }
                case LOGGING_OUT_IDP_ADAPTERS: {
                    if (this.logoutIdpAdapters(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_PARTNERS);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_IDP_PARTNERS: {
                    if (this.logoutIdpPartners(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_SP_ADAPTERS);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_SP_ADAPTERS: {
                    if (this.logoutSpAdapters(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_SP_PARTNERS);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case LOGGING_OUT_SP_PARTNERS: {
                    if (this.logoutSpPartners(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.DONE);
                        break;
                    }
                    suspend = true;
                    break;
                }
                case DONE: {
                    this.finishLogout(params);
                    suspend = true;
                }
            }
        }
    }

    protected void logoutIdpSide(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws IOException {
        String requestStateRef = this.idpSloSupport.makeRequestStateRef();
        params.put(KEY_REQUEST_STATE_REF, requestStateRef);
        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.WAITING_FOR_IDP_SIDE_RESPONSE);
        String resumeUrl = this.saveState(req, resp, inMsgCtx, outMsgCtx, params);
        this.idpSloSupport.sendStartSloRequest(new StartSloRequest(requestStateRef, resumeUrl, false, null, (String)params.get(KEY_INITIATOR), true), req, resp);
    }

    protected void handleIdpSideLogoutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) {
        String requestStateRef = (String)params.get(KEY_REQUEST_STATE_REF);
        StartSloResponse response = this.idpSloSupport.getStartSloResponse(requestStateRef, req, resp);
        if (response == null) {
            throw new ProcessRuntimeException("Expected StartSloResponse but none was found");
        }
        this.updateStatus(params, response.getOverallResult());
    }

    private void finishLogout(Map<String, Object> params) throws StatusResponseException {
        boolean success;
        Boolean successObj = (Boolean)params.get("success");
        boolean bl = success = successObj != null && successObj != false;
        if (!success) {
            throw new StatusResponseException(TopLevelStatusCode.SUCCESS, "urn:oasis:names:tc:SAML:2.0:status:PartialLogout", "Unable to logout all local sessions.");
        }
    }

    @Override
    protected ConnectionBase getPartnerMetadata(InMessageContext inMsgCtx) {
        IdpConnection conn = MetadataSupport.getIdpConnection(inMsgCtx.getEntityId());
        this.profileProcessorMatrix.verifyProcessorEnablement(3, conn.getEnabledProfiles());
        return conn;
    }

    private void decryptNameID(ConnectionBase conn, LogoutRequestType logoutRequestType, String virtualServerId) {
        if (logoutRequestType.isSetEncryptedID()) {
            EncryptedElementType encryptedNameId = logoutRequestType.getEncryptedID();
            try {
                NameIDType nameId = this.encryptionEngine.decryptNameID(conn, encryptedNameId, virtualServerId);
                logoutRequestType.setNameID(nameId);
                logoutRequestType.unsetEncryptedID();
            }
            catch (XMLEncryptionException ex) {
                throw new ProcessRuntimeException("Unable to decrypt the NameID.", ex);
            }
            catch (NoEncryptionKeyException ex) {
                throw new ProcessRuntimeException("No decryption key to decrypt the NameID.", ex);
            }
        }
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }
}

