/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.AccountLinkingServiceException;

public class LinkingSupport {
    private static Log log = LogFactory.getLog(LinkingSupport.class);
    private static final String STORE_LINK_PATTERN = "Storing account link for localUserId={0} | idpEntityId={1} | authnAdapterId={2} | nameID={3}";
    private static final String LOOKUP_LINK_PATTERN = "Lookup account link returned localUserId={0} for idpEntityId={1} | authnAdapterId={2} | nameID={3}";
    private static final String TERM_LINK_PATTERN = "Terminate account link for  idpEntityId={0} | authnAdapterId={1} | nameID={2}";

    public static String lookupLink(String entityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        AccountLinkingService accountLinkService = LinkingSupport.getSvc();
        String localUserId = accountLinkService.lookupLink(entityId, authnAdapterId, externalIdentifier);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format(LOOKUP_LINK_PATTERN, localUserId, entityId, authnAdapterId, externalIdentifier));
        }
        return localUserId;
    }

    public static void storeLink(String localUserId, String entityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        AccountLinkingService accountLinkService = LinkingSupport.getSvc();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format(STORE_LINK_PATTERN, localUserId, entityId, authnAdapterId, externalIdentifier));
        }
        accountLinkService.storeLink(localUserId, entityId, authnAdapterId, externalIdentifier);
    }

    public static void terminateLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        AccountLinkingService accountLinkService = LinkingSupport.getSvc();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format(TERM_LINK_PATTERN, idpEntityId, authnAdapterId, externalIdentifier));
        }
        accountLinkService.terminateLink(idpEntityId, authnAdapterId, externalIdentifier);
    }

    private static AccountLinkingService getSvc() {
        AccountLinkingService accountLinkService = GlobalRegistry.getService(AccountLinkingService.class);
        return accountLinkService;
    }
}

