/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import com.pingidentity.common.mgr.ExpressionManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.PseudonymServiceException;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnContextType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnStatementType;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.OutMessageContextUtil;

public abstract class SpAdapterSupportBase {
    static Log log = LogFactory.getLog(SpAdapterSupportBase.class);

    protected abstract String getConnDefaultTargetResource(String var1, String var2);

    public SpHashableAuthnBean createAuthN(SsoContext ssoCtx, HttpServletRequest req, HttpServletResponse resp, TargetSessionId targetId, String resumePath, OutMessageContext ssoReqMsgCtx, InMessageContext ssoRespMsgCtx, IdpConnHashableAuthnBean idpConnBean) throws IOException, AuthnAdapterException {
        Serializable opaque = null;
        if (targetId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
            State state = ResumeRequestFromResponseSupport.getSupplementalFedHubState(ssoReqMsgCtx);
            if (state != null) {
                IdpConnection idpConn = MgmtFactory.getConnectionManager().getIdpConnection(ssoCtx.getIdpPartnerEntityId());
                AuthnSourceSupport idpAuthnSourceSupport = new AuthnSourceSupport();
                idpAuthnSourceSupport.setCookie(req, resp, state.getParameters(), new IdpConnAuthnSourceKey(idpConn.getId()));
                String requestedTargetResource = (String)state.getParameters().get("TARGET");
                if (requestedTargetResource != null) {
                    ssoCtx.setTargetResourceUrl(requestedTargetResource);
                }
            }
            opaque = this.invokeSpAdapter(ssoCtx, req, resp, targetId, resumePath);
        } else {
            this.invokeSpConnection(ssoCtx, req, resp, targetId, ssoReqMsgCtx, ssoRespMsgCtx, idpConnBean);
        }
        String sessionIdentifier = StateMgmtFactory.getLocalSessionId(req, resp);
        return new SpHashableAuthnBean(opaque, targetId, sessionIdentifier);
    }

    private Serializable invokeSpAdapter(SsoContext ssoCtx, HttpServletRequest req, HttpServletResponse resp, TargetSessionId targetId, String resumePath) throws IOException, AuthnAdapterException {
        Serializable opaque = null;
        String adapterId = targetId.getId();
        try {
            String connDefaultTargetUrl = this.getConnDefaultTargetResource(ssoCtx.getIdpPartnerEntityId(), adapterId);
            TargetResourceValidationMgr targetResourceValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
            targetResourceValidationMgr.validateTargetResourceSso(ssoCtx.getTargetResourceUrl(), connDefaultTargetUrl, "sp.after.sso");
        }
        catch (InvalidRedirectValidationException e) {
            throw new ProcessRuntimeException(e.getMessage());
        }
        SpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getSpAuthnAdapter(adapterId);
        try {
            opaque = adapter.createAuthN(ssoCtx, req, resp, resumePath);
        }
        catch (RuntimeException e) {
            throw SpAdapterSupportBase.makeAdapterEx(adapter, e);
        }
        catch (MalformedURLException mal) {
            throw SpAdapterSupportBase.makeAdapterEx(adapter, mal);
        }
        finally {
            HttpServletRespProxy.clearRunnable(resp);
        }
        return opaque;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeSpConnection(SsoContext ssoCtx, HttpServletRequest req, HttpServletResponse resp, TargetSessionId targetId, OutMessageContext ssoReqOutMsgCtx, InMessageContext ssoRespInMsgCtx, IdpConnHashableAuthnBean authnBean) throws IOException, AuthnAdapterException {
        Map<String, Object> stateParams;
        OutMessageContext respOutMsgCtx;
        InMessageContext reqInMsgCtx;
        State state = ResumeRequestFromResponseSupport.getSupplementalFedHubState(ssoReqOutMsgCtx);
        InMessageContext reqInMsgCtxForTransport = null;
        AuthnSourceSupport idpAuthnSourceSupport = new AuthnSourceSupport();
        boolean hasMessageCustomisation = false;
        if (state != null) {
            reqInMsgCtx = state.getInMsgCtx();
            respOutMsgCtx = state.getOutMsgCtx();
            stateParams = state.getParameters();
            if (reqInMsgCtx != null) {
                if (reqInMsgCtx.getBinding() == null) {
                    reqInMsgCtxForTransport = null;
                } else {
                    reqInMsgCtxForTransport = reqInMsgCtx;
                    String partnerEntityId = reqInMsgCtx.getEntityId();
                    SpConnection spConn = MgmtFactory.getConnectionManager().getSpConnection(partnerEntityId);
                    hasMessageCustomisation = this.hasMessageCustomisation(spConn);
                }
            }
        } else {
            SpConnection spConn = MgmtFactory.getConnectionManager().getSpConnection(targetId.getId());
            ProfileProcessorMatrix.getInstance().verifyProcessorEnablement(4, spConn.getEnabledProfiles());
            reqInMsgCtx = SpAdapterSupportBase.initTempInMsgCtxForFedHubUnsolicitedResp(targetId, spConn, ssoCtx.getTargetResourceUrl());
            respOutMsgCtx = SpAdapterSupportBase.initOutMsgCtxForFedHubUnsolicitedResp(reqInMsgCtx, spConn);
            stateParams = new HashMap<String, Object>();
            reqInMsgCtxForTransport = null;
            hasMessageCustomisation = this.hasMessageCustomisation(spConn);
        }
        IdpConnection idpConn = MgmtFactory.getConnectionManager().getIdpConnection(ssoCtx.getIdpPartnerEntityId());
        IdpConnAuthnSourceKey authnSourceKey = new IdpConnAuthnSourceKey(idpConn.getId());
        idpAuthnSourceSupport.afterInvokeAuthnSource(req, resp, authnSourceKey, authnBean, stateParams);
        AssertionType assertionType = ssoCtx.getSsoAssertion();
        List<String> authnAuthorities = (List<String>)stateParams.get("authnAuthorityEntityIds");
        authnAuthorities = SpAdapterSupportBase.retrieveAuthenticatingAuthorities(idpConn, assertionType, authnAuthorities, true);
        stateParams.put("authnAuthorityEntityIds", authnAuthorities);
        Map spLogContextCopy = ThreadContext.getContext();
        if (ResumeRequestFromResponseSupport.isAuthnSelectionInProgress(stateParams)) {
            SpAuditLogger.setEvent("SSO");
            SpAuditLogger.log("Authn Policy SP Event");
            String rrfrhClassName = (String)stateParams.get("OriginalResumeHandlerClassName");
            ResumeRequestFromAuthnResponseHandler resumeRequestFromAuthnResponseHandler = MetaDataFactory.getLocalMetaData().getProfileProcessFactory().getResumeRequestFromAuthnResponseHandler(rrfrhClassName);
            if (resumeRequestFromAuthnResponseHandler == null) throw new IllegalStateException("Unable to find the original handler to resume");
            String originalResumePath = (String)stateParams.get("authnPolicyInitialResumeUrl");
            StateSupport.overridePath(req, originalResumePath);
            stateParams.put("AuthnSelectionTreeIdpConnComplete", Boolean.TRUE);
            stateParams.put("AuthnSelectionTreeReturnedIdpConnAuthnBean", authnBean);
            this.saveMessageContextForMessageCustomization(req, ssoReqOutMsgCtx, ssoRespInMsgCtx, reqInMsgCtx, hasMessageCustomisation, true, stateParams);
            resumeRequestFromAuthnResponseHandler.resumeAuthn(reqInMsgCtx, req, resp, respOutMsgCtx, stateParams);
        } else {
            Object authnContext = ssoCtx.getAuthenticationContext();
            AttributeValue attributeValue = (AttributeValue)authnBean.getAuthnIdentifiersMap().get(AssertionMapKeys.getAuthnCtxKey());
            if (attributeValue != null) {
                authnContext = attributeValue.getValue();
            }
            if (ssoCtx.getSubjectAttrs() == null) {
                String msg = "Unable to map attributes from incoming assertion to APC";
                throw new ProcessRuntimeException(msg);
            }
            try {
                this.saveMessageContextForMessageCustomization(req, ssoReqOutMsgCtx, ssoRespInMsgCtx, reqInMsgCtx, hasMessageCustomisation, false, stateParams);
                IdpAuthenticationResult authnResult = new IdpAuthenticationResult(new IdpHashableAuthnBean[]{authnBean}, (AttributeMap)ssoCtx.getSubjectAttrs(), false, null);
                ResumeRequestFromAuthnResponseHandler reqHandler = ResumeRequestFromResponseSupport.createFedHubRequestHandler(respOutMsgCtx);
                reqHandler.resumeSsoFromIdp(authnResult, req, resp, reqInMsgCtx, respOutMsgCtx, stateParams, new AttributeValue((String)authnContext));
            }
            catch (PseudonymServiceException | RequestProcessingException e) {
                throw new AuthnAdapterException((Throwable)e);
            }
            finally {
                HttpServletRespProxy.clearRunnable(resp);
            }
            req.setAttribute("create.authn.complete", (Object)Boolean.TRUE);
        }
        for (Map.Entry entry : spLogContextCopy.entrySet()) {
            ThreadContext.put((String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
        try {
            bindingSvc.transportResponse(req, resp, reqInMsgCtxForTransport, respOutMsgCtx);
            return;
        }
        catch (Exception exception) {
            throw new AuthnAdapterException((Throwable)exception);
        }
    }

    private boolean hasMessageCustomisation(SpConnection spConn) {
        boolean hasMessageCustomisation = false;
        if (spConn != null && spConn.getMessageCustomizationHooks() != null) {
            hasMessageCustomisation = !spConn.getMessageCustomizationHooks().isEmpty();
        }
        return hasMessageCustomisation;
    }

    private void saveMessageContextForMessageCustomization(HttpServletRequest req, OutMessageContext ssoReqOutMsgCtx, InMessageContext ssoRespInMsgCtx, InMessageContext reqInMsgCtx, boolean hasMessageCustomisation, boolean saveAsState, Map<String, Object> stateParams) {
        if (ExpressionManager.getInstance().isEvaluateExpressionsOn() && hasMessageCustomisation) {
            if (saveAsState) {
                stateParams.put("FEDHUB_OUT_REQ_CONTEXT", ssoReqOutMsgCtx);
                stateParams.put("FEDHUB_IN_RESP_CONTEXT", ssoRespInMsgCtx);
                stateParams.put("FEDHUB_IN_REQ_CONTEXT", reqInMsgCtx);
            } else {
                req.setAttribute("FEDHUB_OUT_REQ_CONTEXT", (Object)ssoReqOutMsgCtx);
                req.setAttribute("FEDHUB_IN_RESP_CONTEXT", (Object)ssoRespInMsgCtx);
                req.setAttribute("FEDHUB_IN_REQ_CONTEXT", (Object)reqInMsgCtx);
            }
        }
    }

    public static List<String> retrieveAuthenticatingAuthorities(IdpConnection idpConn, AssertionType assertionType, List<String> authnAuthorities, boolean addIssuer) {
        AuthnContextType authnContextType;
        AuthnStatementType[] authnStatements;
        if (authnAuthorities == null) {
            authnAuthorities = new LinkedList<String>();
        }
        if (assertionType != null && (authnStatements = assertionType.getAuthnStatementArray()).length > 0 && (authnContextType = authnStatements[0].getAuthnContext()) != null) {
            for (String authnAuthority : authnContextType.getAuthenticatingAuthorityArray()) {
                authnAuthorities.add(authnAuthority);
            }
        }
        if (addIssuer) {
            authnAuthorities.add(idpConn.getEntityId());
        }
        return authnAuthorities;
    }

    private static OutMessageContext initOutMsgCtxForFedHubUnsolicitedResp(InMessageContext reqInMsgCtx, SpConnection spConn) {
        OutMessageContext outMsgCtx = null;
        switch (spConn.getProtocol()) {
            case SAML20: {
                outMsgCtx = OutMessageContextUtil.buildDefaultSaml20RespCtx(reqInMsgCtx, spConn);
                break;
            }
            case SAML10: 
            case SAML11: {
                outMsgCtx = OutMessageContextUtil.buildDefaultSaml1xRespCtx(reqInMsgCtx, spConn);
                break;
            }
            case WSFED: {
                throw new ProcessRuntimeException("The SP connection '" + spConn.getEntityId() + "' does not support IdP initiated SSO because it is configured for WS-Federation. WS-Federation only supports SP initiated SSO.");
            }
            default: {
                throw new ProcessRuntimeException("Unsupported protocol: " + spConn.getProtocol());
            }
        }
        return outMsgCtx;
    }

    private static InMessageContext initTempInMsgCtxForFedHubUnsolicitedResp(TargetSessionId targetId, SpConnection spConn, String targetResourceUrl) {
        InMessageContext inMsgCtx = new InMessageContext(Role.SP);
        inMsgCtx.setUnsolicitedResponse(true);
        inMsgCtx.setEntityId(targetId.getId());
        String virtualServerId = VirtualIdentityUtil.resolve(inMsgCtx).getVirtualEntityId(DomainMode.RUNTIME);
        inMsgCtx.setVirtualServerId(virtualServerId);
        Protocol protocol = spConn.getProtocol();
        if (protocol == Protocol.SAML20) {
            inMsgCtx.setRelayState(targetResourceUrl);
        } else if (protocol == Protocol.SAML10 || protocol == Protocol.SAML11) {
            inMsgCtx.setTargetResource(targetResourceUrl);
        }
        return inMsgCtx;
    }

    public static boolean isCreateAuthnComplete(HttpServletRequest req, HttpServletResponse resp) {
        return !resp.isCommitted() || SpAdapterSupportBase.isCreateCompleteReqAttrSet(req);
    }

    public static boolean isCreateCompleteReqAttrSet(HttpServletRequest req) {
        return req.getAttribute("create.authn.complete") != null;
    }

    private static AuthnAdapterException makeAdapterEx(SpAuthenticationAdapter adapter, RuntimeException e) {
        String adapterName = adapter.getClass().getSimpleName();
        return new AuthnAdapterException("Unexpected exception thrown from adapter " + adapterName, (Throwable)e);
    }

    private static AuthnAdapterException makeAdapterEx(SpAuthenticationAdapter adapter, MalformedURLException mal) {
        return new AuthnAdapterException("Unexpected Malformed URL Exception thrown from the adapter.  A possible cause is that there is no default target location specified for the SP Default URL.", (Throwable)mal);
    }

    public static boolean logoutAuthN(SpHashableAuthnBean authnBean, HttpServletRequest request, HttpServletResponse response, String resumePath) throws IOException, AuthnAdapterException {
        TargetSessionId targetId = authnBean.getTargetSessionId();
        if (targetId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
            SpAuthenticationAdapter spAuthenticationAdapter = MgmtFactory.getAdapterManager().getSpAuthnAdapter(targetId.getId());
            boolean success = false;
            try {
                success = spAuthenticationAdapter.logoutAuthN(authnBean.getOpaqueAuthnBean(), request, response, resumePath);
            }
            catch (RuntimeException e) {
                throw SpAdapterSupportBase.makeAdapterEx(spAuthenticationAdapter, e);
            }
            finally {
                HttpServletRespProxy.clearRunnable(response);
            }
            return success;
        }
        return true;
    }

    public static String lookupLocalId(HttpServletRequest req, HttpServletResponse resp, String adapterId, String entityId, String resumePath) throws IOException, AuthnAdapterException {
        SpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getSpAuthnAdapter(adapterId);
        String localId = null;
        try {
            localId = adapter.lookupLocalUserId(req, resp, entityId, resumePath);
        }
        catch (RuntimeException e) {
            throw SpAdapterSupportBase.makeAdapterEx(adapter, e);
        }
        finally {
            HttpServletRespProxy.clearRunnable(resp);
        }
        return localId;
    }
}

