/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.C2CMappingDb;
import org.sourceid.saml20.profiles.sp.UrlMatchingService;
import org.sourceid.saml20.service.TargetSessionId;

public class TargetUrlMappingUtil {
    private final UrlMatchingService urlMatchingService = GlobalRegistry.getService(UrlMatchingService.class);
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final SpAdapterManager adapterMgr = MgmtFactory.getSpAdapterManager();
    private final ConnectionManager connMgr = MgmtFactory.getConnectionManager();
    private final C2CMappingDb c2CMappingDb = MgmtFactory.getC2CMappingDb();

    public List<TargetSessionId> mapToTargetIds(String url) {
        TargetSessionId uniqueTarget = this.getUniqueTargetSessionId();
        if (uniqueTarget != null) {
            return Arrays.asList(uniqueTarget);
        }
        return this.mapToTargetIds(url, null, null);
    }

    public List<TargetSessionId> mapToTargetIds(String url, Set<TargetSessionId> allowedTargets, IdpConnection idpConnection) {
        LinkedList<TargetSessionId> targetIds = new LinkedList<TargetSessionId>();
        if (url != null) {
            for (UrlToTargetMapping map : this.localMetaData.getUrlToTargetMappings()) {
                SpConnection connection;
                if (!this.urlMatchingService.isMatch(map.getUrl(), url)) continue;
                if (map.getTargetType() == TargetSessionId.TargetSessionType.ADAPTER) {
                    String targetId = this.getTargetId(idpConnection, map);
                    TargetSessionId targetSessionId = new TargetSessionId(map.getTargetType(), targetId);
                    targetIds.add(targetSessionId);
                    continue;
                }
                if (!MetadataLocalHelper.isEnableFederationHub(this.localMetaData) || (connection = this.connMgr.getSpConnectionBySystemId(map.getTargetId())) == null) continue;
                String connEntityId = connection.getEntityId();
                if (!connection.isActive()) continue;
                TargetSessionId targetSessionId = new TargetSessionId(map.getTargetType(), connEntityId);
                targetIds.add(targetSessionId);
            }
        }
        if (allowedTargets != null) {
            Iterator targetIt = targetIds.iterator();
            while (targetIt.hasNext()) {
                TargetSessionId currTarget = (TargetSessionId)targetIt.next();
                if (allowedTargets.contains(currTarget)) continue;
                targetIt.remove();
            }
        }
        return targetIds;
    }

    private TargetSessionId getUniqueTargetSessionId() {
        Collection instances = this.adapterMgr.getInstances();
        boolean isFedHubEnabled = MetadataLocalHelper.isEnableFederationHub(this.localMetaData);
        if (!(instances.size() != 1 || isFedHubEnabled && this.c2CMappingDb.getActiveSpConnectionsWithC2CMappingsCount() != 0)) {
            return new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, ((AuthnAdapterInstance)instances.iterator().next()).getId());
        }
        if (instances.size() == 0 && isFedHubEnabled) {
            String firstSpConnectionRetrievedEntityId = this.c2CMappingDb.getFirstActiveSpConnectionEntityId();
            if (this.c2CMappingDb.getActiveSpConnectionsWithC2CMappingsCount() < 2 && firstSpConnectionRetrievedEntityId != null) {
                return new TargetSessionId(TargetSessionId.TargetSessionType.SP_CONN, firstSpConnectionRetrievedEntityId);
            }
        }
        return null;
    }

    private String getTargetId(IdpConnection idpConnection, UrlToTargetMapping map) {
        if (idpConnection != null) {
            AuthnAdapterInstance instance = (AuthnAdapterInstance)this.adapterMgr.getInstanceWithConnectionOverride(map.getTargetId(), idpConnection.getEntityId());
            return instance.getId();
        }
        return map.getTargetId();
    }
}

