/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import com.pingidentity.common.util.xml.XmlIDUtil;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.AttributeStatementTypeUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeStatementType;
import org.sourceid.saml20.xmlbinding.assertion.AudienceRestrictionType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnContextType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnStatementType;
import org.sourceid.saml20.xmlbinding.assertion.ConditionsType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectConfirmationDataType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectConfirmationType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;

public class AssertionTypeUtil {
    private static final AttributeStatementType[] EMPTY_ATTR_STMTS = new AttributeStatementType[0];
    private final ConfigStore config = ConfigStoreFarm.getConfig(AssertionTypeUtil.class.getName());
    private final int sessionLifeTimeInMinutes = this.config.getIntValue("SessionLifeTimeInMinutes", 0);

    public AssertionType getTemplateAssertion(String issuer) {
        AssertionType assertionType = AssertionType.Factory.newInstance();
        this.setDefaults(issuer, assertionType);
        return assertionType;
    }

    public void setDefaults(String issuer, AssertionType assertion) {
        this.setDefaultAttributes(assertion);
        this.setIssuer(issuer, assertion);
    }

    public void setDefaultAttributes(AssertionType assertion) {
        assertion.setID(XmlIDUtil.createID());
        assertion.setIssueInstant(Util.getUtcCalendar());
        assertion.setVersion("2.0");
    }

    public void setIssuer(String entityId, AssertionType assertion) {
        NameIDType issuer = assertion.getIssuer();
        if (issuer == null) {
            issuer = assertion.addNewIssuer();
        }
        issuer.setStringValue(entityId);
    }

    public void setSubject(String nameIdFormat, String nameQualifier, String nameId, String spQualifier, AssertionType assertion) {
        SubjectType subject = assertion.getSubject();
        if (subject == null) {
            subject = assertion.addNewSubject();
        }
        this.setNameId(nameIdFormat, nameQualifier, nameId, spQualifier, subject);
    }

    public void setSubject(SubjectType subject, AssertionType assertion) {
        if (subject != null) {
            assertion.setSubject(subject);
        }
    }

    public void setSubject(String nameId, AssertionType assertion) {
        this.setSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", null, nameId, null, assertion);
    }

    public void setSubject(String nameQualifier, String nameId, AssertionType assertion) {
        this.setSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", nameQualifier, nameId, null, assertion);
    }

    private void setNameId(String format, String qualifier, String nameId, String spQualifier, SubjectType subject) {
        NameIDType name = subject.getNameID();
        if (name == null) {
            name = subject.addNewNameID();
        }
        if (!StringUtils.isBlank((String)format)) {
            name.setFormat(format);
        } else if (name.isSetFormat()) {
            name.unsetFormat();
        }
        if (!StringUtils.isBlank((String)qualifier)) {
            name.setNameQualifier(qualifier);
        } else if (name.isSetNameQualifier()) {
            name.unsetNameQualifier();
        }
        if (!StringUtils.isBlank((String)spQualifier)) {
            name.setSPNameQualifier(spQualifier);
        } else if (name.isSetSPNameQualifier()) {
            name.unsetSPNameQualifier();
        }
        name.setStringValue(nameId);
    }

    public void setSubjConf(String method, SubjectType subjectType) {
        SubjectConfirmationType subjectConfirmationType = subjectType.addNewSubjectConfirmation();
        subjectConfirmationType.setMethod(method);
    }

    public void setSubjConfHolderOfKey(KeyInfoType keyInfo, SubjectType subject) {
        SubjectConfirmationDataType subjectConfData = subject.getSubjectConfirmationArray()[0].addNewSubjectConfirmationData();
        subjectConfData.set((XmlObject)keyInfo);
    }

    public void setSubjConf(String method, String recipient, String inRespTo, SubjectType subjectType, Calendar notOnOrAfter) {
        SubjectConfirmationType subjectConfirmationType = subjectType.addNewSubjectConfirmation();
        subjectConfirmationType.setMethod(method);
        SubjectConfirmationDataType subjectConfDataType = subjectConfirmationType.addNewSubjectConfirmationData();
        subjectConfDataType.setRecipient(recipient);
        subjectConfDataType.setNotOnOrAfter(notOnOrAfter);
        if (inRespTo != null) {
            subjectConfDataType.setInResponseTo(inRespTo);
        }
    }

    public void setConditions(String audience, int minBefore, int minAfter, AssertionType assertion) {
        ConditionsType conditions = assertion.getConditions();
        if (conditions == null) {
            conditions = assertion.addNewConditions();
        }
        Calendar now = Util.getUtcCalendar();
        Calendar notBefore = (Calendar)now.clone();
        Calendar notAfter = (Calendar)now.clone();
        notBefore.add(12, -1 * minBefore);
        notAfter.add(12, minAfter);
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notAfter);
        if (audience != null) {
            this.setAudienceRestriction(audience, conditions);
        }
    }

    public void addAuthnStmt(Calendar authnInst, String authnCtxClassRef, List<String> authnAuthorities, AssertionType assertionType) {
        AuthnStatementType authnStatementType = assertionType.addNewAuthnStatement();
        String assertionId = assertionType.getID();
        ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        authnStatementType.setSessionIndex(assertionId);
        TrackingIdSupport.addReference(assertionId);
        if (this.sessionLifeTimeInMinutes > 0) {
            Calendar sessionNotOnOrAfter = Util.getUtcCalendar();
            sessionNotOnOrAfter.add(12, this.sessionLifeTimeInMinutes);
            authnStatementType.setSessionNotOnOrAfter(sessionNotOnOrAfter);
        }
        authnStatementType.setAuthnInstant(authnInst);
        AuthnContextType authnContextType = authnStatementType.addNewAuthnContext();
        authnContextType.setAuthnContextClassRef(authnCtxClassRef);
        if (authnAuthorities != null && !authnAuthorities.isEmpty()) {
            for (String authenticatingAuthority : authnAuthorities) {
                authnContextType.addAuthenticatingAuthority(authenticatingAuthority);
            }
        }
    }

    private void setAudienceRestriction(String audience, ConditionsType conditions) {
        AudienceRestrictionType audienceRestriction = conditions.addNewAudienceRestriction();
        audienceRestriction.addAudience(audience);
    }

    public String getAudience(AssertionType assertionType) {
        ConditionsType conditions = assertionType.getConditions();
        AudienceRestrictionType audienceRestrictionArray = conditions.getAudienceRestrictionArray(0);
        return audienceRestrictionArray.getAudienceArray(0);
    }

    public boolean hasOneTimeUseAssertion(Collection<AssertionType> assertions) {
        for (AssertionType assertionType : assertions) {
            ConditionsType conditions = assertionType.getConditions();
            if (conditions.sizeOfOneTimeUseArray() <= 0) continue;
            return true;
        }
        return false;
    }

    public Calendar getSubjectConfNotOnOrAfter(AssertionType assertionType) {
        SubjectConfirmationDataType subjectConfirmationData;
        SubjectConfirmationType subjectConfirmation;
        SubjectType subject = assertionType.getSubject();
        if (subject.sizeOfSubjectConfirmationArray() > 0 && (subjectConfirmation = subject.getSubjectConfirmationArray(0)).isSetSubjectConfirmationData() && (subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData()).isSetNotOnOrAfter()) {
            return subjectConfirmationData.getNotOnOrAfter();
        }
        return null;
    }

    public String getSessionIndex(AssertionType assertionType) {
        AuthnStatementType authnStatement;
        if (assertionType.sizeOfAuthnStatementArray() > 0 && (authnStatement = assertionType.getAuthnStatementArray(0)).isSetSessionIndex()) {
            return authnStatement.getSessionIndex();
        }
        return null;
    }

    public String getNameIdValue(AssertionType assertionType) {
        SubjectType subject;
        if (assertionType.isSetSubject() && (subject = assertionType.getSubject()).isSetNameID()) {
            NameIDType nameID = subject.getNameID();
            return nameID.getStringValue();
        }
        return null;
    }

    public String getIssuer(AssertionType assertionType) {
        return assertionType.getIssuer().getStringValue();
    }

    public void addAttributeStatement(AttributeMap values, ConnectionBase connection, AssertionType assertionType) throws StatusResponseException {
        if (!values.isEmpty()) {
            AttributeStatementType attributeStatement = assertionType.addNewAttributeStatement();
            EncryptionPolicy encryptionPolicy = null;
            AttributeContract attributeContract = null;
            if (connection != null) {
                encryptionPolicy = connection.getEncryptionSettings().getEncryptionPolicy();
                attributeContract = connection.getAttributeContract();
            }
            for (Map.Entry e : values.entrySet()) {
                String key = (String)e.getKey();
                AttributeValue val = (AttributeValue)e.getValue();
                if (val == null) continue;
                if (encryptionPolicy != null && encryptionPolicy.wantToEncryptAttribute(key)) {
                    AttributeStatementTypeUtil.addEncryptedBasicAttribute(connection, key, val, attributeStatement);
                    continue;
                }
                if (attributeContract != null) {
                    String attributeNameFormat = attributeContract.getMutableAttributeNameFormat(key);
                    AttributeStatementTypeUtil.addBasicAttribute(key, val, attributeNameFormat, attributeStatement);
                    continue;
                }
                AttributeStatementTypeUtil.addBasicAttribute(key, val, attributeStatement);
            }
            if (attributeStatement.sizeOfAttributeArray() == 0 && attributeStatement.sizeOfEncryptedAttributeArray() == 0) {
                assertionType.setAttributeStatementArray(EMPTY_ATTR_STMTS);
            }
        }
    }

    public void addAttributeStatement(AttributeMap values, AssertionType assertionType) {
        try {
            this.addAttributeStatement(values, null, assertionType);
        }
        catch (StatusResponseException statusResponseException) {
            // empty catch block
        }
    }
}

