/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.xmlbinding.assertion.AttributeDocument;
import org.sourceid.saml20.xmlbinding.assertion.AttributeStatementType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;

public class AttributeStatementTypeUtil {
    private static final String MSG_ERROR_ATTRIBUTE_ENCRYPTION = "Unable to encrypt Attribute.";
    private static EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);

    public static void addBasicAttribute(String name, AttributeValue value, AttributeStatementType attributeStmtType) {
        AttributeStatementTypeUtil.addBasicAttribute(name, value, null, attributeStmtType);
    }

    public static void addBasicAttribute(String name, AttributeValue value, String attributeNameFormat, AttributeStatementType attributeStmtType) {
        if (name != null && value != null) {
            AttributeType attributeType = attributeStmtType.addNewAttribute();
            AttributeStatementTypeUtil.setAttrNV(attributeType, name, value, attributeNameFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AttributeValue getBasicAttributeValues(AttributeType attributeType) {
        ArrayList<String> values = new ArrayList<String>(attributeType.sizeOfAttributeValueArray());
        for (XmlObject attrValue : attributeType.getAttributeValueArray()) {
            XmlCursor xmlCursor = null;
            try {
                xmlCursor = attrValue.newCursor();
                values.add(xmlCursor.getTextValue());
            }
            finally {
                XmlBeansUtil.disposeCursor(xmlCursor);
            }
        }
        return new AttributeValue(values);
    }

    public static void addEncryptedBasicAttribute(ConnectionBase connection, String name, AttributeValue value, AttributeStatementType attributeStmtType) throws StatusResponseException {
        AttributeDocument attribDoc = AttributeDocument.Factory.newInstance();
        AttributeType attributeType = attribDoc.addNewAttribute();
        AttributeContract attributeContract = connection.getAttributeContract();
        String attributeNameFormat = null;
        if (attributeContract != null) {
            attributeNameFormat = attributeContract.getMutableAttributeNameFormat(value.getValue());
        }
        AttributeStatementTypeUtil.setAttrNV(attributeType, name, value, attributeNameFormat);
        try {
            EncryptedElementType encryptedElement = encryptionEngine.encryptAttribute(connection, attributeType);
            attributeStmtType.addNewEncryptedAttribute().set((XmlObject)encryptedElement);
        }
        catch (XMLEncryptionException ex) {
            TopLevelStatusCode responder = TopLevelStatusCode.RESPONDER;
            throw new StatusResponseException(responder, MSG_ERROR_ATTRIBUTE_ENCRYPTION);
        }
        catch (NoSuchAlgorithmException ex) {
            TopLevelStatusCode responder = TopLevelStatusCode.RESPONDER;
            throw new StatusResponseException(responder, MSG_ERROR_ATTRIBUTE_ENCRYPTION);
        }
        catch (NoEncryptionKeyException ex) {
            TopLevelStatusCode responder = TopLevelStatusCode.RESPONDER;
            throw new StatusResponseException(responder, ex.getMessage());
        }
    }

    private static void setAttrNV(AttributeType attributeType, String name, AttributeValue value, String attributeNameFormat) {
        attributeType.setName(name);
        if (attributeNameFormat != null) {
            attributeType.setNameFormat(attributeNameFormat);
        } else {
            attributeType.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        }
        for (String s : value.getValues()) {
            AttributeStatementTypeUtil.addValue(s, attributeType);
        }
    }

    private static void addValue(String value, AttributeType attributeType) {
        if (value != null) {
            XmlString xmlString = XmlString.Factory.newInstance();
            xmlString.setStringValue(value);
            attributeType.addNewAttributeValue().set((XmlObject)xmlString);
        }
    }
}

