/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.protocol.RequestAbstractTypeUtil;
import org.sourceid.saml20.xmlbinding.protocol.AuthnContextComparisonType;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestType;
import org.sourceid.saml20.xmlbinding.protocol.IDPEntryType;
import org.sourceid.saml20.xmlbinding.protocol.IDPListType;
import org.sourceid.saml20.xmlbinding.protocol.NameIDPolicyType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.RequestedAuthnContextType;
import org.sourceid.saml20.xmlbinding.protocol.ScopingType;

public class AuthnRequestUtil {
    public static AuthnRequestDocument createBasicAuthnRequest(String issuer, boolean forceAuthn, boolean isPassive) {
        AuthnRequestDocument authnRequestDocument = AuthnRequestDocument.Factory.newInstance();
        AuthnRequestType authnRequestType = authnRequestDocument.addNewAuthnRequest();
        RequestAbstractTypeUtil.setDefaults((RequestAbstractType)authnRequestType, issuer);
        if (forceAuthn) {
            authnRequestType.setForceAuthn(forceAuthn);
        }
        if (isPassive) {
            authnRequestType.setIsPassive(isPassive);
        }
        return authnRequestDocument;
    }

    public static void setNameIDPolicy(AuthnRequestType authnReq, boolean allowCreate, String format, String spNameQual) {
        if (allowCreate || !StringUtils.isBlank((String)format) || !StringUtils.isBlank((String)spNameQual)) {
            NameIDPolicyType nameIDPolicyType = authnReq.addNewNameIDPolicy();
            nameIDPolicyType.setAllowCreate(allowCreate);
            if (!StringUtils.isBlank((String)format)) {
                nameIDPolicyType.setFormat(format);
            }
            if (!StringUtils.isBlank((String)spNameQual)) {
                nameIDPolicyType.setSPNameQualifier(spNameQual);
            }
        }
    }

    public static void setRequestedAuthnCtx(AuthnRequestType authnReq, String[] authnCtxClassRefs, String[] authnCtxDeclRefs, AuthnContextComparisonType.Enum comparisonMethod) {
        AuthnRequestUtil.setRequestedAuthnCtx(authnReq, AuthnContextType.AuthnContextClassRef, authnCtxClassRefs, comparisonMethod);
        AuthnRequestUtil.setRequestedAuthnCtx(authnReq, AuthnContextType.AuthnContextDeclRef, authnCtxDeclRefs, comparisonMethod);
    }

    private static void setRequestedAuthnCtx(AuthnRequestType authnReq, AuthnContextType ctxType, String[] authnCtxs, AuthnContextComparisonType.Enum comparisonMethod) {
        if (authnCtxs != null) {
            boolean comparisonSet = false;
            for (String actx : authnCtxs) {
                if (StringUtils.isBlank((String)actx)) continue;
                RequestedAuthnContextType reqAuthnCtx = null;
                reqAuthnCtx = authnReq.isSetRequestedAuthnContext() ? authnReq.getRequestedAuthnContext() : authnReq.addNewRequestedAuthnContext();
                if (ctxType == AuthnContextType.AuthnContextClassRef) {
                    reqAuthnCtx.addAuthnContextClassRef(actx);
                } else if (ctxType == AuthnContextType.AuthnContextDeclRef) {
                    reqAuthnCtx.addAuthnContextDeclRef(actx);
                }
                if (comparisonMethod == null || comparisonSet) continue;
                reqAuthnCtx.setComparison(comparisonMethod);
                comparisonSet = true;
            }
        }
    }

    public static void setScoping(AuthnRequestType authnRequestType, Collection<String> authenticatingIdpIds, Integer proxyCount, List<String> requesterIds) {
        if (authenticatingIdpIds != null || proxyCount != null || requesterIds != null) {
            ScopingType scopingType = authnRequestType.addNewScoping();
            if (authenticatingIdpIds != null) {
                IDPListType idpList = scopingType.addNewIDPList();
                for (String authenticatingIdpId : authenticatingIdpIds) {
                    if (StringUtils.isBlank((String)authenticatingIdpId)) continue;
                    IDPEntryType idpEntry = idpList.addNewIDPEntry();
                    idpEntry.setProviderID(authenticatingIdpId);
                }
            }
            if (proxyCount != null) {
                scopingType.setProxyCount(BigInteger.valueOf(proxyCount.intValue()));
            }
            if (requesterIds != null) {
                for (String requesterId : requesterIds) {
                    scopingType.addRequesterID(requesterId);
                }
            }
        }
    }

    public static void setSubject(AuthnRequestType authnRequestType, String requestedUserId) {
        if (StringUtils.isBlank((String)requestedUserId)) {
            return;
        }
        authnRequestType.addNewSubject().addNewNameID().setStringValue(requestedUserId);
    }

    static enum AuthnContextType {
        AuthnContextClassRef,
        AuthnContextDecl,
        AuthnContextDeclRef,
        AuthenticatingAuthority;

    }
}

