/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import com.pingidentity.common.util.xml.XPathUtil;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.protocol.samlp11.xml.RequestType;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;

public class GeneralXmlUtil {
    private static final String ISSUER_XPATH = "declare namespace saml='urn:oasis:names:tc:SAML:2.0:assertion' .//saml:Issuer";

    public static boolean isRequest(XmlObject document) {
        XmlObject xmlObjectType = XmlBeansUtil.unwrapDocumentToType(document);
        return xmlObjectType instanceof RequestAbstractType || xmlObjectType instanceof RequestType;
    }

    public static Calendar getIssueInstant(XmlObject document) {
        Calendar issueInstant = null;
        XmlObject xmlObjectType = XmlBeansUtil.unwrapDocumentToType(document);
        if (xmlObjectType instanceof RequestAbstractType) {
            RequestAbstractType requestAbstractType = (RequestAbstractType)xmlObjectType;
            issueInstant = requestAbstractType.getIssueInstant();
        } else if (xmlObjectType instanceof StatusResponseType) {
            StatusResponseType statusResponseType = (StatusResponseType)xmlObjectType;
            issueInstant = statusResponseType.getIssueInstant();
        } else if (xmlObjectType instanceof ResponseType) {
            ResponseType responseType = (ResponseType)xmlObjectType;
            issueInstant = responseType.getIssueInstant();
        }
        return issueInstant;
    }

    public static String getIssuer(XmlObject document) {
        StatusResponseType statusResponseType;
        String issuer = null;
        XmlObject xmlObjectType = XmlBeansUtil.unwrapDocumentToType(document);
        if (xmlObjectType instanceof RequestAbstractType) {
            RequestAbstractType requestAbstractType = (RequestAbstractType)xmlObjectType;
            issuer = GeneralXmlUtil.getIssuerNameId(requestAbstractType.getIssuer());
        } else if (xmlObjectType instanceof StatusResponseType && (issuer = GeneralXmlUtil.getIssuerNameId((statusResponseType = (StatusResponseType)xmlObjectType).getIssuer())) == null) {
            NameIDType nameIDType = XPathUtil.selectFirst(document, ISSUER_XPATH, NameIDType.class, "issuer");
            issuer = GeneralXmlUtil.getIssuerNameId(nameIDType);
        }
        return issuer;
    }

    private static String getIssuerNameId(NameIDType issuerNameId) {
        return issuerNameId != null ? issuerNameId.getStringValue() : null;
    }

    public static String getDestination(XmlObject document) {
        StatusResponseType statusResponseType;
        String destination = null;
        XmlObject xmlObjectType = XmlBeansUtil.unwrapDocumentToType(document);
        if (xmlObjectType instanceof RequestAbstractType) {
            RequestAbstractType requestAbstractType = (RequestAbstractType)xmlObjectType;
            if (requestAbstractType.isSetDestination()) {
                destination = requestAbstractType.getDestination();
            }
        } else if (xmlObjectType instanceof StatusResponseType && (statusResponseType = (StatusResponseType)xmlObjectType).isSetDestination()) {
            destination = statusResponseType.getDestination();
        }
        return destination;
    }

    public static void setDestination(XmlObject document, String endpoint) {
        XmlObject xmlObjectType = XmlBeansUtil.unwrapDocumentToType(document);
        if (xmlObjectType instanceof RequestAbstractType) {
            RequestAbstractType requestAbstractType = (RequestAbstractType)xmlObjectType;
            requestAbstractType.setDestination(endpoint);
        } else if (xmlObjectType instanceof StatusResponseType) {
            StatusResponseType statusResponseType = (StatusResponseType)xmlObjectType;
            statusResponseType.setDestination(endpoint);
        }
    }
}

