/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SamlNameID;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.BindingEndptChooser;
import org.sourceid.saml20.profiles.PartnerSessionGroup;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.protocol.RequestAbstractTypeUtil;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.util.NameIdHashKey;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.w3c.dom.Node;

public class SingleLogoutUtil {
    private static final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();
    private static final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);
    private static final Log log = LogFactory.getLog(SingleLogoutUtil.class);

    public static OutMessageContext createLogoutRequestMsgCtx(HttpServletRequest req, PartnerSessionGroup session, boolean inIdpRole, String binding) {
        if (session == null) {
            throw new ProcessRuntimeException("Failed to get partner session information");
        }
        Role partnerRole = inIdpRole ? Role.SP : Role.IDP;
        OutMessageContext outMsgCtx = new OutMessageContext(partnerRole);
        LogoutRequestDocument logoutRequestDoc = SingleLogoutUtil.createLogoutRequestDoc(req, session, inIdpRole);
        outMsgCtx.setXmlObject((XmlObject)logoutRequestDoc);
        String entityId = session.getEntityId();
        outMsgCtx.setEntityId(entityId);
        outMsgCtx.setVirtualServerId(session.getVirtualServerId());
        SingleLogoutUtil.setBindingInfo(outMsgCtx, inIdpRole, binding);
        return outMsgCtx;
    }

    private static void setBindingInfo(OutMessageContext outMsgCtx, boolean inIdpRole, String binding) {
        ConnectionBase partnerEntityConnection;
        String entityId = outMsgCtx.getEntityId();
        if (inIdpRole) {
            partnerEntityConnection = MetadataSupport.getSpConnection(entityId);
            profileProcessorMatrix.verifyProcessorEnablement(5, partnerEntityConnection.getEnabledProfiles());
        } else {
            partnerEntityConnection = MetadataSupport.getIdpConnection(entityId);
            profileProcessorMatrix.verifyProcessorEnablement(1, partnerEntityConnection.getEnabledProfiles());
        }
        Endpoint endpoint = partnerEntityConnection.getPreferredSingleLogoutService();
        outMsgCtx.setBinding(endpoint.getBinding());
        outMsgCtx.setEndpoint(endpoint.getFullLocation());
        EndpointGroup singleLogoutServices = partnerEntityConnection.getSingleLogoutServices();
        BindingEndptChooser.doCheckBindingOverride(binding, (Endpoints)singleLogoutServices, outMsgCtx, "SLO");
    }

    public static LogoutRequestDocument createLogoutRequestDoc(PartnerSessionGroup session, ConnectionBase connectionBase) {
        LogoutRequestDocument logoutRequestDoc = LogoutRequestDocument.Factory.newInstance();
        LogoutRequestType logoutRequestType = logoutRequestDoc.addNewLogoutRequest();
        String virtualServerId = session.getVirtualServerId();
        RequestAbstractTypeUtil.setDefaults((RequestAbstractType)logoutRequestType, virtualServerId);
        for (String sessionIndex : session.getSessionIndices()) {
            if (sessionIndex == null) continue;
            logoutRequestType.addSessionIndex(sessionIndex);
            TrackingIdSupport.addReference(sessionIndex);
        }
        SamlNameID nameID = session.getNameId();
        if (nameID == null) {
            String msg = "NameID was not present in the assertion, therefore SLO cannot proceed.";
            log.error((Object)msg);
            throw new ProcessRuntimeException(msg);
        }
        NameIDDocument nameIDDocument = NameIDDocument.Factory.newInstance();
        nameIDDocument.setNameID(nameID.getNameIDType());
        try {
            nameIDDocument = XmlBeansUtil.canonicalize(nameIDDocument, NameIDDocument.class);
        }
        catch (XmlException e) {
            log.error((Object)"Unexpected problem trying to canonicalize name id - proceeding with unc14ned name id.", (Throwable)e);
        }
        EncryptedElementType encryptedElementType = null;
        if (connectionBase.getRoleType() == Role.SP) {
            SpConnection spConnection = (SpConnection)connectionBase;
            Calendar logoutNotOnOrAfter = Util.getUtcCalendar();
            logoutNotOnOrAfter.add(12, spConnection.getAssertionValidityAfterMinutes());
            logoutRequestType.setNotOnOrAfter(logoutNotOnOrAfter);
            EncryptionPolicy encryptionPolicy = spConnection.getEncryptionSettings().getEncryptionPolicy();
            if (encryptionPolicy.isSloEncryptSubjectNameID()) {
                encryptedElementType = SingleLogoutUtil.encryptNameID(nameIDDocument, spConnection);
            }
        } else {
            IdpConnection idpConnection = (IdpConnection)connectionBase;
            if (idpConnection.getEncryptionSettings().getEncryptionPolicy().isSloEncryptSubjectNameID()) {
                encryptedElementType = SingleLogoutUtil.encryptNameID(nameIDDocument, idpConnection);
            }
        }
        if (encryptedElementType == null) {
            logoutRequestType.addNewNameID().set((XmlObject)nameIDDocument.getNameID());
        } else {
            logoutRequestType.setEncryptedID(encryptedElementType);
        }
        try {
            Node node = XmlBeansUtil.parseToNode(logoutRequestDoc.newInputStream());
            return LogoutRequestDocument.Factory.parse((Node)node);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected problem serializing and re-parsing logout request document.", (Throwable)e);
            return logoutRequestDoc;
        }
    }

    public static LogoutRequestDocument createLogoutRequestDoc(HttpServletRequest request, PartnerSessionGroup session, boolean inIdpRole) {
        ConnectionBase connectionBase = inIdpRole ? MetadataSupport.getSpConnection(session.getEntityId()) : MetadataSupport.getIdpConnection(session.getEntityId());
        return SingleLogoutUtil.createLogoutRequestDoc(session, connectionBase);
    }

    private static EncryptedElementType encryptNameID(NameIDDocument nameIdDoc, ConnectionBase connection) {
        try {
            return encryptionEngine.encryptNameID(connection, nameIdDoc.getNameID());
        }
        catch (Exception ex) {
            log.error((Object)"Unable to encrypt NameID for SLO.", (Throwable)ex);
            return null;
        }
    }

    public static Collection<PartnerSessionGroup> groupAndFilterSessions(Collection<WebSsoSession> sessions) {
        return SingleLogoutUtil.filterSessionGroups(SingleLogoutUtil.groupSessions(sessions));
    }

    public static Collection<PartnerSessionGroup> groupSessions(Collection<WebSsoSession> sessions) {
        HashMap<NameIdVsidHashKey, PartnerSessionGroup> temp = new HashMap<NameIdVsidHashKey, PartnerSessionGroup>();
        for (WebSsoSession session : sessions) {
            NameIdHashKey nameIdHashKey = new NameIdHashKey(session.getEntityId(), session.getNameId());
            NameIdVsidHashKey groupingKey = new NameIdVsidHashKey(nameIdHashKey, session.getVirtualServerId());
            PartnerSessionGroup multiSession = (PartnerSessionGroup)temp.get(groupingKey);
            if (multiSession == null) {
                multiSession = new PartnerSessionGroup(session);
                temp.put(groupingKey, multiSession);
            }
            multiSession.addSessionIndex(session.getSessionIndex());
        }
        return temp.values();
    }

    public static Collection<PartnerSessionGroup> filterSessionGroups(Collection<PartnerSessionGroup> sessionGroups) {
        ArrayList<PartnerSessionGroup> result = new ArrayList<PartnerSessionGroup>();
        for (PartnerSessionGroup sessionGroup : sessionGroups) {
            SpConnection spConn = MgmtFactory.getMetadataDirectory().getSpConnection(sessionGroup.getEntityId(), true);
            if (spConn.getEnabledProfiles().isIdpInitiatedSLOEnabled()) {
                result.add(sessionGroup);
                continue;
            }
            IdpSessionRegistrySupport.unregisterSessions(sessionGroup.getSessionIndices());
        }
        return result;
    }

    private static class NameIdVsidHashKey {
        private NameIdHashKey nameIdHashKey;
        private String vsid;

        public NameIdVsidHashKey(NameIdHashKey nameIdHashKey, String vsid) {
            this.nameIdHashKey = nameIdHashKey;
            this.vsid = vsid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nameIdHashKey == null ? 0 : this.nameIdHashKey.hashCode());
            result = 31 * result + (this.vsid == null ? 0 : this.vsid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameIdVsidHashKey other = (NameIdVsidHashKey)obj;
            if (this.nameIdHashKey == null ? other.nameIdHashKey != null : !this.nameIdHashKey.equals(other.nameIdHashKey)) {
                return false;
            }
            return !(this.vsid == null ? other.vsid != null : !this.vsid.equals(other.vsid));
        }
    }
}

