/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.StatementAbstractType;

public class ValidateAssertionHasSubjectStatements {
    private boolean requireStatements = true;

    public void validate(Assertion assertion) {
        boolean hasAuthzStmts;
        AssertionType assertionType = assertion.getAssertionType();
        boolean hasAuthnStmts = assertionType.sizeOfAuthnStatementArray() > 0;
        boolean hasAttrStmts = assertionType.sizeOfAttributeStatementArray() > 0;
        boolean bl = hasAuthzStmts = assertionType.sizeOfAuthzDecisionStatementArray() > 0;
        if (hasAuthnStmts || hasAttrStmts || hasAuthzStmts) {
            if (!assertionType.isSetSubject()) {
                assertion.addInvalidRemark("(Core 2.7.2, 2.7.3 and 2.7.4) Assertion contains statements but does not contain a subject element.");
            }
        } else {
            int sizeOfStmtsArray = assertionType.sizeOfStatementArray();
            if (sizeOfStmtsArray > 0) {
                ArrayList<QName> funkyStmts = new ArrayList<QName>(sizeOfStmtsArray);
                for (StatementAbstractType stmt : assertionType.getStatementArray()) {
                    funkyStmts.add(stmt.schemaType().getName());
                }
                String s = ((Object)funkyStmts).toString();
                assertion.addInvalidRemark("Assertion contains only statements that are not understood: " + s);
            } else if (this.requireStatements) {
                assertion.addInvalidRemark("Assertion contains no statements.");
            }
        }
    }

    public void setRequireStatements(boolean requireStatements) {
        this.requireStatements = requireStatements;
    }
}

