/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;

public class ValidateAssertionIssuerNameId {
    public void validate(Assertion assertion) {
        AssertionType assertionType = assertion.getAssertionType();
        NameIDType issuer = assertionType.getIssuer();
        if (issuer.isSetFormat() && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            assertion.addInvalidRemark("(Profiles 4.1.4.2) Issuer format not 'entity': " + issuer.getFormat());
        }
        if (issuer.isSetNameQualifier() || issuer.isSetSPNameQualifier() || issuer.isSetSPProvidedID()) {
            assertion.addInvalidRemark("(Core 8.3.6) The NameQualifier, SPNameQualifier, and SPProvidedID attributes MUST be omitted.");
        }
    }
}

