/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.wrapper.Assertion;

public class ValidateAssertionSignature {
    public SignatureStatus validate(Assertion assertion) {
        return this.validate(assertion, false);
    }

    public SignatureStatus validate(Assertion assertion, boolean signatureAlreadyValidated) {
        if (signatureAlreadyValidated) {
            return SignatureStatus.VALID;
        }
        SignatureEngine signatureEngine = GlobalRegistry.getService(SignatureEngine.class);
        SignatureResult signatureResult = signatureEngine.verifyAssertionSignature(assertion.getAssertionType());
        SignatureStatus signatureStatus = signatureResult.getStatus();
        if (signatureStatus == SignatureStatus.INVALID || signatureStatus == SignatureStatus.UNVERIFIED) {
            assertion.addInvalidRemark("Signature was " + signatureStatus);
        }
        return signatureStatus;
    }
}

