/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.util.List;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.encryption.EncryptionSupport;
import org.sourceid.saml20.protocol.ValidateAssertionConditions;
import org.sourceid.saml20.protocol.ValidateAssertionHasSubjectStatements;
import org.sourceid.saml20.protocol.ValidateAssertionIssuerNameId;
import org.sourceid.saml20.protocol.ValidateAssertionSignature;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseType;
import org.sourceid.websso.profiles.InvalidGeneralResponseException;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.wrapper.InMessageContext;

public class ValidateAttQueryResp {
    private final ValidateAssertionSignature validateAssertionSignature = new ValidateAssertionSignature();
    private final ValidateAssertionConditions validateAssertionConditions = new ValidateAssertionConditions();
    private final ValidateAssertionIssuerNameId validateAssertionIssuerNameId = new ValidateAssertionIssuerNameId();
    private final ValidateAssertionHasSubjectStatements validateAssertionHasSubjectStmts = new ValidateAssertionHasSubjectStatements();

    public ValidateAttQueryResp() {
        this.validateAssertionConditions.setRequireAudienceRestriction(false);
    }

    public Assertion validate(ResponseDocument respDoc, IdpConnection idp, String localEntityId, InMessageContext respMsgCtx) throws InvalidResponseException {
        StringBuilder sb;
        Assertion assertion;
        int numEncAssertions;
        ResponseType responseType = respDoc.getResponse();
        int numAssertions = responseType.sizeOfAssertionArray();
        int totalAssertions = numAssertions + (numEncAssertions = responseType.sizeOfEncryptedAssertionArray());
        if (totalAssertions != 1) {
            String msg = "Response to attribute query must contain exactly one assertion: " + respMsgCtx;
            throw new InvalidGeneralResponseException(msg);
        }
        AttributeAuthority attributeAuthority = idp.getAttributeAuthority();
        if (numEncAssertions == 1) {
            EncryptedElementType encAssertionType = responseType.getEncryptedAssertionArray(0);
            AssertionType assertionType = EncryptionSupport.decryptAssertion(idp, encAssertionType, localEntityId, idp.getMaskedAttributeNames());
            assertion = new Assertion(assertionType);
        } else {
            AssertionType assertionType = responseType.getAssertionArray(0);
            assertion = new Assertion(assertionType);
            if (attributeAuthority.isRequireEncryptedAssertion()) {
                sb = new StringBuilder();
                sb.append("The system is configured to require an encrypted assertion from ").append(idp.getEntityId());
                sb.append(" but assertion was sent in the clear.");
                assertion.addInvalidRemark(sb.toString());
            }
        }
        SignatureStatus signatureStatus = this.validateAssertionSignature.validate(assertion);
        if (attributeAuthority.isRequireSignedAssertion() && signatureStatus == SignatureStatus.NOT_PRESENT) {
            sb = new StringBuilder();
            sb.append("The system is configured to require a singed assertion from ").append(idp.getEntityId());
            sb.append(" but assertion has no signature");
            assertion.addInvalidRemark(sb.toString());
        }
        List<String> entityIds = VirtualIdentityUtil.getVsidsForRuntime(idp);
        this.validateAssertionConditions.validate(assertion, entityIds);
        this.validateAssertionIssuerNameId.validate(assertion);
        this.validateAssertionHasSubjectStmts.validate(assertion);
        if (!assertion.isValid()) {
            throw new InvalidGeneralResponseException("Assertion is not valid: " + assertion + ". " + respMsgCtx);
        }
        return assertion;
    }
}

