/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.protocol.InResponseToSupport;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectConfirmationDataType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectConfirmationType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.util.ResourceEvaluator;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.protocol.TimeConditionUtil;

public class ValidateWebSsoBearerAssertion {
    private ResourceEvaluator resourceEvaluator = new ResourceEvaluator();
    private TimeConditionUtil timeConditionUtil = new TimeConditionUtil();
    private InResponseToSupport inRespToSupport = new InResponseToSupport();
    private static final Log log = LogFactory.getLog(ValidateWebSsoBearerAssertion.class);
    private static ConfigStore configStore = ConfigStoreFarm.getConfig(ValidateWebSsoBearerAssertion.class);
    private static boolean skipNotBeforeValidationOnConfData = configStore.getBooleanValue("SkipNotBeforeAttrValidationOnConfirmationData", false);

    public void validate(Assertion assertion, String assertionConsumerSvc, String requestId, String binding) throws MalformedURLException {
        AssertionType assertionType = assertion.getAssertionType();
        SubjectType subject = assertionType.getSubject();
        SubjectConfirmationType[] subjectConfArray = subject.getSubjectConfirmationArray();
        if (subjectConfArray.length == 0) {
            assertion.addInvalidRemark("(Profiles 4.1.4.2) Assertion contains no subject confirmation elements");
        } else {
            this.validateSubjectConfs(subjectConfArray, assertionConsumerSvc, requestId, assertion, assertionType, binding);
        }
    }

    private void validateSubjectConfs(SubjectConfirmationType[] subjectConfArray, String acs, String requestId, Assertion assertion, AssertionType assertionType, String binding) {
        Calendar now = Util.getUtcCalendar();
        SubjectConfirmationType bearerSubjectConf = null;
        ArrayList<String> reasons = new ArrayList<String>(subjectConfArray.length);
        for (int idx = 0; idx < subjectConfArray.length && bearerSubjectConf == null; ++idx) {
            LinkedList<String> unsatisfactoryReasons = new LinkedList<String>();
            SubjectConfirmationType subjectConf = subjectConfArray[idx];
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConf.getMethod())) {
                unsatisfactoryReasons.add("Subject confirmation does not have method of urn:oasis:names:tc:SAML:2.0:cm:bearer");
            } else {
                if (subjectConf.isSetSubjectConfirmationData()) {
                    SubjectConfirmationDataType confirmationData = subjectConf.getSubjectConfirmationData();
                    if (confirmationData.isSetRecipient()) {
                        String recipient = confirmationData.getRecipient();
                        ResourceEvaluator.Result resourceMatch = this.resourceEvaluator.isResourceMatch(recipient, acs);
                        if (!resourceMatch.isMatch()) {
                            unsatisfactoryReasons.add("Invalid Recipient in <SubjectConfirmationData> element : " + resourceMatch.getMessage());
                        }
                    } else {
                        unsatisfactoryReasons.add("The bearer <SubjectConfirmation> element MUST contain a <SubjectConfirmationData> element that MUST contain a Recipient attribute containing the service provider's assertion consumer service URL");
                    }
                    if (!skipNotBeforeValidationOnConfData) {
                        if (confirmationData.isSetNotBefore()) {
                            unsatisfactoryReasons.add("The bearer <SubjectConfirmation> element MUST contain a <SubjectConfirmationData> element that MUST NOT contain a NotBefore attribute");
                        }
                    } else {
                        log.debug((Object)"Skipping Validation of NotBefore attribute existance in <SubjectConfirmation> based on client preferences.");
                    }
                    if (confirmationData.isSetNotOnOrAfter()) {
                        Calendar notOnOrAfter = confirmationData.getNotOnOrAfter();
                        try {
                            this.timeConditionUtil.validateNotOnOrAfter(notOnOrAfter, now);
                        }
                        catch (TimeConditionUtil.InvalidTimeConditionException e) {
                            unsatisfactoryReasons.add(e.getMessage());
                        }
                    } else {
                        unsatisfactoryReasons.add("The bearer <SubjectConfirmation> element MUST contain a <SubjectConfirmationData> element that MUST contain a NotOnOrAfter attribute that limits the window during which the assertion can be delivered");
                    }
                    this.checkInRespTo(requestId, unsatisfactoryReasons, confirmationData);
                } else {
                    unsatisfactoryReasons.add("The bearer <SubjectConfirmation> elementelement MUST contain a <SubjectConfirmationData> element with Recipient and NotOnOrAfter attributes as well as the InResponseTo attribute in SP initiated scenarios");
                }
                if (unsatisfactoryReasons.isEmpty()) {
                    bearerSubjectConf = subjectConf;
                }
            }
            if (unsatisfactoryReasons.isEmpty()) continue;
            StringBuilder remark = new StringBuilder();
            remark.append("#");
            int displayIdx = idx + 1;
            remark.append(displayIdx);
            remark.append(" subject confirmation is unsatisfactory: ");
            remark.append(unsatisfactoryReasons);
            reasons.add(remark.toString());
        }
        if (bearerSubjectConf == null) {
            String remark = "(Profiles 4.1.4.2) assertion could not be confirmed - here's why: " + ((Object)reasons).toString();
            assertion.addInvalidRemark(remark);
        } else {
            String id = assertionType.getID();
            Calendar notOnOrAfter = bearerSubjectConf.getSubjectConfirmationData().getNotOnOrAfter();
            AssertionReplayPreventionService replaySvc = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
            try {
                if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(binding) && replaySvc.isReplay(id, notOnOrAfter)) {
                    assertion.addInvalidRemark("Assertion with ID of " + id + " has previously been processed - this may be an indication of a replay attack.");
                }
            }
            catch (GeneralServiceException e) {
                throw new ProcessRuntimeException("Unable to perform replay check on assertion.", e);
            }
        }
    }

    private void checkInRespTo(String requestId, List<String> unsatisfactoryReasons, SubjectConfirmationDataType confData) {
        if (!this.inRespToSupport.relaxValidation()) {
            String inResponseTo;
            if (requestId != null != confData.isSetInResponseTo()) {
                String inRespTo = confData.isSetInResponseTo() ? confData.getInResponseTo() : null;
                unsatisfactoryReasons.add("RequestId (" + requestId + ") / InResponseTo (" + inRespTo + ") mismatch");
            } else if (confData.isSetInResponseTo() && !(inResponseTo = confData.getInResponseTo()).equals(requestId)) {
                unsatisfactoryReasons.add("InResponseTo " + inResponseTo + " does not match up with RequestId " + requestId);
            }
        }
    }
}

