/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol.nameidparsing;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.protocol.nameidparsing.DefaultParser;
import org.sourceid.saml20.protocol.nameidparsing.NameIdParser;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;

public class X509SubjectNameParser
extends DefaultParser
implements NameIdParser {
    public static final String SUBJECT_DN = "SubjectDN";
    private Log log = LogFactory.getLog(this.getClass());
    private Pattern regexPattern = Pattern.compile("[^\\\\],");

    @Override
    public Map<String, Object> parse(NameIDType nameId) {
        String nameIdValue;
        Map<String, Object> parsed = super.parse(nameId);
        String dn = nameIdValue = nameId.getStringValue();
        try {
            dn = Util.canonicalizeX500DN(nameIdValue);
        }
        catch (IllegalArgumentException e) {
            this.log.warn((Object)("Unable to canonicalize X509 Subject Name DN from name id value: " + nameIdValue + " " + e));
        }
        parsed.put(SUBJECT_DN, dn);
        Matcher matcher = this.regexPattern.matcher(dn);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.add(-2);
        while (matcher.find()) {
            int start = matcher.start();
            indexes.add(start);
        }
        indexes.add(dn.length() - 1);
        ArrayList<String> parts = new ArrayList<String>();
        for (int j = 1; j < indexes.size(); ++j) {
            int start = (Integer)indexes.get(j - 1) + 2;
            int end = (Integer)indexes.get(j) + 1;
            parts.add(dn.substring(start, end));
        }
        for (String part : parts) {
            int pos = part.indexOf("=");
            if (pos <= 0) continue;
            String name = part.substring(0, pos);
            String value = part.substring(pos + 1);
            value = value.replaceAll("\\\\,", ",");
            String uniqueName = X509SubjectNameParser.getUniqueName(name, parsed);
            parsed.put(uniqueName, value);
        }
        return parsed;
    }

    private static String getUniqueName(String name, Map<String, Object> map) {
        int i = 0;
        Object uName = name;
        while (map.containsKey(uName)) {
            uName = name + ++i;
        }
        return uName;
    }
}

