/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class IdpConnAuthnSourceKey
extends AuthnSourceKey {
    private static final long serialVersionUID = 1L;

    protected IdpConnAuthnSourceKey() {
    }

    public IdpConnAuthnSourceKey(String idpConnectionId) {
        super(idpConnectionId);
    }

    @Override
    public AuthnSourceKey.AuthnSourceType getType() {
        return AuthnSourceKey.AuthnSourceType.IDP_CONN;
    }

    @Override
    public String getFriendlyId() {
        String friendlyId = this.getId();
        IdpConnection conn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(friendlyId, false);
        if (conn != null) {
            friendlyId = conn.getEntityId();
        }
        return friendlyId;
    }
}

