/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import java.util.Objects;
import org.sourceid.saml20.service.Session;

public class OidcSession
extends Session {
    private String clientId;
    private String baseUrl;
    private String userName;
    private boolean isMaskUserName;
    private String issuer;
    private String subject;
    private String oAuthIssuerId;
    private String extendedSri;

    public OidcSession(String oauthClientId, String baseUrl, String userName, boolean isMaskUserName) {
        this.clientId = oauthClientId;
        this.baseUrl = baseUrl;
        this.userName = userName;
        this.isMaskUserName = isMaskUserName;
    }

    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isMaskUserName() {
        return this.isMaskUserName;
    }

    @Override
    public String getPartnerId() {
        return this.clientId;
    }

    public String toString() {
        return "OidcSession{clientId='" + this.clientId + "', baseUrl='" + this.baseUrl + "'}";
    }

    @Override
    public String toShortString() {
        return this.toString();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getOAuthIssuerId() {
        return this.oAuthIssuerId;
    }

    public void setOAuthIssuerId(String oAuthIssuerId) {
        this.oAuthIssuerId = oAuthIssuerId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getExtendedSri() {
        return this.extendedSri;
    }

    public void setExtendedSri(String extendedSri) {
        this.extendedSri = extendedSri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OidcSession that = (OidcSession)o;
        if (this.isMaskUserName != that.isMaskUserName) {
            return false;
        }
        if (!Objects.equals(this.clientId, that.clientId)) {
            return false;
        }
        if (!Objects.equals(this.baseUrl, that.baseUrl)) {
            return false;
        }
        if (!Objects.equals(this.userName, that.userName)) {
            return false;
        }
        if (!Objects.equals(this.issuer, that.issuer)) {
            return false;
        }
        if (!Objects.equals(this.subject, that.subject)) {
            return false;
        }
        if (!Objects.equals(this.oAuthIssuerId, that.oAuthIssuerId)) {
            return false;
        }
        return Objects.equals(this.extendedSri, that.extendedSri);
    }

    @Override
    public int hashCode() {
        int result = this.clientId != null ? this.clientId.hashCode() : 0;
        result = 31 * result + (this.baseUrl != null ? this.baseUrl.hashCode() : 0);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.isMaskUserName ? 1 : 0);
        result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.oAuthIssuerId != null ? this.oAuthIssuerId.hashCode() : 0);
        result = 31 * result + (this.extendedSri != null ? this.extendedSri.hashCode() : 0);
        return result;
    }
}

