/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import com.pingidentity.jgroups.NodeAddress;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import org.jgroups.Address;

public class ReplicationTargetNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final NodeAddress nodeAddress;
    private final String configProfileId;
    private final Instant replicationDataDate;

    public ReplicationTargetNode(Address address, String configProfileId, Instant replicationDataDate) {
        this.nodeAddress = new NodeAddress(address);
        this.configProfileId = configProfileId;
        this.replicationDataDate = replicationDataDate;
    }

    public Address getAddress() {
        return this.nodeAddress.getAddress();
    }

    public String getConfigProfileId() {
        return this.configProfileId;
    }

    public Instant getReplicationDataDate() {
        return this.replicationDataDate;
    }

    public boolean isTargetNodeMoreRecent(ReplicationTargetNode replicationTargetNode) {
        if (Objects.equals(this.nodeAddress.getAddress(), replicationTargetNode.getAddress())) {
            return false;
        }
        if (this.configProfileId != null && replicationTargetNode.getConfigProfileId() != null && this.replicationDataDate != null && replicationTargetNode.getReplicationDataDate() != null) {
            return !this.configProfileId.equals(replicationTargetNode.getConfigProfileId()) || replicationTargetNode.getReplicationDataDate().isAfter(this.replicationDataDate);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationTargetNode that = (ReplicationTargetNode)o;
        return Objects.equals(this.nodeAddress, that.nodeAddress) && Objects.equals(this.configProfileId, that.configProfileId) && Objects.equals(this.replicationDataDate, that.replicationDataDate);
    }

    public int hashCode() {
        return Objects.hash(this.nodeAddress, this.configProfileId, this.replicationDataDate);
    }
}

