/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.adminstate.errors;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.sourceid.saml20.service.adminstate.errors.AdminNodeStateConfigError;
import org.sourceid.saml20.service.adminstate.errors.AdminNodeStateConfigRuntimeException;

public class AdminNodeStateConfigErrors {
    private final List<AdminNodeStateConfigError> errors = new ArrayList<AdminNodeStateConfigError>();

    public void add(String error) {
        this.errors.add(new AdminNodeStateConfigError(error));
    }

    public boolean isNotEmpty() {
        return !this.errors.isEmpty();
    }

    public void throwExceptionIfErrors(Log logger, String configFileName) {
        if (this.isNotEmpty()) {
            logger.error((Object)String.format("Validation errors found with configuration file [%s]:%n%s", configFileName, this));
            throw new AdminNodeStateConfigRuntimeException(String.format("Configuration errors found in [%s].", configFileName));
        }
    }

    public String toString() {
        ArrayList<CallSite> errorsList = new ArrayList<CallSite>();
        for (AdminNodeStateConfigError error : this.errors) {
            errorsList.add((CallSite)((Object)("    " + error.getErrorStr())));
        }
        return String.join((CharSequence)System.lineSeparator(), errorsList);
    }
}

