/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.adminstate.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.service.adminstate.AdminNodeRole;
import org.sourceid.saml20.service.adminstate.AdminNodesStateManager;
import org.sourceid.saml20.service.adminstate.ConfigSyncStatus;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class AdminNodesStateManagerImpl
implements AdminNodesStateManager {
    private static final Log log = LogFactory.getLog(AdminNodesStateManagerImpl.class);
    private final NodeIndexRegistry nodeIndexRegistry;
    private final AdminNodeConfigManager adminNodeConfigManager;

    public AdminNodesStateManagerImpl(NodeIndexRegistry nodeIndexRegistry, AdminNodeConfigManager adminNodeConfigManager) {
        this.nodeIndexRegistry = nodeIndexRegistry;
        this.adminNodeConfigManager = adminNodeConfigManager;
        this.nodeIndexRegistry.addListener(this);
    }

    @Override
    public void setSyncStatus(ConfigSyncStatus syncStatus) {
        Objects.requireNonNull(syncStatus, "syncStatus");
        this.adminNodeConfigManager.setSyncStatus(syncStatus);
        if (this.adminNodeConfigManager.getSyncState() == null) {
            return;
        }
        if (ConfigSyncStatus.SUCCEEDED == syncStatus || ConfigSyncStatus.FAILED == syncStatus) {
            this.nodeIndexRegistry.reregister();
        }
    }

    @Override
    public List<Node> getActiveNodesFromCluster() {
        return this.adminNodeConfigManager.isEnabled() ? (List)this.nodeIndexRegistry.getNodes().stream().filter(node -> node.isConsole() && node.isActiveConsole()).collect(Collectors.toCollection(ArrayList::new)) : Collections.emptyList();
    }

    @Override
    public void onNodeIndexRegistryChanged() {
        List<Node> activeNodesList;
        if (this.adminNodeConfigManager.isEnabled() && AdminNodeRole.ACTIVE.equals((Object)this.adminNodeConfigManager.getRole()) && (activeNodesList = this.getActiveNodesFromCluster()).size() > 1) {
            this.handleMultipleActiveNodes(this.nodeIndexRegistry, activeNodesList, this.nodeIndexRegistry.getLocalNodeIndex());
        }
    }

    private void handleMultipleActiveNodes(NodeIndexRegistry nodeIndexRegistry, List<Node> activeNodesList, int localNodeIndex) {
        List otherNodesThatShouldBeActive;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Multiple active consoles were found including this one (idx=%d): %s. Trying to resolve.", localNodeIndex, activeNodesList));
        }
        if (!(otherNodesThatShouldBeActive = activeNodesList.stream().filter(node -> node.getIndex() != localNodeIndex && this.shouldOtherNodeStayActive((Node)node)).collect(Collectors.toList())).isEmpty()) {
            log.warn((Object)("Switching this admin console's role to passive because other admin console nodes have higher priority to be active: " + otherNodesThatShouldBeActive));
            this.adminNodeConfigManager.updateRole(AdminNodeRole.PASSIVE);
            nodeIndexRegistry.reregister();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Keeping this admin console active.");
        }
    }

    private boolean shouldOtherNodeStayActive(Node otherNode) {
        if (otherNode == null) {
            return false;
        }
        if (this.adminNodeConfigManager.getRoleLastUpdateDate() == null) {
            return true;
        }
        if (otherNode.getConsoleRoleLastUpdateDate() != null) {
            if (otherNode.getConsoleRoleLastUpdateDate().isAfter(this.adminNodeConfigManager.getRoleLastUpdateDate())) {
                return true;
            }
            if (otherNode.getConsoleRoleLastUpdateDate().equals(this.adminNodeConfigManager.getRoleLastUpdateDate())) {
                log.warn((Object)String.format("Multiple active consoles with the same role last updated date detected: %s. Please resolve this by ensuring only one active console is running.", otherNode));
                return false;
            }
        }
        return false;
    }

    @Override
    public Optional<Node> getActiveNode() {
        if (!this.adminNodeConfigManager.isEnabled()) {
            return Optional.empty();
        }
        List<Node> activeConsoles = this.getActiveNodesFromCluster();
        if (activeConsoles.size() > 1) {
            log.warn((Object)String.format("While determining the current active console, multiple (%d) were found: %s", activeConsoles.size(), activeConsoles));
            return Optional.empty();
        }
        return activeConsoles.isEmpty() ? Optional.empty() : Optional.of(activeConsoles.get(0));
    }
}

