/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.configservice.AutoReloadable;
import com.sun.jndi.ldap.LdapName;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.AccountLinkingServiceException;
import org.sourceid.saml20.service.impl.AccountLinkingServiceBase;
import org.sourceid.util.log.AttributeMap;

public class AccountLinkingServiceLDAPImpl
extends AccountLinkingServiceBase
implements AccountLinkingService,
AutoReloadable {
    private final Log log = LogFactory.getLog(AccountLinkingServiceLDAPImpl.class);
    private ConfigStore configStore;
    private String jndiName;
    private String searchBase;
    private String usernameAttribute;
    private String accountLinkDataAttribute;
    private LdapDataSource ldapSource;

    public AccountLinkingServiceLDAPImpl() {
        this.load();
    }

    private void load() {
        this.configStore = ConfigStoreFarm.getConfig(this.getClass());
        this.jndiName = this.configStore.getStringValue("PingFederateDSJNDIName", null);
        this.searchBase = this.configStore.getStringValue("UserSearchBase", "");
        this.usernameAttribute = this.configStore.getStringValue("UsernameAttribute", null);
        this.accountLinkDataAttribute = this.configStore.getStringValue("AccountLinkDataAttribute", null);
        this.ldapSource = this.jndiName == null ? null : MgmtFactory.getDataSourceManager().getLdapDataSource(this.jndiName);
    }

    @Override
    public String lookupLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        this.log.debug((Object)"Detecting account link...");
        this.log.debug((Object)("idp entityid: " + idpEntityId));
        this.log.debug((Object)("adapter id: " + authnAdapterId));
        this.log.debug((Object)("external id: " + externalIdentifier));
        this.checkConfiguration();
        String localIdentifier = this.lookupLocalIdentifier(idpEntityId, authnAdapterId, externalIdentifier);
        if (localIdentifier == null) {
            this.log.debug((Object)"Account link not found");
        } else {
            this.log.debug((Object)("Account link found for local user " + localIdentifier));
        }
        return localIdentifier;
    }

    @Override
    public void storeLink(String localIdentifier, String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        this.log.debug((Object)"Creating account link...");
        this.log.debug((Object)("idp entityid: " + idpEntityId));
        this.log.debug((Object)("adapter id: " + authnAdapterId));
        this.log.debug((Object)("external id: " + externalIdentifier));
        this.log.debug((Object)("local id: " + localIdentifier));
        this.checkConfiguration();
        this.modifyAccountLinkUserData(localIdentifier, idpEntityId, authnAdapterId, externalIdentifier, 1);
        this.log.debug((Object)"Account link created");
    }

    @Override
    public void terminateLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        this.log.debug((Object)"Terminating account link...");
        this.log.debug((Object)("idp entityid: " + idpEntityId));
        this.log.debug((Object)("adapter id: " + authnAdapterId));
        this.log.debug((Object)("external id: " + externalIdentifier));
        this.checkConfiguration();
        String localIdentifier = this.lookupLocalIdentifier(idpEntityId, authnAdapterId, externalIdentifier);
        if (localIdentifier == null) {
            this.log.warn((Object)"Account link for user not found. Link terminiation skipped.");
        } else {
            this.modifyAccountLinkUserData(localIdentifier, idpEntityId, authnAdapterId, externalIdentifier, 3);
            this.log.debug((Object)"Account link terminated");
        }
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.jndiName);
    }

    private void checkConfiguration() throws AccountLinkingServiceException {
        if (StringUtils.isEmpty((String)this.jndiName)) {
            throw new AccountLinkingServiceException("The Account Linking data store is not defined.");
        }
        if (StringUtils.isEmpty((String)this.usernameAttribute)) {
            throw new AccountLinkingServiceException("The Account Linking username attribute is not defined.");
        }
        if (StringUtils.isEmpty((String)this.accountLinkDataAttribute)) {
            throw new AccountLinkingServiceException("The Account Linking data attribute is not defined.");
        }
        if (this.ldapSource == null) {
            throw new AccountLinkingServiceException("The defined LDAP data source was not found: " + this.jndiName);
        }
    }

    private String getAccountLinkingAttributeValue(String idpEntityId, String authnAdapterId, String externalIdentifier) {
        return idpEntityId + "," + authnAdapterId + "," + externalIdentifier;
    }

    private String lookupLocalIdentifier(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        List<AttributeMap> results;
        String localIdentifier = null;
        try {
            String[] userAttributes = new String[]{this.usernameAttribute};
            String accountLinkingAttributeValue = LDAPUtil.encodeFilter(this.getAccountLinkingAttributeValue(idpEntityId, authnAdapterId, externalIdentifier));
            results = this.ldapSource.getAttributesOfMatchingObjects(this.searchBase, this.accountLinkDataAttribute + "=" + accountLinkingAttributeValue, 2, userAttributes, 0);
        }
        catch (NamingException e) {
            throw new AccountLinkingServiceException(e);
        }
        if (results.size() > 1) {
            throw new AccountLinkingServiceException("Expected one result during user lookup but recived " + results.size() + ". Search Base:" + this.searchBase + " Filter:" + this.accountLinkDataAttribute + "=" + this.getAccountLinkingAttributeValue(idpEntityId, authnAdapterId, externalIdentifier));
        }
        if (results.size() == 1) {
            localIdentifier = ((AttributeValue)results.get(0).get((Object)this.usernameAttribute)).getValue();
        }
        return localIdentifier;
    }

    private void modifyAccountLinkUserData(String localIdentifier, String idpEntityId, String authnAdapterId, String externalIdentifier, int modificationCode) throws AccountLinkingServiceException {
        try {
            BasicAttribute basicAttr = new BasicAttribute(this.accountLinkDataAttribute);
            basicAttr.add(this.getAccountLinkingAttributeValue(idpEntityId, authnAdapterId, externalIdentifier));
            BasicAttributes attrsToModifyUser = new BasicAttributes(true);
            attrsToModifyUser.put(basicAttr);
            String userDN = this.ldapSource.getFullDNOfFirstMatchingObject(this.searchBase, this.usernameAttribute + "=" + LDAPUtil.encodeFilter(localIdentifier), 2, null);
            if (userDN == null) {
                throw new AccountLinkingServiceException("User '" + localIdentifier + "' not found.  Search Base:" + this.searchBase + " Filter:" + this.usernameAttribute + "=" + localIdentifier);
            }
            LdapName userLdapName = new LdapName(userDN);
            LDAPUtil.newInstance(this.ldapSource, (ServiceInformation)this).modifyItem(userLdapName, attrsToModifyUser, modificationCode);
        }
        catch (NamingException e) {
            throw new AccountLinkingServiceException(e);
        }
    }
}

