/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.cookie;

import com.pingidentity.common.util.SizeBoundedLinkedHashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ByteUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.service.impl.cookie.KeyTrackerGroupRpcImpl;
import org.sourceid.saml20.service.impl.cookie.KeyWrapper;
import org.sourceid.saml20.state.StateAccepter;

public class KeyTrackerState
implements StateAccepter,
Serializable,
KeyTrackerGroupRpcImpl.RpcTarget {
    private transient Log log = LogFactory.getLog(this.getClass());
    private Map<Integer, KeyWrapper> keys;
    private int latestIndex;
    private int maxNumKeys;

    public KeyTrackerState() {
        ConfigStore config = ConfigStoreFarm.getConfig("key-tracker");
        this.maxNumKeys = config.getIntValue("max-number-of-keys", 10);
        this.keys = new SizeBoundedLinkedHashMap<Integer, KeyWrapper>(this.maxNumKeys, false, this.maxNumKeys);
    }

    @Override
    public void setState(StateAccepter other) {
        KeyTrackerState keyTrackerState = (KeyTrackerState)other;
        this.keys = keyTrackerState.keys;
        this.latestIndex = keyTrackerState.latestIndex;
        this.log.debug((Object)("set state complete with latest index=" + this.latestIndex + " and keys: " + this.keys));
    }

    public synchronized KeyWrapper getLatestKey() {
        return this.keys.get(this.latestIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyWrapper getKey(byte[] idxBytes) {
        int idx = ByteUtil.getInt(idxBytes);
        KeyTrackerState keyTrackerState = this;
        synchronized (keyTrackerState) {
            return this.keys.get(idx);
        }
    }

    public synchronized int chooseIndex() {
        int randIndex;
        Random random = new Random();
        while (this.keys.containsKey(randIndex = 2 + random.nextInt(65525))) {
        }
        return randIndex;
    }

    @Override
    public synchronized void addKey(KeyWrapper kw) {
        int index = kw.getIndex();
        this.keys.put(index, kw);
        this.latestIndex = index;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " latestIndex=" + this.latestIndex + " and keys: " + this.keys;
    }

    public int getMaxNumKeys() {
        return this.maxNumKeys;
    }
}

