/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.B64;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.sourceid.common.ByteUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigProps;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.localmemory.ArtifactPersistenceServiceMapImpl;
import org.sourceid.saml20.service.util.NodeIndex;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class ArtifactPersistenceSvcGroupRpcEncodedNodeIdxImpl
extends BaseGroupRpc
implements ArtifactPersistenceService {
    private static final String RETRIEVE_NAME = "retrieveAndRemoveArtifact";
    private static final Class[] RETRIEVE_SIG = new Class[]{byte[].class};
    private static Log log = LogFactory.getLog(ArtifactPersistenceSvcGroupRpcEncodedNodeIdxImpl.class);
    private int localIndex;
    private ArtifactPersistenceServiceMapImpl mapArtifactPersistenceSvc;
    private NodeIndexRegistry nodeIndexRegistry;
    int timeout;

    public ArtifactPersistenceSvcGroupRpcEncodedNodeIdxImpl() throws Exception {
        ConfigProps cfg = new ConfigProps("cluster-artifact.conf");
        log.debug((Object)cfg);
        NodeIndexRegistry service = GlobalRegistry.getService(NodeIndexRegistry.class);
        int time = cfg.getInt("rpc.timeout", 1500);
        this.init(service, NodeIndex.getIndex(), time);
        log.info((Object)("rpc timeout: " + this.timeout));
    }

    ArtifactPersistenceSvcGroupRpcEncodedNodeIdxImpl(NodeIndexRegistry nodeIdxReg, int myIdx, int to) throws Exception {
        this.init(nodeIdxReg, myIdx, to);
    }

    void init(NodeIndexRegistry nodeIndexRegistry, int myIdx, int timeout) throws Exception {
        this.localIndex = myIdx;
        this.nodeIndexRegistry = nodeIndexRegistry;
        this.timeout = timeout;
        this.mapArtifactPersistenceSvc = (ArtifactPersistenceServiceMapImpl)this.muxRpcDispatcherMgr.getRpcInvocationTarget(ArtifactPersistenceService.class);
    }

    @Override
    public byte[] precomputeHandle(int length) {
        byte[] handle = IDGenerator.generateBytes(length);
        byte[] fourBytes = ByteUtil.getFourBytes(this.localIndex);
        handle[length - 4] = fourBytes[fourBytes.length - 4];
        handle[length - 3] = fourBytes[fourBytes.length - 3];
        handle[length - 2] = fourBytes[fourBytes.length - 2];
        handle[length - 1] = fourBytes[fourBytes.length - 1];
        return handle;
    }

    @Override
    public ArtifactPersistenceService.Handle saveArtifact(ArtifactPersistenceService.Message msg, int timeoutSeconds) {
        byte[] handle = msg.getHandle();
        if (handle == null) {
            int messageHandleLength = msg.getMessageHandleLength();
            handle = this.precomputeHandle(messageHandleLength);
        }
        this.mapArtifactPersistenceSvc.saveArtifact(handle, msg, timeoutSeconds);
        if (log.isDebugEnabled()) {
            log.debug((Object)("saved artifact " + B64.encode((byte[])handle)));
        }
        return new ArtifactPersistenceService.Handle(handle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ArtifactPersistenceService.Message retrieveAndRemoveArtifact(byte[] messageHandle) throws ArtifactPersistenceServiceException {
        String s;
        ArtifactPersistenceService.Message message = this.mapArtifactPersistenceSvc.retrieveAndRemoveArtifact(messageHandle);
        String string = s = message == null ? " local check returned null" : " local check found msg";
        if (log.isDebugEnabled()) {
            log.debug((Object)("retrieveAndRemoveArtifact " + B64.encode((byte[])messageHandle) + s));
        }
        if (message != null) return message;
        byte[] fourBytes = new byte[4];
        fourBytes[fourBytes.length - 4] = messageHandle[messageHandle.length - 4];
        fourBytes[fourBytes.length - 3] = messageHandle[messageHandle.length - 3];
        fourBytes[fourBytes.length - 2] = messageHandle[messageHandle.length - 2];
        fourBytes[fourBytes.length - 1] = messageHandle[messageHandle.length - 1];
        int index = ByteUtil.getInt(fourBytes);
        Address address = this.nodeIndexRegistry.getAddress(index);
        if (address != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("retrieveAndRemoveArtifact will attempt remote retrieve from " + address + " for " + B64.encode((byte[])messageHandle)));
            }
            try (TimerScope ignored = Meters.getTimerScope("rpc", "rpc.name", RETRIEVE_NAME);){
                MethodCall mc = new MethodCall(RETRIEVE_NAME, new Object[]{messageHandle}, RETRIEVE_SIG);
                RequestOptions requestOptions = new RequestOptions(ResponseMode.GET_FIRST, (long)this.timeout, true);
                Object o = this.rpcDispatcher.callRemoteMethod(address, mc, requestOptions);
                message = (ArtifactPersistenceService.Message)o;
                String string2 = s = message == null ? "null" : "a msg";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("call to " + address + " for " + B64.encode((byte[])messageHandle) + " returned: " + s));
                }
                if (message != null) return message;
                Meters.getCounter("rpc.errors", "rpc.name", RETRIEVE_NAME).increment();
                return message;
            }
            catch (Exception e) {
                Meters.getCounter("rpc.errors", "rpc.name", RETRIEVE_NAME).increment();
                throw new ArtifactPersistenceServiceException("Unable to retrieve artifact from " + address, e);
            }
        } else {
            log.warn((Object)("No node known for index " + index));
        }
        return message;
    }

    public static class LoggingMapImpl
    extends ArtifactPersistenceServiceMapImpl {
        @Override
        public synchronized ArtifactPersistenceService.Message retrieveAndRemoveArtifact(byte[] messageHandlebytes) {
            ArtifactPersistenceService.Message message = super.retrieveAndRemoveArtifact(messageHandlebytes);
            if (log.isDebugEnabled()) {
                log.debug((Object)("retrieve " + B64.encode((byte[])messageHandlebytes) + " returning " + (message == null ? "null" : "stored msg")));
            }
            return message;
        }
    }
}

