/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.jgroups.JGUtil;
import com.pingidentity.jgroups.MuxRpcDispatcherMgr;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.service.impl.grouprpc.MockRpcDispatcher;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;

public abstract class BaseGroupRpc {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    protected RpcDispatcher rpcDispatcher = null;
    protected MuxRpcDispatcherMgr muxRpcDispatcherMgr = null;
    protected RpcResponseMode rpcResponseMode = RpcResponseMode.GET_ALL;
    private boolean isTcp = true;
    private MockRpcDispatcher mockRpcDispatcher = null;

    public BaseGroupRpc() {
        this(true);
    }

    public BaseGroupRpc(boolean initializeClustering) {
        this.log.debug((Object)("Creating " + this.getClass()));
        if (initializeClustering) {
            this.initializeClustering(MuxRpcDispatcherMgr.getMgr(), MuxRpcDispatcherMgr.getMgr().getRpcDispatcher());
        }
    }

    public BaseGroupRpc(MockRpcDispatcher mockRpcDispatcher) {
        this(false);
        this.mockRpcDispatcher = mockRpcDispatcher;
    }

    public void initializeClustering(MuxRpcDispatcherMgr muxRpcDispatcherMgr, RpcDispatcher rpcDispatcher) {
        this.muxRpcDispatcherMgr = muxRpcDispatcherMgr;
        this.rpcDispatcher = rpcDispatcher;
        this.isTcp = JGUtil.isTcpBasedStack(rpcDispatcher.getChannel());
    }

    public void setRpcResponseMode(RpcResponseMode rpcResponseMode) {
        this.rpcResponseMode = rpcResponseMode;
    }

    public RspList callRemoteMethods(String methodName, Class[] signature, boolean synchronous, int timeout, Object ... args) {
        return this.callRemoteMethods(null, methodName, signature, synchronous, this.rpcResponseMode, null, timeout, LogLevel.DEBUG, args);
    }

    public RspList callRemoteMethods(Vector<Address> nodes, String methodName, Class[] signature, boolean synchronous, int timeout, Object ... args) {
        return this.callRemoteMethods(nodes, methodName, signature, synchronous, this.rpcResponseMode, null, timeout, LogLevel.DEBUG, args);
    }

    public RspList callRemoteMethods(Vector<Address> nodes, String methodName, Class[] signature, boolean synchronous, int timeout, LogLevel logLevel, Object ... args) {
        return this.callRemoteMethods(nodes, methodName, signature, synchronous, this.rpcResponseMode, null, timeout, logLevel, args);
    }

    public RspList callRemoteMethods(Vector<Address> nodes, String methodName, Class[] signature, boolean synchronous, RpcResponseMode overrideResponseMode, RspFilter rspFilter, int timeout, Object ... args) {
        return this.callRemoteMethods(nodes, methodName, signature, synchronous, overrideResponseMode, rspFilter, timeout, LogLevel.DEBUG, args);
    }

    public RspList callRemoteMethods(Vector<Address> nodes, String methodName, Class[] signature, boolean synchronous, RpcResponseMode overrideResponseMode, RspFilter rspFilter, int timeout, LogLevel logLevel, Object ... args) {
        RspList rspList;
        ResponseMode mode;
        if (this.mockRpcDispatcher != null) {
            return this.mockRpcDispatcher.callRemoteMethods(nodes, methodName, signature, synchronous, args);
        }
        if (!synchronous) {
            overrideResponseMode = RpcResponseMode.GET_NONE;
        }
        switch (overrideResponseMode) {
            case GET_FIRST: {
                mode = ResponseMode.GET_FIRST;
                break;
            }
            case GET_NONE: {
                mode = ResponseMode.GET_NONE;
                break;
            }
            case GET_MAJORITY: {
                rspFilter = new MajorityFilter(nodes != null ? nodes.size() : JGUtil.getViewSize(this.rpcDispatcher.getChannel()));
                mode = ResponseMode.GET_ALL;
                break;
            }
            default: {
                mode = ResponseMode.GET_ALL;
            }
        }
        boolean useAnycasting = false;
        if (this.isTcp) {
            useAnycasting = true;
        } else if (nodes != null) {
            int viewSize;
            int recipientGroupSize = nodes.size();
            useAnycasting = (double)recipientGroupSize < 0.5 * (double)(viewSize = JGUtil.getViewSize(this.rpcDispatcher.getChannel()));
        }
        MethodCall mc = new MethodCall(methodName, args, signature);
        RequestOptions requestOptions = new RequestOptions(mode, (long)timeout, useAnycasting);
        if (rspFilter != null) {
            requestOptions.setRspFilter(rspFilter);
        }
        try (TimerScope ignored = synchronous ? Meters.getTimerScope("rpc", "rpc.name", methodName) : TimerScope.empty();){
            rspList = this.rpcDispatcher.callRemoteMethods(nodes, mc, requestOptions);
        }
        catch (Exception e) {
            if (synchronous) {
                Meters.getCounter("rpc.errors", "rpc.name", methodName).increment();
            }
            throw new RuntimeException(BaseGroupRpc.getLogStmt(methodName, nodes, overrideResponseMode) + " Exception returned from RPC Dispatcher.", e);
        }
        if (rspList != null) {
            int numErrors = 0;
            for (Object entry : rspList.entrySet()) {
                InvocationTargetException ite;
                Throwable cause;
                Rsp rsp = (Rsp)entry.getValue();
                Throwable calleeException = rsp.getException();
                if (calleeException == null) continue;
                ++numErrors;
                if (!this.log.isErrorEnabled()) continue;
                Address address = (Address)entry.getKey();
                String sender = "null";
                if (address != null) {
                    sender = address.toString();
                }
                StringBuilder msg = new StringBuilder(128);
                msg.append("Node '");
                msg.append(sender);
                msg.append("' threw exception while handling RPC to: ");
                msg.append(methodName);
                msg.append(". Response from '");
                msg.append(sender);
                msg.append("' will be ignored.");
                this.log.error((Object)msg.toString(), calleeException);
                if (!(calleeException instanceof InvocationTargetException) || (cause = (ite = (InvocationTargetException)calleeException).getCause()) == null || cause instanceof RuntimeException) continue;
                this.log.error((Object)"Returned exception is not a runtime exception and should be handled properly");
            }
            if (rspList.size() == 0) {
                if (synchronous) {
                    Meters.getCounter("rpc.errors", "rpc.name", methodName).increment();
                }
                throw new RuntimeException(BaseGroupRpc.getLogStmt(methodName, nodes, overrideResponseMode) + " No responses received for RPC. Failing call.");
            }
            if (rspList.size() == numErrors) {
                if (synchronous) {
                    Meters.getCounter("rpc.errors", "rpc.name", methodName).increment();
                }
                throw new RuntimeException(BaseGroupRpc.getLogStmt(methodName, nodes, overrideResponseMode) + " All nodes have failed to return a valid response from RPC. Failing call.");
            }
        }
        ArrayList<Address> notReceived = new ArrayList<Address>();
        ArrayList<Address> received = new ArrayList<Address>();
        if (synchronous) {
            for (Map.Entry entry : rspList.entrySet()) {
                if (!((Rsp)entry.getValue()).wasReceived()) {
                    notReceived.add((Address)entry.getKey());
                    continue;
                }
                received.add((Address)entry.getKey());
            }
            if (received.isEmpty()) {
                Meters.getCounter("rpc.errors", "rpc.name", mc.getMethodName()).increment();
            }
        }
        if (this.log.isTraceEnabled() || logLevel == LogLevel.DEBUG && this.log.isDebugEnabled()) {
            StringBuilder logMsg = BaseGroupRpc.getLogStmt(methodName, nodes, overrideResponseMode);
            if (synchronous) {
                if (notReceived.isEmpty()) {
                    logMsg.append(" Responses received from all nodes.");
                } else if (received.isEmpty()) {
                    logMsg.append(" No responses received.");
                } else if (ResponseMode.GET_ALL.equals((Object)mode) && rspFilter == null) {
                    logMsg.append(" The following nodes did not respond to the request within the timeout period: " + StringUtils.join(notReceived, (String)", ") + ".");
                } else {
                    logMsg.append(" Responses received from the following nodes: " + StringUtils.join(received, (String)", ") + ".");
                }
            }
            if (logLevel == LogLevel.TRACE) {
                this.log.trace((Object)logMsg);
            } else {
                this.log.debug((Object)logMsg);
            }
        }
        return rspList;
    }

    public Address getCoord() {
        if (this.mockRpcDispatcher != null) {
            return this.mockRpcDispatcher.getCoord();
        }
        View view = this.rpcDispatcher.getChannel().getView();
        if (view == null) {
            return null;
        }
        return view.getCoord();
    }

    public List<Address> getViewAddresses() {
        if (this.mockRpcDispatcher != null) {
            return this.mockRpcDispatcher.getViewAddresses();
        }
        JChannel channel = this.rpcDispatcher.getChannel();
        View view = channel.getView();
        return view != null ? view.getMembers() : Collections.emptyList();
    }

    public Address getLocalAddress() {
        if (this.mockRpcDispatcher != null) {
            return this.mockRpcDispatcher.getAddress();
        }
        return this.rpcDispatcher.getChannel().getAddress();
    }

    static StringBuilder getLogStmt(String methodName, Vector<Address> nodes, RpcResponseMode mode) {
        StringBuilder sb = new StringBuilder();
        sb.append("called ").append("mode:").append(mode.toString()).append(" ");
        sb.append(methodName).append("() on ");
        sb.append(nodes == null ? "all nodes" : nodes);
        sb.append(".");
        return sb;
    }

    protected static class MajorityFilter
    implements RspFilter {
        private static final Log log = LogFactory.getLog(MajorityFilter.class);
        private final List<Address> responderNodes = new ArrayList<Address>();
        private final int totalNodes;

        public MajorityFilter(int totalNodes) {
            this.totalNodes = totalNodes;
        }

        public synchronized boolean isAcceptable(Object rspValue, Address sender) {
            if (!this.responderNodes.contains(sender)) {
                this.responderNodes.add(sender);
            }
            return true;
        }

        public synchronized boolean needMoreResponses() {
            return this.responderNodes.size() <= this.totalNodes / 2;
        }
    }

    public static enum LogLevel {
        TRACE,
        DEBUG;

    }
}

