/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.PropertyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.RspList;
import org.sourceid.saml20.service.DistributedStateCoordinator;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodes;
import org.sourceid.saml20.service.impl.grouprpc.ReplicationMode;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;
import org.sourceid.saml20.state.SessionReplicationInfo;
import org.sourceid.saml20.state.StateMgmtFactory;

public abstract class BasePreferredNodesGroupRpc
extends BaseGroupRpc {
    protected PreferredNodes preferredNodes;
    protected boolean adaptiveClusteringCapable = false;
    protected boolean replicationEnabled = false;

    public BasePreferredNodesGroupRpc(String cfgFileName) {
        this.preferredNodes = new PreferredNodes(cfgFileName);
        super.setRpcResponseMode(this.preferredNodes.getRpcResponseMode());
    }

    public BasePreferredNodesGroupRpc(String cfgFileName, boolean adaptiveClusteringCapable, boolean replicationEnabled) {
        this(cfgFileName);
        this.adaptiveClusteringCapable = adaptiveClusteringCapable;
        this.replicationEnabled = replicationEnabled;
    }

    public PreferredNodeGroup getPreferredNodeGroup() {
        return this.preferredNodes.getNodeGroup();
    }

    protected RspList callRemoteMethods(String methodName, Class[] signature, boolean synchronous, Object ... args) {
        return this.callRemoteMethods(methodName, signature, null, synchronous, args);
    }

    protected RspList callRemoteMethods(String methodName, Class[] signature, boolean synchronous, ReplicationMode replicationMode, Object ... args) {
        return this.callRemoteMethods(methodName, signature, null, synchronous, replicationMode, args);
    }

    protected RspList callRemoteMethods(String methodName, Class[] signature, String partitionKey, boolean synchronous, Object ... args) {
        return this.callRemoteMethods(methodName, signature, partitionKey, synchronous, this.rpcResponseMode, ReplicationMode.NOT_REPLICATED, args);
    }

    protected RspList callRemoteMethods(String methodName, Class[] signature, String partitionKey, boolean synchronous, ReplicationMode replicationMode, Object ... args) {
        return this.callRemoteMethods(methodName, signature, partitionKey, synchronous, this.rpcResponseMode, replicationMode, args);
    }

    protected RspList callRemoteMethods(String methodName, Class[] signature, boolean synchronous, RpcResponseMode overrideResponseMode, Object ... args) {
        return this.callRemoteMethods(methodName, signature, null, synchronous, overrideResponseMode, ReplicationMode.NOT_REPLICATED, args);
    }

    protected RspList callRemoteMethods(String methodName, Class[] signature, String partitionKey, boolean synchronous, RpcResponseMode overrideResponseMode, ReplicationMode replicationMode, Object ... args) {
        Vector<Address> nodes;
        MajorityPerGroupFilter rspFilter = null;
        int timeout = this.getRpcTimeout();
        if (this.adaptiveClusteringCapable && PropertyInfo.isAdaptiveClusteringEnabled()) {
            Vector<Address> otherNodeGroupReplicas;
            DistributedStateCoordinator coord = StateMgmtFactory.getDistributedStateCoordinator();
            SessionReplicationInfo replicationInfo = StateMgmtFactory.getSessionReplicationInfo();
            if (partitionKey == null && replicationInfo != null) {
                partitionKey = replicationInfo.getSri();
            }
            if (partitionKey == null) {
                nodes = this.preferredNodes.getPreferredNodes();
                this.log.warn((Object)"SRI not found in thread-local storage, RPC may be sent to all nodes in cluster");
            } else {
                nodes = coord.getReplicas(partitionKey);
            }
            if (nodes != null && this.replicationEnabled && replicationMode != ReplicationMode.NOT_REPLICATED && !(otherNodeGroupReplicas = coord.getOtherNodeGroupReplicas(partitionKey)).isEmpty()) {
                if (replicationMode == ReplicationMode.SYNC) {
                    if (overrideResponseMode == RpcResponseMode.GET_MAJORITY) {
                        overrideResponseMode = RpcResponseMode.GET_ALL;
                        rspFilter = new MajorityPerGroupFilter(coord.getNodeGroupReplicas(partitionKey));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("callRemoteMethods(" + methodName + "): adding replicas in other node groups to recipients [" + this.getAddressList(otherNodeGroupReplicas) + "]"));
                    }
                    nodes.addAll(otherNodeGroupReplicas);
                } else if (replicationMode == ReplicationMode.ASYNC) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("callRemoteMethods(" + methodName + "): sending RPC to replicas in other node groups [" + this.getAddressList(otherNodeGroupReplicas) + "]"));
                    }
                    this.callRemoteMethods(otherNodeGroupReplicas, methodName, signature, false, overrideResponseMode, null, timeout, args);
                } else if (replicationMode == ReplicationMode.CACHE_ACCESS) {
                    if (replicationInfo == null) {
                        this.log.warn((Object)"Session replication info not found in thread-local storage, cache access event will not be replicated");
                    } else if (!replicationInfo.isCacheAccessEventReplicated()) {
                        replicationInfo.setCacheAccessEventReplicated(true);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Replicating cache access event for SRI " + replicationInfo.getSri()));
                        }
                        StateMgmtFactory.getDistributedStateCoordinator().replicateCacheAccess(replicationInfo.getPrimarySessionId(), replicationInfo.getExtendedSessionId());
                    }
                }
            }
        } else {
            nodes = this.preferredNodes.getPreferredNodes();
        }
        return super.callRemoteMethods(nodes, methodName, signature, synchronous, overrideResponseMode, rspFilter, timeout, args);
    }

    protected String getAddressList(Vector<Address> nodes) {
        return nodes.stream().map(node -> node.toString()).collect(Collectors.joining(","));
    }

    protected int getRpcTimeout() {
        return this.preferredNodes.getTimeout();
    }

    protected static class MajorityPerGroupFilter
    implements RspFilter {
        private static final Log log = LogFactory.getLog(MajorityPerGroupFilter.class);
        private final Map<String, Vector<Address>> nodeGroupReplicas;
        private final List<Address> receivedResponses = new ArrayList<Address>();
        private final Map<String, Integer> neededResponses = new HashMap<String, Integer>();

        public MajorityPerGroupFilter(Map<String, Vector<Address>> nodeGroupReplicas) {
            this.nodeGroupReplicas = nodeGroupReplicas;
            for (Map.Entry<String, Vector<Address>> entry : nodeGroupReplicas.entrySet()) {
                this.neededResponses.put(entry.getKey(), entry.getValue().isEmpty() ? 0 : entry.getValue().size() / 2 + 1);
            }
        }

        public synchronized boolean isAcceptable(Object rspValue, Address sender) {
            String nodeGroupId = this.getNodeGroupId(sender);
            if (nodeGroupId == null) {
                return false;
            }
            if (!this.receivedResponses.contains(sender)) {
                this.receivedResponses.add(sender);
                Integer remaining = this.neededResponses.get(nodeGroupId);
                if (remaining != null) {
                    this.neededResponses.put(nodeGroupId, remaining - 1);
                }
            }
            return true;
        }

        public synchronized boolean needMoreResponses() {
            boolean result = this.neededResponses.values().stream().anyMatch(needed -> needed > 0);
            if (!result && log.isDebugEnabled()) {
                log.debug((Object)"Responses received from a majority of recipients in all node groups");
            }
            return result;
        }

        private String getNodeGroupId(Address address) {
            for (Map.Entry<String, Vector<Address>> entry : this.nodeGroupReplicas.entrySet()) {
                if (!entry.getValue().contains(address)) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

